<?php
/* SVN FILE: $Id: rkt_account.php 481 2008-05-23 16:38:07Z bb_yujiro $ */
/**
 *  アカウント（状態）管理
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 481 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:38:07 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 *  アカウント（状態）管理クラス
 *
 * @category        hitSuji Core
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 481 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:38:07 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_account
{
    /**
     * アカウントキー
     * @const string
     */
    const ACCOUNT_KEY = '_account';

    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * アカウント情報
     * @var array
     */
    private $_account = array();

    /**
     * コンストラクタ
     *
     * @access public
     */
    private function __construct()
    {
        $this->_account = array(
            'id'              => 0,
            'modified'        => '2008-05-15 00:00:00',
            'last_login'      => '2008-05-15 00:00:00',
            'regist_date'     => '2008-05-15 00:00:00',
            'avail'           => STATUS_ENABLE,
            'status'          => STATUS_GUEST,
            'hashed_password' => '',
            'email'           => '',
            'hashed_email'    => '',
            'news'            => 0,
            'mailing'         => 0,
            'footprint'       => 0,
            'access_number'   => 0,
            'friend_number'   => 0,
            'block'           => '',
            'ref_theme'       => DEFAULT_THEME,
        );
    }

    /**
     * 実行処理スタテック版
     *
     * @access public
     * @return object
     *
     * RKT_account::exec()->getAccount();
     *
     */
    public static function exec()
    {
        if (!isset(self::$_instance)) {
            $classname = __CLASS__;
            self::$_instance = new $classname();
            self::$_instance->loadAccount();
        }
        return self::$_instance;
    }

    /**
     * アカウントの読み込み
     *
     * @access public
     * @return void
     */
    public function loadAccount()
    {
        if (!empty($_SESSION[self::ACCOUNT_KEY])){
            $this->_account = $_SESSION[self::ACCOUNT_KEY];
        }
    }

    /**
     * アカウント削除
     *
     * @access public
     * @return void
     */
    public function accountDestroy()
    {
        $this->_account = array(
            'id'       => 0,
            'name'     => _('Guest'),
            'status'   => STATUS_GUEST,
            'ref_theme'=> DEFAULT_THEME,
        );
        $_SESSION[self::ACCOUNT_KEY] = $this->_account;
    }

    /**
     * ユーザー情報の取得
     *
     * @access public
     * @return mixed ユーザー情報
     */
    public function getAccount()
    {
        return $this->_account;
    }

    /**
     * アカウントIDの取得
     *
     * @access public
     * @return integer アカウントID
     */
    public function getAccountID()
    {
        return $this->_account['id'];
    }

    /**
     * 状態の取得
     *
     * @access public
     * @return string 状態
     */
    public function getStatus()
    {
        return $this->_account['status'];
    }

    /**
     * 管理者権限の有無
     *
     * @access public
     * @return boolean 管理者権限の有無
     */
    public function isAdmin()
    {
        if ($this->_account['status'] != STATUS_ADMIN){
            return false;
        }

        return true;
    }

    /**
     * ユーザー情報を取得しメンバ変数へ
     *
     * @access public
     * @param integer $id
     * @return boolean 正常時：真
     */
    public function setAccount($id)
    {
        $sql = 'SELECT * FROM '.DB_PREFIX.'act_account '.
               'WHERE id = :id AND avail = '.STATUS_ENABLE;
        $stmt = RKT_DB::exec()->prepare($sql); 
        $stmt->execute(array(':id'=> $id));
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            return false;
        }
        $this->_account = $result;

        /* セッションの中身を更新 */
        session_regenerate_id(true);
        $_SESSION[self::ACCOUNT_KEY] = $this->_account;

        return true;
    }
} // RKT_accountの終了
?>
