<?php
/* SVN FILE: $Id: Yahoo.php 328 2008-05-11 01:10:11Z bb_yujiro $ */
/**
 * 形態素解析（Morphological Analysis）
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 328 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:10:11 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require_once LIB_DIR.'PEAR/HTTP/Request.php';

/**
 * Text_MA_Yahooクラス
 *
 * @category        Morphological Analysis
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 328 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:10:11 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_MA_Yahoo extends Text_MA_Common
{
    /**
     * サービスURL
     * @const string
     */
    const SERVICES_URL = 'http://api.jlp.yahoo.co.jp/MAService/V1/parse';

    /**********************************/
    /**
     * "ma": 形態素解析の結果を ma_result に返します。
     * @const string
     */
    const RESULTS_MA   = 'ma';

    /**
     * "uniq": 出現頻度情報を uniq_result に返します。
     * @const string
     */
    const RESULTS_UNIQ = 'uniq';

    /**********************************/
    /**
     * 形態素の表記を返します。
     * @const string
     */
    const RESPONSE_SURFACE  = 'surface';

    /**
     * 形態素の読みがなを返します。
     * @const string
     */
    const RESPONSE_READING  = 'reading';

    /**
     * 形態素の品詞を返します。
     * @const string
     */
    const RESPONSE_POS      = 'pos';

    /**
     * 形態素の基本形表記を返します。活用のない形態素の場合は省略されます。
     * @const string
     */
    const RESPONSE_BASEFORM = 'baseform';

    /**
     * 形態素の全情報を文字列で返します。
     * @const string
     */
    const RESPONSE_FEATURE  = 'feature';

    /**
     * アプリケーションID
     * @var string
     */
    private $_appid;

    /**
     * 解析結果の種類
     * @var string
     */
    private $_results;

    /**
     * 返される形態素情報
     * @var string
     */
    private $_response;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->_appid    = 'rktSNS@rakuto.net';
        $this->_results  = self::RESULTS_UNIQ;
        $this->_response = self::RESPONSE_SURFACE.','.
                           self::RESPONSE_POS;
    }

    /**
     * アプリケーションID
     *
     * @access public
     * @param string $appid
     * @return void
     **/
    public function setAppID($appid)
    {
        $this->_appid = $appid;
    }

    /**
     * 解析結果の設定
     *
     * @access public
     * @param string $results
     * @return void
     **/
    public function setResults($results)
    {
        $this->_results = $results;
    }

    /**
     * 返される形態素情報の設定
     *
     * @access public
     * @param string $response
     * @return void
     **/
    public function setResponse($response)
    {
        $this->_response = $response;
    }

    /**
     * 形態素解析
     *
     * @access public
     * @return void
     **/
    public function parse()
    {
        $request = new HTTP_Request(self::SERVICES_URL);

        $request->setMethod(HTTP_REQUEST_METHOD_POST);
        $request->addPostData('appid',    $this->_appid);
        $request->addPostData('sentence', $this->sentence);
        $request->addPostData('results',  $this->_results);
        $request->addPostData('response', $this->_response);
        $request->addPostData('filter',   $this->filter);

        $result = $request->sendRequest();
        if (PEAR::isError($result)) {
            throw new Exception ($result->getMessage());
        }
        /* Responseコードの判定 */
        $this->_parseResponseCode($request->getResponseCode());

        $body = $request->getResponseBody();
        $this->_parseXML($body);
    }

    /**
     * Responseコードの判定
     *
     * @access private
     * @param string $code
     * @return boolean
     **/
    private function _parseResponseCode($code)
    {
        $errors = array(
            '400'=> 'Bad request.', 
            '403'=> 'Forbidden.',
            '503'=> 'Service unavailable.'
        );
        if (!empty($errors[$code])){
            throw new Exception ($errors[$code]);
        }
    }

    /**
     * 結果のXML解析
     *
     * @access private
     * @param string $body
     * @return boolean
     **/
    private function _parseXML($body)
    {
        $xml = simplexml_load_string($body);
        if ($xml === false){
            throw new Exception ('Invalid XML.');
        }

        $this->total = $xml->uniq_result->filtered_count;
        foreach ($xml->uniq_result->word_list->word as $word) {
            $this->parsed[] = $word;
        }
    }

} // class Text_MA_Yahoo
?>
