<?php
/* SVN FILE: $Id: Tag.php 479 2008-05-23 16:36:27Z bb_yujiro $ */
/**
 * 独自タグ用絵文字変換
 *
 * 参考資料：
 *       [絵文字の相互変換リスト] http://labs.unoh.net/2007/02/post_65.html
 *
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 独自タグ用絵文字変換
 *
 * @category        Emoji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_Emoji_Tag
{
    /**
     * Imgタグから独自タグへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2tag($dec)
    {
        return '[m:'.$dec.']';
    }

    /**
     * タグから独自Imgタグへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2img($dec)
    {
        return '<img src="'.BASE_URL.'resource/img/emoji/'.$dec.'.gif">';
    }

    /**
     * 独自タグからShift_JIS DoCoMoへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2docomo($dec)
    {
        $map = array(
              '1'=>'F9DC',                            '2'=>'F9A7',            '3'=>'8148',              '4'=>'F986',            '5'=>'3c',
              '6'=>'3e',                              '7'=>'3c3c',                  '8'=>'3e3e',              '9'=>'81a1',                 '10'=>'81a1',
             '11'=>'5b695d',                         '12'=>'F9FB',           '13'=>'5b83588373815b834a5d',     '14'=>'F9BA',           '15'=>'F943',
             '16'=>'F8A3',                           '17'=>'81a1',                 '18'=>'81a1',             '19'=>'819f',                 '20'=>'819f',
             '21'=>'81a1',                           '22'=>'81a1',                 '23'=>'F940',       '24'=>'F940',           '25'=>'F9C4',
             '26'=>'817b',                           '27'=>'817c',                 '28'=>'8196',             '29'=>'81aa',                 '30'=>'81ab',
             '31'=>'F9DD',                           '32'=>'81a5',                 '33'=>'81a3',             '34'=>'81a5',                 '35'=>'81a3',
             '36'=>'819f',                           '37'=>'819f',                 '38'=>'81a1',             '39'=>'81a1',                 '40'=>'F940',
             '41'=>'F940',                           '42'=>'F8F8',           '43'=>'F8F7',       '44'=>'F89F',           '45'=>'F8B4',
             '46'=>'F95E',                           '47'=>'F942',           '48'=>'F9B8',       '49'=>'83d3',                 '50'=>'F995',
             '51'=>'F991',                           '52'=>'F8D2',           '53'=>'F9E6',       '54'=>'F9D7',           '55'=>'817e',
             '56'=>'F8EA',                           '57'=>'F9C1',           '58'=>'F9C1',       '59'=>'5b8374838d83628373815b5d',       '60'=>'5b90e18c8b8fbb5d',
             '61'=>'817e',                           '62'=>'817e',                 '63'=>'81a8',             '64'=>'81a9',                 '65'=>'F8D3',
             '66'=>'8180',                           '67'=>'5b834a838c8393835f815b5d',       '68'=>'F995',       '69'=>'8199',                 '70'=>'F8D9',
             '71'=>'F949',                           '72'=>'F9C0',           '73'=>'5b836083468362834e5d',     '74'=>'F945',           '75'=>'81999c63',
             '76'=>'F99F',                           '77'=>'F9A0',           '78'=>'F9F4',       '79'=>'5b83748348838b835f5d',         '80'=>'F995',
             '81'=>'F9D6',                           '82'=>'F9DB',           '83'=>'F8E3',       '84'=>'5b83748348838b835f5d',         '85'=>'F8E8',
             '86'=>'5b8374834c835f83565d',           '87'=>'5b834a815b83685d',           '88'=>'81a3',             '89'=>'81a5',                 '90'=>'5b5553415d',
             '91'=>'F8E4',                           '92'=>'F8EA',           '93'=>'F8D1',       '94'=>'F8E2',           '95'=>'F8A1',
             '96'=>'5b837483628367837b815b838b5d',   '97'=>'F8E4',           '98'=>'F9D4',       '99'=>'F8CE',          '100'=>'F8E4',
            '101'=>'F8E4',                          '102'=>'F8E4',          '103'=>'F8EA',      '104'=>'F8D6',          '105'=>'5b834a838c8393835f815b5d',
            '106'=>'F8DF',                          '107'=>'F8A0',          '108'=>'F977',      '109'=>'F97A',          '110'=>'F8D8',
            '111'=>'F8D8',                          '112'=>'F8C4',          '113'=>'F9E8',      '114'=>'5b95ef929a5d',            '115'=>'5b8372836683495d',
            '116'=>'F8FB',                          '117'=>'84a481a8',              '118'=>'F97E',      '119'=>'F981',          '120'=>'F97D',
            '121'=>'F8E4',                          '122'=>'F8E4',          '123'=>'5b836c83575d',        '124'=>'F8D5',          '125'=>'F8BF',
            '126'=>'5b8374838d83628373815b5d',      '127'=>'5b834f838983745d',          '128'=>'5b834f838983745d',      '129'=>'F8C6',          '130'=>'F9A0',
            '131'=>'F8E4',                          '132'=>'5b836083468362834e837d815b834e5d',  '133'=>'F9EC',      '134'=>'F945',          '135'=>'5b936492725d',
            '136'=>'F9AF',                          '137'=>'5b89e682d182e582a45d',        '138'=>'F97D',      '139'=>'F9BA',          '140'=>'81a9',
            '141'=>'81a8',                          '142'=>'F8E4',          '143'=>'F9D5',      '144'=>'F8E6',          '145'=>'5b96bc8e445d',
            '146'=>'F8D0',                          '147'=>'F8E4',          '148'=>'5b836783898362834e5d',    '149'=>'F9BE',          '150'=>'5b5044435d',
            '151'=>'F973',                          '152'=>'F9BD',          '153'=>'5b9197904d424f585d',     '154'=>'5b8ef3904d424f585d',         '155'=>'F8E8',
            '156'=>'F8C5',                          '157'=>'5b92e88b4b5d',            '158'=>'5b8e4f8a7092e88b4b5d',    '159'=>'5b834f838983745d',          '160'=>'5b93f75d',
            '161'=>'F8E9',                          '162'=>'5b83528393835a839383675d',      '163'=>'5b89c691b05d',        '164'=>'5b838a8393834e5d',          '165'=>'F8E6',
            '166'=>'F974',                          '167'=>'2569312525693225',          '168'=>'F8C3',      '169'=>'F947',          '170'=>'5b835483438352838d5d',
            '171'=>'5b905695b75d',                  '172'=>'F8BC',          '173'=>'8140',            '174'=>'',                  '175'=>'',
            '176'=>'F8E0',                          '177'=>'F8E1',          '178'=>'F8FC',      '179'=>'5b8ee19774837d815b834e5d',      '180'=>'F987',
            '181'=>'F988',                          '182'=>'F989',          '183'=>'F98A',      '184'=>'F98B',          '185'=>'F98C',
            '186'=>'F98D',                          '187'=>'F98E',          '188'=>'F98F',      '189'=>'5b31305d',              '190'=>'F8A4',
            '191'=>'F8A2',                          '192'=>'F8A7',          '193'=>'F8A8',      '194'=>'F8A9',          '195'=>'F8AA',
            '196'=>'F8AB',                          '197'=>'F8AC',          '198'=>'F8AD',      '199'=>'F8AE',          '200'=>'F8AF',
            '201'=>'F8B0',                          '202'=>'F8B1',          '203'=>'F8B2',      '204'=>'5b8ed68e678dc05d',          '205'=>'F8C9',
            '206'=>'F8CB',                          '207'=>'F8CF',          '208'=>'F8CD',      '209'=>'5b836f835892e25d',          '210'=>'5b83418393836583695d',
            '211'=>'F8C2',                          '212'=>'F8C8',          '213'=>'F8CC',      '214'=>'5b926e907d5d',            '215'=>'F9C2',
            '216'=>'F8C1',                          '217'=>'F8BE',          '218'=>'F9D8',      '219'=>'F8B7',          '220'=>'F8B6',
            '221'=>'F9B7',                          '222'=>'F8BA',          '223'=>'5b8acf97978ed45d',      '224'=>'F99C',          '225'=>'F9F0',
            '226'=>'F950',                          '227'=>'F957',          '228'=>'5b938c8b9e835e838f815b5d',  '229'=>'5b3737375d',             '230'=>'5b834983818366836783455d',
            '231'=>'5b934992865d',                  '232'=>'F8EC',          '233'=>'F9BA',      '234'=>'F948',          '235'=>'F9ED',
            '236'=>'5b82a889bb82af5d',              '237'=>'5b93fa82cc8adb5d',          '238'=>'5b83588343834a5d',      '239'=>'F9EF',          '240'=>'5b837483898343837083935d',
            '241'=>'F9E7',                          '242'=>'F9F6',          '243'=>'5b8343836083535d',      '244'=>'F9EE',          '245'=>'F8D4',
            '246'=>'5b834e835783895d',              '247'=>'5b83458354834d5d',          '248'=>'F9F9',      '249'=>'5b8354838b5d',            '250'=>'5b834a8347838b5d',
            '251'=>'F946',                          '252'=>'F9F5',          '253'=>'5b8341838a5d',        '254'=>'F9FA',          '255'=>'5b8372815b83605d',
            '256'=>'5b82d082dc82ed82e85d',          '257'=>'F995',          '258'=>'F996',      '259'=>'F9D2',          '260'=>'F9D0',
            '261'=>'F9A6',                          '262'=>'F9A1',          '263'=>'F9AC',      '264'=>'F9CD',          '265'=>'F993',
            '266'=>'F994',                          '267'=>'F99F',          '268'=>'F9A3',      '269'=>'5b898a5d',              '270'=>'5b534f535d',
            '271'=>'5b97cd82b182d45d',              '272'=>'F991',          '273'=>'F99E',      '274'=>'5b89469288906c5d',          '275'=>'F8A4',
            '276'=>'F8F9',                          '277'=>'5b8341834e837d5d',          '278'=>'5b89d48adb5d',        '279'=>'F9D9',          '280'=>'5b313030935f5d',
            '281'=>'F9A2',                          '282'=>'F9AD',          '283'=>'5b8345839383605d',      '284'=>'5b906c8db782b58e775d',        '285'=>'5b93be5d',
            '286'=>'5b8368834e838d5d',              '287'=>'F9CC',          '288'=>'F8EB',      '289'=>'F8D7',          '290'=>'F9B4',
            '291'=>'F9A4',                          '292'=>'5b834d835e815b5d',          '293'=>'5b836f83438349838a83935d',  '294'=>'F8DB',          '295'=>'F9B5',
            '296'=>'5b837383588367838b5d',          '297'=>'5b8347835883655d',          '298'=>'5b455a5d',          '299'=>'F97B',          '300'=>'F8ED',
            '301'=>'F9B3',                          '302'=>'5b55464f5d',             '303'=>'5b5550215d',         '304'=>'5b928d8ecb5d',            '305'=>'F8A5',
            '306'=>'F8B5',                          '307'=>'F8B9',          '308'=>'F8BB',      '309'=>'F8DC',          '310'=>'5b89898c805d',
            '311'=>'F8DE',                          '312'=>'F8E5',          '313'=>'F8E7',      '314'=>'F8EF',          '315'=>'F8F0',
            '316'=>'F8F1',                          '317'=>'F8F2',          '318'=>'F8F3',      '319'=>'F8F5',          '320'=>'F8F6',
            '321'=>'F940',                          '322'=>'F941',          '323'=>'F942',      '324'=>'F980',          '325'=>'F990',
            '326'=>'F9B0',                          '327'=>'F999',          '328'=>'F992',      '329'=>'F9AA',          '330'=>'F9AB',
            '331'=>'5b657a706c75735d',              '332'=>'5b926e8b855d',            '333'=>'F9F1',      '334'=>'F982',          '335'=>'F9B3',
            '336'=>'F8FA',                          '337'=>'F9BB',          '338'=>'5b8389835783495d',      '339'=>'5b836f83895d',            '340'=>'5b8bb389ef5d',
            '341'=>'F8BD',                          '342'=>'F9E5',          '343'=>'F99B',      '344'=>'5b93568e675d',            '345'=>'5b836783895d',
            '346'=>'5b834e837d5d',                  '347'=>'5b836c8359837e5d',          '348'=>'F9CE',      '349'=>'F9CB',          '350'=>'F9FC',
            '351'=>'F9C8',                          '352'=>'5b835e83525d',            '353'=>'5b838d8350836283675d',    '354'=>'F9BF',          '355'=>'F99E',
            '356'=>'5b836e8393837d815b5d',          '357'=>'5b89d489ce5d',            '358'=>'F9EC',      '359'=>'F8E3',          '360'=>'5b95ac90855d',
            '361'=>'5b834c8383839383765d',          '362'=>'5b9683909d5d',            '363'=>'5b56535d',          '364'=>'5b8367838d83748342815b5d',      '365'=>'5b834a83815d',
            '366'=>'5b83588379834383935d',          '367'=>'5b838d835683415d',          '368'=>'5b8d488e9692865d',      '369'=>'F99C',          '370'=>'5b8f6a93fa5d',
            '371'=>'5b975b8fc482af5d',              '372'=>'F9F4',          '373'=>'5b8a9489bf5d',        '374'=>'5b8c788aaf5d',            '375'=>'F8C6',
            '376'=>'F8C7',                          '377'=>'F9E3',          '378'=>'F8CA',      '379'=>'F8C2',          '380'=>'5b31388bd65d',
            '381'=>'5b836f838a335d',                '382'=>'5b434f4f4c5d',            '383'=>'5b8a845d',          '384'=>'5b8354815b837283585d',        '385'=>'F97C',
            '386'=>'F9E0',                          '387'=>'F9DE',          '388'=>'5b8e775d',          '389'=>'5b89635d',              '390'=>'81aa',
            '391'=>'81ab',                          '392'=>'5b90e882a25d',            '393'=>'5b837d8369815b8382815b83685d272c27333934273d3e275b8350815b835e83434f46465d',     '395'=>'F8EA',
            '396'=>'5b836c834e835e83435d',          '397'=>'5b836e834383728358834a83585d',    '398'=>'5b89d491a95d',        '399'=>'5b8354837b836583935d',        '400'=>'F9F0',
            '401'=>'F8D3',                          '402'=>'5b8f6a5d',              '403'=>'5b96f25d',          '404'=>'5b959791445d',            '405'=>'5b834e83898362834a815b5d',
            '406'=>'5b455a836983725d',              '407'=>'5b96588e715d',            '408'=>'5b8375815b83635d',      '409'=>'5b837d836a834c838583415d',      '410'=>'5b94fc976589405d',
            '411'=>'5b8fb089ae5d',                  '412'=>'5b928595a85d',            '413'=>'5b8372834c836a5d',      '414'=>'F8EE',          '415'=>'F991',
            '416'=>'F991',                          '417'=>'F991',          '418'=>'F991',      '419'=>'F991',          '420'=>'F99F',
            '421'=>'F8B8',                          '422'=>'F944',          '423'=>'F9C3',      '424'=>'F9F2',          '425'=>'5b835c83748367834e838a815b83805d',
            '426'=>'5b837c836583675d',              '427'=>'5b82be82f182b25d',          '428'=>'5b82b982f182d782a25d',    '429'=>'F9F1',          '430'=>'5b83708358835e5d',
            '431'=>'5b834a838c815b5d',              '432'=>'5b82a882c582f15d',          '433'=>'5b82b782b55d',        '434'=>'F9EA',          '435'=>'5b82dd82a982f15d',
            '436'=>'5b8367837d83675d',              '437'=>'5b836983585d',            '438'=>'5b95d993965d',        '439'=>'5b93e75d',              '440'=>'F9D1',
            '441'=>'F9C5',                          '442'=>'F9F8',          '443'=>'F9D0',      '444'=>'F998',          '445'=>'F9A6',
            '446'=>'F9C6',                          '447'=>'F9FC',          '448'=>'5b95978ed782d082ab5d',    '449'=>'5b944d5d',              '450'=>'F9CA',
            '451'=>'F999',                          '452'=>'F9C8',          '453'=>'F9A4',      '454'=>'F995',          '455'=>'283e82523c29',
            '456'=>'28814c8252814d29',              '457'=>'5b95405d',              '458'=>'F99E',      '459'=>'283e906c3c29',            '460'=>'5b948f8ee85d',
            '461'=>'F9B0',                          '462'=>'F9A5',          '463'=>'F8F6',      '464'=>'F9D4',          '465'=>'F9B0',
            '466'=>'6d285f205f296d',                '467'=>'F992',          '468'=>'5b836f836a815b5d',      '469'=>'5b8367838983938379836283675d',    '470'=>'5b8372838a8384815b83685d',
            '471'=>'5b9085896a5d',                  '472'=>'5b8fc196688ed45d',          '473'=>'5b8b7e8b7d8ed45d',      '474'=>'5b83708367834a815b5d',        '475'=>'5b83578346836283678352815b8358835e815b5d',
            '476'=>'5b96e58fbc5d',                  '477'=>'5b82d082c88dd582e85d',        '478'=>'5b91b28bc68eae5d',      '479'=>'5b838983938368835a838b5d',      '480'=>'5b82b182a282cc82da82e85d',
            '481'=>'F8A6',                          '482'=>'5b89d489c55d',            '483'=>'5b834a834c95585d',      '484'=>'5b90fc8d8189d489ce5d',        '485'=>'5b8aaa8a4c5d',
            '486'=>'5b959797e95d',                  '487'=>'5b836e838d8345834283935d',      '488'=>'5b82a88c8e8ca95d',      '489'=>'5b83548393835e5d',          '490'=>'F957',
            '491'=>'5b93f85d',                      '492'=>'F8CA',          '493'=>'F89F',      '494'=>'F8DD',          '495'=>'5b83668370815b83675d',
            '496'=>'5b8fe95d',                      '497'=>'5b8fe95d',              '498'=>'5b8d488fea5d',        '499'=>'5b83748389839383585d',        '500'=>'5b8349815b837683938345834683755d',
            '501'=>'5b834a834d5d',                  '502'=>'5b414243445d',            '503'=>'5b616263645d',        '504'=>'5b313233345d',            '505'=>'5b8b4c8d865d',
            '506'=>'5b89c25d',                      '507'=>'5b836083468362834e837d815b834e5d',  '508'=>'F952',      '509'=>'5b838983578349837b835e83935d',    '510'=>'F981',
            '511'=>'5b81a94241434b5d',              '512'=>'5b83758362834e837d815b834e5d',    '513'=>'F972',      '514'=>'F8C4',          '515'=>'F8C6',
            '516'=>'F8EA',                          '517'=>'F97D',          '518'=>'F9DA',      '700'=>'5b8368834383635d',          '701'=>'5b8343835e838a83415d',
            '702'=>'5b8343834d838a83585d',          '703'=>'5b92868d915d',            '704'=>'5b8ad88d915d',        '705'=>'5b9492906c5d',            '706'=>'5b92868d91906c5d',
            '707'=>'5b834383938368906c5d',          '708'=>'5b82a882b682a282b382f15d',      '709'=>'5b82a882ce82a082b382f15d',  '710'=>'5b90d482bf82e182f15d',        '711'=>'5b8d488e968cbb8fea82cc906c5d',
            '712'=>'5b82a89550976c5d',              '713'=>'5b8343838b834a5d',          '714'=>'5b835f839383585d',      '715'=>'F9F6',          '716'=>'5b83518357835183575d',
            '717'=>'5b835d83455d',                  '718'=>'5b8352834183895d',          '719'=>'5b8b8d5d',          '720'=>'5b837783725d',            '721'=>'5b836a838f8367838a5d',
            '722'=>'5b8343836d835683565d',          '723'=>'5b8389834e835f5d',          '724'=>'5b415d',           '725'=>'5b425d',               '726'=>'5b4f5d',
            '727'=>'5b41425d',                      '728'=>'F8F9',          '729'=>'F8FA',      '730'=>'F983',          '731'=>'F99A',
            '732'=>'F9A5',                          '733'=>'F9A8',          '734'=>'F9A9',      '735'=>'F9AF',          '736'=>'5b8381838d83935d',
            '737'=>'5b83708343836983628376838b5d',  '738'=>'5b8375836883455d',          '739'=>'F9E9',      '740'=>'5b82c682a482e082eb82b182b55d',    '741'=>'5b834c836d83525d',
            '742'=>'5b8c495d',                      '743'=>'5b838283825d',            '744'=>'5b82e282ab82a282e05d',    '745'=>'5b837383555d',            '746'=>'5b8360834c83935d',
            '747'=>'5b8eb5975b5d',                  '748'=>'F8D2',          '749'=>'5b92435d',          '750'=>'5b83738341836d5d',          '751'=>'F9B7',
            '752'=>'F9F6',                          '753'=>'5b837b815b838a8393834f5d',      '754'=>'5b82c882dc82cd82b05d',    '755'=>'5b93568be75d',            '756'=>'5b83708393835f5d',
            '757'=>'F9CD',                          '758'=>'F9FA',          '759'=>'5b89d45d',          '760'=>'5b834183438358834e838a815b83805d',  '761'=>'5b8368815b836983635d',
            '762'=>'5b834e8362834c815b5d',          '763'=>'5b8360838783525d',          '764'=>'5b834c83838393836683425d',  '765'=>'5b834c83838393836683425d',      '766'=>'282f5f815f29',
            '767'=>'288145817e814529',              '768'=>'7c288145817e8145297c',        '769'=>'5b89ce8e525d',        '770'=>'F991',          '771'=>'5b4142435d',
            '772'=>'5b8376838a83935d',              '773'=>'5b837e8363836f83605d',        '774'=>'5b82c482f182c682a4928e5d',  '775'=>'5b836e8360837e83635d',        '776'=>'F9EA',
            '777'=>'5b94f282f182c582a282ad8be05d',  '778'=>'5b834e8389834e83895d',        '779'=>'F9C9',      '780'=>'F9C9',          '781'=>'F957',
            '782'=>'28814c8252814d29',              '783'=>'F995',          '784'=>'F973',      '785'=>'F9CF',          '786'=>'F9CF',
            '787'=>'F9CB',                          '788'=>'F998',          '789'=>'F998',      '790'=>'F9D3',          '791'=>'F9D3',
            '792'=>'F9F8',                          '793'=>'5b8368838c83585d',          '794'=>'5b8382834183435d',      '795'=>'5b89775d',              '796'=>'5b89d48e445d',
            '797'=>'5b83578387815b834a815b5d',      '798'=>'5b834783728374838983435d',      '799'=>'F977',      '800'=>'F9D8',          '801'=>'5b83708367834a815b5d',
            '802'=>'5b455a8380815b8372815b5d',      '803'=>'F992',          '804'=>'F9F4',      '805'=>'F9B6',          '806'=>'F9BC',
            '807'=>'F9DA',                          '808'=>'F9E1',          '809'=>'F9E2',      '810'=>'F9E4',          '811'=>'F9EB',
            '812'=>'F9F3',                          '813'=>'F9F8',          '814'=>'F9F8',      '815'=>'5b438381815b838b5d',         '816'=>'F9E6',
            '817'=>'F8F4',                          '818'=>'F985',          '819'=>'285e2d5e292f',        '820'=>'815f285e6f5e29815e',         '821'=>'F998',
            '822'=>'F9C9',
        );
        return empty($map[$dec])?'':pack('H*', $map[$dec]);
    }

    /**
     * 独自タグからShift_JIS EZwebへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2ezweb($dec)
    {
        $map = array(
              '1'=>'F659',      '2'=>'F65A',      '3'=>'F65B',      '4'=>'F748',      '5'=>'F749',
              '6'=>'F74A',      '7'=>'F74B',      '8'=>'F74C',      '9'=>'F74D',     '10'=>'F74E',
             '11'=>'F74F',     '12'=>'F69A',     '13'=>'F6EA',     '14'=>'F796',     '15'=>'F65E',
             '16'=>'F65F',     '17'=>'F750',     '18'=>'F751',     '19'=>'F752',     '20'=>'F753',
             '21'=>'F754',     '22'=>'F755',     '23'=>'F756',     '24'=>'F757',     '25'=>'F797',
             '26'=>'F758',     '27'=>'F759',     '28'=>'F75A',     '29'=>'F75B',     '30'=>'F75C',
             '31'=>'F75D',     '32'=>'F75E',     '33'=>'F75F',     '34'=>'F760',     '35'=>'F761',
             '36'=>'F762',     '37'=>'F763',     '38'=>'F764',     '39'=>'F765',     '40'=>'F766',
             '41'=>'F767',     '42'=>'F768',     '43'=>'F769',     '44'=>'F660',     '45'=>'F693',
             '46'=>'F7B1',     '47'=>'F661',     '48'=>'F6EB',     '49'=>'F77C',     '50'=>'F6D3',
             '51'=>'F7B2',     '52'=>'F69B',     '53'=>'F6EC',     '54'=>'F76A',     '55'=>'F76B',
             '56'=>'F77D',     '57'=>'F798',     '58'=>'F654',     '59'=>'F77E',     '60'=>'F662',
             '61'=>'F76C',     '62'=>'F76D',     '63'=>'F76E',     '64'=>'F76F',     '65'=>'F69C',
             '66'=>'F770',     '67'=>'F780',     '68'=>'F6D4',     '69'=>'F663',     '70'=>'F771',
             '71'=>'F772',     '72'=>'F6ED',     '73'=>'F773',     '74'=>'F6B8',     '75'=>'F640',
             '76'=>'F644',     '77'=>'F64E',     '78'=>'F6B9',     '79'=>'F7AC',     '80'=>'F6D5',
             '81'=>'F774',     '82'=>'F775',     '83'=>'F674',     '84'=>'F7AD',     '85'=>'F7B3',
             '86'=>'F6D6',     '87'=>'F799',     '88'=>'F776',     '89'=>'F777',     '90'=>'F790',
             '91'=>'F675',     '92'=>'F781',     '93'=>'F7B4',     '94'=>'F6EE',     '95'=>'F664',
             '96'=>'F694',     '97'=>'F782',     '98'=>'F65C',     '99'=>'F642',    '100'=>'F783',
            '101'=>'F784',    '102'=>'F785',    '103'=>'F786',    '104'=>'F6EF',    '105'=>'F787',
            '106'=>'F676',    '107'=>'F665',    '108'=>'F6FA',    '109'=>'F79A',    '110'=>'F6F0',
            '111'=>'F79B',    '112'=>'F684',    '113'=>'F6BD',    '114'=>'F79C',    '115'=>'F79D',
            '116'=>'F6D7',    '117'=>'F778',    '118'=>'F779',    '119'=>'F6F1',    '120'=>'F6F2',
            '121'=>'F788',    '122'=>'F677',    '123'=>'F79E',    '124'=>'F6F3',    '125'=>'F68A',
            '126'=>'F79F',    '127'=>'F791',    '128'=>'F792',    '129'=>'F6F4',    '130'=>'F7A0',
            '131'=>'F789',    '132'=>'F77A',    '133'=>'F6A7',    '134'=>'F6BA',    '135'=>'F7A1',
            '136'=>'F77B',    '137'=>'F78A',    '138'=>'F6F5',    '139'=>'F7A2',    '140'=>'F6D8',
            '141'=>'F6D9',    '142'=>'F78B',    '143'=>'F678',    '144'=>'F6A8',    '145'=>'F6F6',
            '146'=>'F685',    '147'=>'F78C',    '148'=>'F68B',    '149'=>'F679',    '150'=>'F7A3',
            '151'=>'F7AE',    '152'=>'F7A4',    '153'=>'F7AF',    '154'=>'F7B0',    '155'=>'F6F7',
            '156'=>'F686',    '157'=>'F78D',    '158'=>'F67A',    '159'=>'F793',    '160'=>'F69D',
            '161'=>'F7A5',    '162'=>'F7A6',    '163'=>'F6DA',    '164'=>'F7A7',    '165'=>'F6F8',
            '166'=>'F6F9',    '167'=>'F666',    '168'=>'F68C',    '169'=>'F68D',    '170'=>'F6A1',
            '171'=>'F7A8',    '172'=>'F68E',    '173'=>'F7A9',    '174'=>'F7AA',    '175'=>'F7AB',
            '176'=>'F655',    '177'=>'F656',    '178'=>'F657',    '179'=>'F658',    '180'=>'F6FB',
            '181'=>'F6FC',    '182'=>'F740',    '183'=>'F741',    '184'=>'F742',    '185'=>'F743',
            '186'=>'F744',    '187'=>'F745',    '188'=>'F746',    '189'=>'F747',    '190'=>'F641',
            '191'=>'F65D',    '192'=>'F667',    '193'=>'F668',    '194'=>'F669',    '195'=>'F66A',
            '196'=>'F66B',    '197'=>'F66C',    '198'=>'F66D',    '199'=>'F66E',    '200'=>'F66F',
            '201'=>'F670',    '202'=>'F671',    '203'=>'F672',    '204'=>'F673',    '205'=>'F67B',
            '206'=>'F67C',    '207'=>'F67D',    '208'=>'F67E',    '209'=>'F680',    '210'=>'F681',
            '211'=>'F682',    '212'=>'F683',    '213'=>'F78E',    '214'=>'F78F',    '215'=>'F687',
            '216'=>'F688',    '217'=>'F689',    '218'=>'F643',    '219'=>'F68F',    '220'=>'F690',
            '221'=>'F691',    '222'=>'F692',    '223'=>'F645',    '224'=>'F695',    '225'=>'F696',
            '226'=>'F697',    '227'=>'F698',    '228'=>'F699',    '229'=>'F646',    '230'=>'F647',
            '231'=>'F69E',    '232'=>'F69F',    '233'=>'F6A0',    '234'=>'F6A2',    '235'=>'F6A3',
            '236'=>'F6A4',    '237'=>'F6A5',    '238'=>'F6A6',    '239'=>'F6A9',    '240'=>'F6AA',
            '241'=>'F6AB',    '242'=>'F6AC',    '243'=>'F6AD',    '244'=>'F6AE',    '245'=>'F6AF',
            '246'=>'F648',    '247'=>'F6B0',    '248'=>'F6B1',    '249'=>'F6B2',    '250'=>'F6B3',
            '251'=>'F6B4',    '252'=>'F6B5',    '253'=>'F6B6',    '254'=>'F6B7',    '255'=>'F6BB',
            '256'=>'F6BC',    '257'=>'F649',    '258'=>'F64A',    '259'=>'F64B',    '260'=>'F64C',
            '261'=>'F64D',    '262'=>'F6BE',    '263'=>'F6BF',    '264'=>'F6C0',    '265'=>'F64F',
            '266'=>'F650',    '267'=>'F651',    '268'=>'F652',    '269'=>'F653',    '270'=>'F6C1',
            '271'=>'F6C2',    '272'=>'F6C3',    '273'=>'F6C4',    '274'=>'F6C5',    '275'=>'F6C6',
            '276'=>'F6C7',    '277'=>'F6C8',    '278'=>'F6C9',    '279'=>'F6CA',    '280'=>'F6CB',
            '281'=>'F6CC',    '282'=>'F6CD',    '283'=>'F6CE',    '284'=>'F6CF',    '285'=>'F6D0',
            '286'=>'F6D1',    '287'=>'F6D2',    '288'=>'F6DB',    '289'=>'F6DC',    '290'=>'F6DD',
            '291'=>'F6DE',    '292'=>'F6DF',    '293'=>'F6E0',    '294'=>'F6E1',    '295'=>'F6E2',
            '296'=>'F6E3',    '297'=>'F6E4',    '298'=>'F794',    '299'=>'F795',    '300'=>'F6E5',
            '301'=>'F6E6',    '302'=>'F6E7',    '303'=>'F6E8',    '304'=>'F6E9',    '305'=>'F7B5',
            '306'=>'F7B6',    '307'=>'F7B7',    '308'=>'F7B8',    '309'=>'F7B9',    '310'=>'F7BA',
            '311'=>'F7BB',    '312'=>'F7BC',    '313'=>'F7BD',    '314'=>'F7BE',    '315'=>'F7BF',
            '316'=>'F7C0',    '317'=>'F7C1',    '318'=>'F7C2',    '319'=>'F7C3',    '320'=>'F7C4',
            '321'=>'F7C5',    '322'=>'F7C6',    '323'=>'F7C7',    '324'=>'F7C8',    '325'=>'F7C9',
            '326'=>'F7CA',    '327'=>'F7CB',    '328'=>'F7CC',    '329'=>'F7CD',    '330'=>'F7CE',
            '331'=>'F7CF',    '332'=>'F7D0',    '333'=>'F7D1',    '334'=>'F7E5',    '335'=>'F7E6',
            '336'=>'F7E7',    '337'=>'F7E8',    '338'=>'F7E9',    '339'=>'F7EA',    '340'=>'F7EB',
            '341'=>'F7EC',    '342'=>'F7ED',    '343'=>'F7EE',    '344'=>'F7EF',    '345'=>'F7F0',
            '346'=>'F7F1',    '347'=>'F7F2',    '348'=>'F7F3',    '349'=>'F7F4',    '350'=>'F7F5',
            '351'=>'F7F6',    '352'=>'F7F7',    '353'=>'F7F8',    '354'=>'F7F9',    '355'=>'F7FA',
            '356'=>'F7FB',    '357'=>'F7FC',    '358'=>'F340',    '359'=>'F341',    '360'=>'F342',
            '361'=>'F343',    '362'=>'F344',    '363'=>'F345',    '364'=>'F346',    '365'=>'F347',
            '366'=>'F348',    '367'=>'F349',    '368'=>'F34A',    '369'=>'F34B',    '370'=>'F34C',
            '371'=>'F34D',    '372'=>'F34E',    '373'=>'F34F',    '374'=>'F350',    '375'=>'F351',
            '376'=>'F352',    '377'=>'F353',    '378'=>'F354',    '379'=>'F355',    '380'=>'F356',
            '381'=>'F357',    '382'=>'F358',    '383'=>'F359',    '384'=>'F35A',    '385'=>'F35B',
            '386'=>'F35C',    '387'=>'F35D',    '388'=>'F35E',    '389'=>'F35F',    '390'=>'F360',
            '391'=>'F361',    '392'=>'F362',    '393'=>'F363',    '394'=>'F364',    '395'=>'F365',
            '396'=>'F366',    '397'=>'F367',    '398'=>'F368',    '399'=>'F369',    '400'=>'F36A',
            '401'=>'F36B',    '402'=>'F36C',    '403'=>'F36D',    '404'=>'F36E',    '405'=>'F36F',
            '406'=>'F370',    '407'=>'F371',    '408'=>'F372',    '409'=>'F373',    '410'=>'F374',
            '411'=>'F375',    '412'=>'F376',    '413'=>'F377',    '414'=>'F378',    '415'=>'F379',
            '416'=>'F37A',    '417'=>'F37B',    '418'=>'F37C',    '419'=>'F37D',    '420'=>'F37E',
            '421'=>'F380',    '422'=>'F381',    '423'=>'F382',    '424'=>'F383',    '425'=>'F384',
            '426'=>'F385',    '427'=>'F386',    '428'=>'F387',    '429'=>'F388',    '430'=>'F389',
            '431'=>'F38A',    '432'=>'F38B',    '433'=>'F38C',    '434'=>'F38D',    '435'=>'F38E',
            '436'=>'F38F',    '437'=>'F390',    '438'=>'F391',    '439'=>'F392',    '440'=>'F393',
            '441'=>'F394',    '442'=>'F395',    '443'=>'F396',    '444'=>'F397',    '445'=>'F398',
            '446'=>'F399',    '447'=>'F39A',    '448'=>'F39B',    '449'=>'F39C',    '450'=>'F39D',
            '451'=>'F39E',    '452'=>'F39F',    '453'=>'F3A0',    '454'=>'F3A1',    '455'=>'F3A2',
            '456'=>'F3A3',    '457'=>'F3A4',    '458'=>'F3A5',    '459'=>'F3A6',    '460'=>'F3A7',
            '461'=>'F3A8',    '462'=>'F3A9',    '463'=>'F3AA',    '464'=>'F3AB',    '465'=>'F3AC',
            '466'=>'F3AD',    '467'=>'F3AE',    '468'=>'F3AF',    '469'=>'F3B0',    '470'=>'F3B1',
            '471'=>'F3B2',    '472'=>'F3B3',    '473'=>'F3B4',    '474'=>'F3B5',    '475'=>'F3B6',
            '476'=>'F3B7',    '477'=>'F3B8',    '478'=>'F3B9',    '479'=>'F3BA',    '480'=>'F3BB',
            '481'=>'F3BC',    '482'=>'F3BD',    '483'=>'F3BE',    '484'=>'F3BF',    '485'=>'F3C0',
            '486'=>'F3C1',    '487'=>'F3C2',    '488'=>'F3C3',    '489'=>'F3C4',    '490'=>'F3C5',
            '491'=>'F3C6',    '492'=>'F3C7',    '493'=>'F3C8',    '494'=>'F3C9',    '495'=>'F3CA',
            '496'=>'F3CB',    '497'=>'F3CC',    '498'=>'F3CD',    '499'=>'F3CE',    '500'=>'F7D2',
            '501'=>'F7D3',    '502'=>'F7D4',    '503'=>'F7D5',    '504'=>'F7D6',    '505'=>'F7D7',
            '506'=>'F7D8',    '507'=>'F7D9',    '508'=>'F7DA',    '509'=>'F7DB',    '510'=>'F7DC',
            '511'=>'F7DD',    '512'=>'F7DE',    '513'=>'F7DF',    '514'=>'F7E0',    '515'=>'F7E1',
            '516'=>'F7E2',    '517'=>'F7E3',    '518'=>'F7E4',    '700'=>'F3CF',    '701'=>'F3D0',
            '702'=>'F3D1',    '703'=>'F3D2',    '704'=>'F3D3',    '705'=>'F3D4',    '706'=>'F3D5',
            '707'=>'F3D6',    '708'=>'F3D7',    '709'=>'F3D8',    '710'=>'F3D9',    '711'=>'F3DA',
            '712'=>'F3DB',    '713'=>'F3DC',    '714'=>'F3DD',    '715'=>'F3DE',    '716'=>'F3DF',
            '717'=>'F3E0',    '718'=>'F3E1',    '719'=>'F3E2',    '720'=>'F3E3',    '721'=>'F3E4',
            '722'=>'F3E5',    '723'=>'F3E6',    '724'=>'F3E7',    '725'=>'F3E8',    '726'=>'F3E9',
            '727'=>'F3EA',    '728'=>'F3EB',    '729'=>'F3EC',    '730'=>'F3ED',    '731'=>'F3EE',
            '732'=>'F3EF',    '733'=>'F3F0',    '734'=>'F3F1',    '735'=>'F3F2',    '736'=>'F3F3',
            '737'=>'F3F4',    '738'=>'F3F5',    '739'=>'F3F6',    '740'=>'F3F7',    '741'=>'F3F8',
            '742'=>'F3F9',    '743'=>'F3FA',    '744'=>'F3FB',    '745'=>'F3FC',    '746'=>'F440',
            '747'=>'F441',    '748'=>'F442',    '749'=>'F443',    '750'=>'F444',    '751'=>'F445',
            '752'=>'F446',    '753'=>'F447',    '754'=>'F448',    '755'=>'F449',    '756'=>'F44A',
            '757'=>'F44B',    '758'=>'F44C',    '759'=>'F44D',    '760'=>'F44E',    '761'=>'F44F',
            '762'=>'F450',    '763'=>'F451',    '764'=>'F452',    '765'=>'F453',    '766'=>'F454',
            '767'=>'F455',    '768'=>'F456',    '769'=>'F457',    '770'=>'F458',    '771'=>'F459',
            '772'=>'F45A',    '773'=>'F45B',    '774'=>'F45C',    '775'=>'F45D',    '776'=>'F45E',
            '777'=>'F45F',    '778'=>'F460',    '779'=>'F461',    '780'=>'F462',    '781'=>'F463',
            '782'=>'F464',    '783'=>'F465',    '784'=>'F466',    '785'=>'F467',    '786'=>'F468',
            '787'=>'F469',    '788'=>'F46A',    '789'=>'F46B',    '790'=>'F46C',    '791'=>'F46D',
            '792'=>'F46E',    '793'=>'F46F',    '794'=>'F470',    '795'=>'F471',    '796'=>'F472',
            '797'=>'F473',    '798'=>'F474',    '799'=>'F475',    '800'=>'F476',    '801'=>'F477',
            '802'=>'F478',    '803'=>'F479',    '804'=>'F47A',    '805'=>'F47B',    '806'=>'F47C',
            '807'=>'F47D',    '808'=>'F47E',    '809'=>'F480',    '810'=>'F481',    '811'=>'F482',
            '812'=>'F483',    '813'=>'F484',    '814'=>'F485',    '815'=>'F486',    '816'=>'F487',
            '817'=>'F488',    '818'=>'F489',    '819'=>'F48A',    '820'=>'F48B',    '821'=>'F48C',
            '822'=>'F48D',    '823'=>'F48E',    '824'=>'F48F',    '825'=>'F490',    '826'=>'F491',
            '827'=>'F492',    '828'=>'F493',    
        );
        return empty($map[$dec])?'':pack('H4',$map[$dec]);
    }

    /**
     * 独自タグからWebコード SoftBankへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    public static function tag2softbank($dec)
    {
        $map = array(
              '1'=>'$Fr',            '2'=>'$GA',                '3'=>'$G@',                '4'=>'[Q]',                  '5'=>'$F[',
              '6'=>'$FZ',            '7'=>'$F]',                '8'=>'$F\',                '9'=>'$F;',               '10'=>'$F:',
             '11'=>'[i]',             '12'=>'$Gd',               '13'=>'$Ea',               '14'=>'$EO',               '15'=>'$Gl',
             '16'=>'$E]',           '17'=>'$F;',               '18'=>'$F:',               '19'=>'$F;',               '20'=>'$F;',
             '21'=>'$F;',           '22'=>'$F:',               '23'=>'$F9',               '24'=>'$F9',               '25'=>'[腕時計]',
             '26'=>'＋',              '27'=>'－',                  '28'=>'＊',                  '29'=>'$FR',               '30'=>'$FS',
             '31'=>'[禁止]',          '32'=>'▼',                  '33'=>'▲',                  '34'=>'▼',                  '35'=>'▲',
             '36'=>'$F;',           '37'=>'$F;',               '38'=>'$F;',               '39'=>'$F:',               '40'=>'$F9',
             '41'=>'$F9',           '42'=>'$FW',               '43'=>'$FX',               '44'=>'$Gj',               '45'=>'$G6',
             '46'=>'$GM',           '47'=>'$Gl',               '48'=>'$OE',               '49'=>'φ',                  '50'=>'$G"',
             '51'=>'$GB',           '52'=>'$Gd',               '53'=>'$E0',               '54'=>'$QW',               '55'=>'$OS',
             '56'=>'$O!',           '57'=>'[砂時計]',            '58'=>'[砂時計]',            '59'=>'$O6',               '60'=>'[雪結晶]',
             '61'=>'$OS',           '62'=>'$OS',               '63'=>'$FT',               '64'=>'$FU',               '65'=>'$Gg',
             '66'=>'÷',              '67'=>'[カレンダー]',        '68'=>'$Gv',               '69'=>'$OO',               '70'=>'$FV',
             '71'=>'$FY',           '72'=>'$GT',               '73'=>'[チェックマーク]',    '74'=>'$Gr',               '75'=>'☆彡',
             '76'=>'$ON',           '77'=>'$E/',               '78'=>'$QC',               '79'=>'[フォルダ]',          '80'=>'$G!',
             '81'=>'$Fn',           '82'=>'$Fo',               '83'=>'$OC',               '84'=>'[フォルダ]',          '85'=>'$G)',
             '86'=>'[フキダシ]',      '87'=>'[カード]',            '88'=>'▲',                  '89'=>'▼',                  '90'=>'$Q,',
             '91'=>'$Eh',           '92'=>'$O!',               '93'=>'$Ge',               '94'=>'$G(',               '95'=>'$Gk',
             '96'=>'$PK',           '97'=>'$Eh',               '98'=>'$EW',               '99'=>'$En',              '100'=>'$Eh',
            '101'=>'$Eh',          '102'=>'$Eh',              '103'=>'$O!',              '104'=>'$O3',              '105'=>'[カレンダー]',
            '106'=>'$EE',          '107'=>'$Gi',              '108'=>'$E#',              '109'=>'￥',                 '110'=>'$G]',
            '111'=>'$G]',          '112'=>'$GV',              '113'=>'$O$',              '114'=>'[包丁]',             '115'=>'$EI',
            '116'=>'[メガネ]',       '117'=>'└→',               '118'=>'←┘',               '119'=>'$E4',              '120'=>'$G_',
            '121'=>'$Eh',          '122'=>'$Eh',              '123'=>'[ネジ]',             '124'=>'$E^',              '125'=>'$G;',
            '126'=>'$O6',          '127'=>'$Ej',              '128'=>'$Ej',              '129'=>'$E!',              '130'=>'[懐中電灯]',
            '131'=>'$Eh',          '132'=>'[チェックマーク]',   '133'=>'$E8',              '134'=>'$Gr',              '135'=>'[電池]',
            '136'=>'[スクロール]',   '137'=>'[画びょう]',         '138'=>'$Ed',              '139'=>'$EO',              '140'=>'$FP',
            '141'=>'$FQ',          '142'=>'$Eh',              '143'=>'[クリップ]',         '144'=>'$E2',              '145'=>'[名札]',
            '146'=>'$Gc',          '147'=>'$Eh',              '148'=>'$PO',              '149'=>'$O!',              '150'=>'[PDC]',
            '151'=>'$E#',          '152'=>'[レンチ]',           '153'=>'[送信BOX]',          '154'=>'[受信BOX]',          '155'=>'$G)',
            '156'=>'$GX',          '157'=>'[定規]',             '158'=>'[三角定規]',         '159'=>'[グラフ]',           '160'=>'[肉]',
            '161'=>'$G*',          '162'=>'[コンセント]',       '163'=>'[家族]',             '164'=>'[リンク]',           '165'=>'$E2',
            '166'=>'$G+',          '167'=>'$Gj',              '168'=>'$G=',              '169'=>'$G<',              '170'=>'[サイコロ]',
            '171'=>'[新聞]',         '172'=>'$G>',              '173'=>'　',                 '174'=>'',                   '175'=>'',
            '176'=>'$O.',          '177'=>'$F(',              '178'=>'$F*',              '179'=>'$F)',              '180'=>'$F<',
            '181'=>'$F=',          '182'=>'$F>',              '183'=>'$F?',              '184'=>'$F@',              '185'=>'$FA',
            '186'=>'$FB',          '187'=>'$FC',              '188'=>'$FD',              '189'=>'[10]',               '190'=>'$Pc',
            '191'=>'$Gh',          '192'=>'$F_',              '193'=>'$F`',              '194'=>'$Fa',              '195'=>'$Fb',
            '196'=>'$Fc',          '197'=>'$Fd',              '198'=>'$Fe',              '199'=>'$Ff',              '200'=>'$Fg',
            '201'=>'$Fh',          '202'=>'$Fi',              '203'=>'$Fj',              '204'=>'$Fk',              '205'=>'$Et',
            '206'=>'$Ev',          '207'=>'$Eq',              '208'=>'$Eo',              '209'=>'$Ep',              '210'=>'$Ek',
            '211'=>'$F"',          '212'=>'$Em',              '213'=>'$GZ',              '214'=>'[地図]',             '215'=>'$EV',
            '216'=>'$Ey',          '217'=>'$G?',              '218'=>'$E5',              '219'=>'$G8',              '220'=>'$G5',
            '221'=>'[スノボ]',       '222'=>'$ER',              '223'=>'$ED',              '224'=>'$EC',              '225'=>'$O+',
            '226'=>'$OD',          '227'=>'$Pk',              '228'=>'$Q)',              '229'=>'$ES',              '230'=>'[オメデトウ]',
            '231'=>'$EP',          '232'=>'[ゲーム]',           '233'=>'$EO',              '234'=>'$GS',              '235'=>'$GP',
            '236'=>'$E;',          '237'=>'$Q+',              '238'=>'$Oh',              '239'=>'$Gf',              '240'=>'$Eg',
            '241'=>'[さくらんぼ]',   '242'=>'$G9',              '243'=>'$Og',              '244'=>'$Ob',              '245'=>'$E@',
            '246'=>'$Gt',          '247'=>'$QL',              '248'=>'$G:',              '249'=>'$E)',              '250'=>'$QQ',
            '251'=>'$Go',          '252'=>'$Gu',              '253'=>'[アリ]',             '254'=>'$E+',              '255'=>'$O'."'".'',
            '256'=>'$O%',          '257'=>'$Gw',              '258'=>'$Gy',              '259'=>'$P1',              '260'=>'$P&',
            '261'=>'$E\',          '262'=>'$OT',              '263'=>'$OQ',              '264'=>'$E%',              '265'=>'$GC',
            '266'=>'$OG',          '267'=>'$ON',              '268'=>'$O1',              '269'=>'$E=',              '270'=>'[SOS]',
            '271'=>'$El',          '272'=>'$OI',              '273'=>'$G#',              '274'=>'$E,',              '275'=>'[なると]',
            '276'=>'$QV',          '277'=>'$E:',              '278'=>'[花丸]',             '279'=>'$O5',              '280'=>'[100点]',
            '281'=>'$G-',          '282'=>'$OP',              '283'=>'$Gz',              '284'=>'$G/',              '285'=>'$FF',
            '286'=>'$E<',          '287'=>'$G.',              '288'=>'$EJ',              '289'=>'$G\',              '290'=>'[財布]',
            '291'=>'$OF',          '292'=>'$Ga',              '293'=>'[バイオリン]',       '294'=>'$O*',              '295'=>'$O<',
            '296'=>'$E3',          '297'=>'$O>',              '298'=>'[EZ]',               '299'=>'[FREE]',             '300'=>'$EF',
            '301'=>'$G&',          '302'=>'$E,',              '303'=>'$F3',              '304'=>'$E[',              '305'=>'[霧]',
            '306'=>'$G4',          '307'=>'$PJ',              '308'=>'[ポケベル]',         '309'=>'$Q"',              '310'=>'$Q#',
            '311'=>'[イベント]',     '312'=>'$O4',              '313'=>'$Ok',              '314'=>'$F.',              '315'=>'$F-',
            '316'=>'$F/',          '317'=>'$P9',              '318'=>'$P;',              '319'=>'$G1',              '320'=>'$G2',
            '321'=>'●',             '322'=>'$Gl',              '323'=>'$Gl',              '324'=>'[CL]',               '325'=>'$FE',
            '326'=>'$Fm',          '327'=>'$P&',              '328'=>'$OG',              '329'=>'[ドンッ]',           '330'=>'$OQ',
            '331'=>'[ezplus]',       '332'=>'[地球]',             '333'=>'$O`',              '334'=>'$F2',              '335'=>'$G&',
            '336'=>'$G'."'".'',    '337'=>'$G,',              '338'=>'$EH',              '339'=>'$GR',              '340'=>'$GW',
            '341'=>'$PT',          '342'=>'$G[',              '343'=>'$G^',              '344'=>'$Gn',              '345'=>'$Gp',
            '346'=>'$Gq',          '347'=>'$Gs',              '348'=>'$P%',              '349'=>'$E&',              '350'=>'$P0',
            '351'=>'$E(',          '352'=>'$E*',              '353'=>'$E-',              '354'=>'$E.',              '355'=>'$E1',
            '356'=>'$E6',          '357'=>'$E7',              '358'=>'$E9',              '359'=>'$E>',              '360'=>'$EA',
            '361'=>'$EB',          '362'=>'$EM',              '363'=>'$EN',              '364'=>'$EQ',              '365'=>'[カメ]',
            '366'=>'$Q1',          '367'=>'$Q2',              '368'=>'$EW',              '369'=>'$E_',              '370'=>'$Ec',
            '371'=>'$Ef',          '372'=>'$QC',              '373'=>'$Ej',              '374'=>'$Er',              '375'=>'$Es',
            '376'=>'$Eu',          '377'=>'$Ew',              '378'=>'$Ex',              '379'=>'$F"',              '380'=>'$F'."'".'',
            '381'=>'$F+',          '382'=>'$F4',              '383'=>'$FG',              '384'=>'$FH',              '385'=>'$FI',
            '386'=>'$FJ',          '387'=>'$FK',              '388'=>'$FL',              '389'=>'$FM',              '390'=>'$FN',
            '391'=>'$FO',          '392'=>'$F^',              '393'=>'$Fp',              '394'=>'$Fq',              '395'=>'$O!',
            '396'=>'$O"',          '397'=>'$O#',              '398'=>'$O&',              '399'=>'$O(',              '400'=>'$O+',
            '401'=>'$O,',          '402'=>'$O-',              '403'=>'$O/',              '404'=>'$O0',              '405'=>'$O2',
            '406'=>'[EZナビ]',       '407'=>'$O8',              '408'=>'$O;',              '409'=>'$O=',              '410'=>'$O?',
            '411'=>'$O@',          '412'=>'$OA',              '413'=>'$OB',              '414'=>'$F,',              '415'=>'$OG',
            '416'=>'$OJ',          '417'=>'$OK',              '418'=>'$OL',              '419'=>'$OM',              '420'=>'$ON',
            '421'=>'$G3',          '422'=>'$OR',              '423'=>'$OX',              '424'=>'$OY',              '425'=>'$OZ',
            '426'=>'$O[',          '427'=>'$O\',              '428'=>'$O]',              '429'=>'$O^',              '430'=>'$O_',
            '431'=>'$Oa',          '432'=>'$Oc',              '433'=>'$Od',              '434'=>'$Oe',              '435'=>'$Of',
            '436'=>'$Oi',          '437'=>'$Oj',              '438'=>'$Ol',              '439'=>'$Om',              '440'=>'$P"',
            '441'=>'$P#',          '442'=>'$P$',              '443'=>'$P&',              '444'=>'$P'."'".'',        '445'=>'$P(',
            '446'=>'$P*',          '447'=>'$P+',              '448'=>'$P,',              '449'=>'$P-',              '450'=>'$P.',
            '451'=>'$P0',          '452'=>'$P/',              '453'=>'$OF',              '454'=>'$Gv',              '455'=>'$P7',
            '456'=>'$P8',          '457'=>'$P:',              '458'=>'$P<',              '459'=>'$P=',              '460'=>'$P?',
            '461'=>'$P@',          '462'=>'$PA',              '463'=>'$P>',              '464'=>'$PC',              '465'=>'$PD',
            '466'=>'$PF',          '467'=>'$PE',              '468'=>'$PI',              '469'=>'$Gb',              '470'=>'$PL',
            '471'=>'$PM',          '472'=>'$PP',              '473'=>'$PQ',              '474'=>'$PR',              '475'=>'$PS',
            '476'=>'$PV',          '477'=>'$PX',              '478'=>'$PY',              '479'=>'$PZ',              '480'=>'$P[',
            '481'=>'$P\',          '482'=>'[花嫁]',             '483'=>'$P_',              '484'=>'$P`',              '485'=>'$Pa',
            '486'=>'$Pb',          '487'=>'$Pe',              '488'=>'$Pf',              '489'=>'$Ph',              '490'=>'$Pk',
            '491'=>'$Pl',          '492'=>'$Q!',              '493'=>'$Pi',              '494'=>'$Q#',              '495'=>'$Q$',
            '496'=>'$Q%',          '497'=>'$Q&',              '498'=>'$Q(',              '499'=>'$Q-',              '500'=>'[オープンウェブ]',
            '501'=>'$Ed',          '502'=>'[ABCD]',             '503'=>'[abcd]',             '504'=>'[1234]',             '505'=>'[記号]',
            '506'=>'[可]',           '507'=>'[チェックマーク]',   '508'=>'[ペン]',             '509'=>'[ラジオボタン]',     '510'=>'$E4',
            '511'=>'$FU',          '512'=>'[ブックマーク]',     '513'=>'$E$',              '514'=>'$GV',              '515'=>'$E!',
            '516'=>'$O!',          '517'=>'$Ed',              '518'=>'↑↓',               '700'=>'$Q.',              '701'=>'$Q/',
            '702'=>'$Q0',          '703'=>'$Q3',              '704'=>'$Q4',              '705'=>'$Q5',              '706'=>'$Q6',
            '707'=>'$Q7',          '708'=>'$Q8',              '709'=>'$Q9',              '710'=>'$Q:',              '711'=>'$Q;',
            '712'=>'$Q<',          '713'=>'$Q@',              '714'=>'$Q?',              '715'=>'$QB',              '716'=>'$QE',
            '717'=>'$QF',          '718'=>'$QG',              '719'=>'$QK',              '720'=>'$QM',              '721'=>'$QN',
            '722'=>'$QO',          '723'=>'$QP',              '724'=>'$QR',              '725'=>'$QS',              '726'=>'$QU',
            '727'=>'$QT',          '728'=>'$QV',              '729'=>'$G'."'".'',        '730'=>'[旗]',               '731'=>'$FV',
            '732'=>'$FX',          '733'=>'！？',               '734'=>'！！',               '735'=>'～',                 '736'=>'[メロン]',
            '737'=>'[パイナップル]', '738'=>'[ブドウ]',           '739'=>'[バナナ]',           '740'=>'[とうもろこし]',     '741'=>'[キノコ]',
            '742'=>'[栗]',           '743'=>'[モモ]',             '744'=>'[やきいも]',         '745'=>'[ピザ]',             '746'=>'[チキン]',
            '747'=>'[七夕]',         '748'=>'$Gd',              '749'=>'[辰]',               '750'=>'[ピアノ]',           '751'=>'$G7',
            '752'=>'$G9',          '753'=>'[ボーリング]',       '754'=>'[なまはげ]',         '755'=>'[天狗]',             '756'=>'[パンダ]',
            '757'=>'$P)',          '758'=>'$E+',              '759'=>'$O%',              '760'=>'[アイスクリーム]',   '761'=>'[ドーナツ]',
            '762'=>'[クッキー]',     '763'=>'[チョコ]',           '764'=>'[キャンディ]',       '765'=>'[キャンディ]',       '766'=>'(/_＼)',
            '767'=>'(・×・)',       '768'=>'|(・×・)|',         '769'=>'[火山]',             '770'=>'$OH',              '771'=>'[ABC]',
            '772'=>'[プリン]',       '773'=>'[ミツバチ]',         '774'=>'[てんとう虫]',       '775'=>'[ハチミツ]',         '776'=>'$Oe',
            '777'=>'[飛んでいく金]', '778'=>'$P'."'".'',        '779'=>'$P6',              '780'=>'$P6',              '781'=>'$Pk',
            '782'=>'$P8',          '783'=>'$Gw',              '784'=>'$E#',              '785'=>'$P2',              '786'=>'$P2',
            '787'=>'$E&',          '788'=>'$P#',              '789'=>'$P#',              '790'=>'$P3',              '791'=>'$P3',
            '792'=>'$P$',          '793'=>'$O9',              '794'=>'[モアイ]',           '795'=>'$GY',              '796'=>'[花札]',
            '797'=>'[ジョーカー]',   '798'=>'[エビフライ]',       '799'=>'$E#',              '800'=>'$F!',              '801'=>'$PR',
            '802'=>'[EZムービー]',   '803'=>'$OG',              '804'=>'$QC',              '805'=>'[ジーンズ]',         '806'=>'$E#',
            '807'=>'↑↓',           '808'=>'⇔',                 '809'=>'↑↓',               '810'=>'$P^',              '811'=>'$E0',
            '812'=>'[カタツムリ]',   '813'=>'$P$',              '814'=>'$P$',              '815'=>'[Cメール]',          '816'=>'$E0',
            '817'=>'$G0',          '818'=>'$F0',              '819'=>'$G2',              '820'=>'$PG',              '821'=>'$P#',
            '822'=>'$P6',
        );
        return empty($map[$dec])?'':$map[$dec];
    }
} // emoji_Tag
?>