<?php
/* SVN FILE: $Id: SoftBank.php 410 2008-05-18 06:32:15Z bb_yujiro $ */
/**
 * SoftBank用絵文字変換
 *
 * 参考資料：
 *       [絵文字の相互変換リスト] http://labs.unoh.net/2007/02/post_65.html
 *
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 410 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 15:32:15 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * SoftBank用絵文字変換
 *
 * @category        Emoji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 410 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 15:32:15 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_Emoji_SoftBank
{
    /**
     * SoftBankから独自タグへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function softbank2tag($hex)
    {
        $map = array(
            'G!'=>'[m:80]',     'G"'=>'[m:50]',     'G#'=>'[m:273]',    'G$'=>'[m:80]',     'G%'=>'[m:50]',
            'G&'=>'[m:335]',    "G'"=>'[m:336]',    'G('=>'[m:94]',     'G)'=>'[m:85]',     'G*'=>'[m:161]',
            'G+'=>'[m:166]',    'G,'=>'[m:337]',    'G-'=>'[m:281]',    'G.'=>'[m:287]',    'G/'=>'[m:284]',
            'G0'=>'[m:817]',    'G1'=>'[m:319]',    'G2'=>'[m:320]',    'G3'=>'[m:421]',    'G4'=>'[m:306]',
            'G5'=>'[m:220]',    'G6'=>'[m:45]',     'G7'=>'[m:751]',    'G8'=>'[m:219]',    'G9'=>'[m:203]',
            'G:'=>'[m:248]',    'G;'=>'[m:125]',    'G<'=>'[m:169]',    'G='=>'[m:168]',    'G>'=>'[m:172]',
            'G?'=>'[m:217]',    'G@'=>'[m:3]',      'GA'=>'[m:2]',      'GB'=>'[m:51]',     'GC'=>'[m:265]',
            'GD'=>'[m:46]',     'GE'=>'[m:46]',     'GF'=>'[m:46]',     'GG'=>'[m:46]',     'GH'=>'[m:46]',
            'GI'=>'[m:46]',     'GJ'=>'[m:46]',     'GK'=>'[m:46]',     'GL'=>'[m:46]',     'GM'=>'[m:46]',
            'GN'=>'[m:46]',     'GO'=>'[m:46]',     'GP'=>'[m:235]',    'GQ'=>'[m:354]',    'GR'=>'[m:339]',
            'GS'=>'[m:234]',    'GT'=>'[m:72]',     'GU'=>'[m:72]',     'GV'=>'[m:112]',    'GW'=>'[m:340]',
            'GX'=>'[m:156]',    'GY'=>'[m:795]',    'GZ'=>'[m:213]',    'G['=>'[m:342]',    'G\\'=>'[m:289]',
            'G]'=>'[m:110]',    'G^'=>'[m:343]',    'G_'=>'[m:120]',    'G`'=>'[m:173]',    'Ga'=>'[m:292]',
            'Gb'=>'[m:469]',    'Gc'=>'[m:146]',    'Gd'=>'[m:52]',     'Ge'=>'[m:93]',     'Gf'=>'[m:239]',
            'Gg'=>'[m:65]',     'Gh'=>'[m:191]',    'Gi'=>'[m:107]',    'Gj'=>'[m:44]',     'Gk'=>'[m:95]',
            'Gl'=>'[m:15]',     'Gm'=>'[m:493]',    'Gn'=>'[m:344]',    'Go'=>'[m:251]',    'Gp'=>'[m:345]',
            'Gq'=>'[m:346]',    'Gr'=>'[m:134]',    'Gs'=>'[m:347]',    'Gt'=>'[m:246]',    'Gu'=>'[m:252]',
            'Gv'=>'[m:454]',    'Gw'=>'[m:257]',    'Gx'=>'[m:444]',    'Gy'=>'[m:258]',    'Gz'=>'[m:283]',
            'E!'=>'[m:129]',    'E"'=>'[m:129]',    'E#'=>'[m:784]',    'E$'=>'[m:513]',    'E%'=>'[m:264]',
            'E&'=>'[m:349]',    "E'"=>'[m:350]',    'E('=>'[m:351]',    'E)'=>'[m:249]',    'E*'=>'[m:352]',
            'E+'=>'[m:254]',    'E,'=>'[m:274]',    'E-'=>'[m:353]',    'E.'=>'[m:354]',    'E/'=>'[m:77]',
            'E0'=>'[m:53]',     'E1'=>'[m:355]',    'E2'=>'[m:144]',    'E3'=>'[m:296]',    'E4'=>'[m:119]',
            'E5'=>'[m:218]',    'E6'=>'[m:356]',    'E7'=>'[m:357]',    'E8'=>'[m:133]',    'E9'=>'[m:358]',
            'E:'=>'[m:277]',    'E;'=>'[m:236]',    'E<'=>'[m:286]',    'E='=>'[m:269]',    'E>'=>'[m:359]',
            'E?'=>'[m:173]',    'E@'=>'[m:245]',    'EA'=>'[m:360]',    'EB'=>'[m:361]',    'EC'=>'[m:224]',
            'ED'=>'[m:223]',    'EE'=>'[m:106]',    'EF'=>'[m:300]',    'EG'=>'[m:300]',    'EH'=>'[m:338]',
            'EI'=>'[m:115]',    'EJ'=>'[m:288]',    'EK'=>'[m:274]',    'EL'=>'[m:173]',    'EM'=>'[m:362]',
            'EN'=>'[m:363]',    'EO'=>'[m:233]',    'EP'=>'[m:231]',    'EQ'=>'[m:364]',    'ER'=>'[m:222]',
            'ES'=>'[m:229]',    'ET'=>'[m:248]',    'EU'=>'[m:169]',    'EV'=>'[m:215]',    'EW'=>'[m:368]',
            'EX'=>'[m:173]',    'EY'=>'[m:173]',    'EZ'=>'[m:710]',    'E['=>'[m:304]',    'E\\'=>'[m:261]',
            'E]'=>'[m:16]',     'E^'=>'[m:124]',    'E_'=>'[m:369]',    'E`'=>'[m:207]',    'Ea'=>'[m:13]',
            'Eb'=>'[m:13]',     'Ec'=>'[m:370]',    'Ed'=>'[m:138]',    'Ee'=>'[m:138]',    'Ef'=>'[m:371]',
            'Eg'=>'[m:240]',    'Eh'=>'[m:122]',    'Ei'=>'[m:173]',    'Ej'=>'[m:373]',    'Ek'=>'[m:210]',
            'El'=>'[m:271]',    'Em'=>'[m:212]',    'En'=>'[m:99]',     'Eo'=>'[m:208]',    'Ep'=>'[m:209]',
            'Eq'=>'[m:207]',    'Er'=>'[m:374]',    'Es'=>'[m:375]',    'Et'=>'[m:205]',    'Eu'=>'[m:376]',
            'Ev'=>'[m:206]',    'Ew'=>'[m:377]',    'Ex'=>'[m:378]',    'Ey'=>'[m:216]',    'Ez'=>'[m:125]',
            'F!'=>'[m:800]',    'F"'=>'[m:379]',    'F#'=>'[m:173]',    'F$'=>'[m:51]',     'F%'=>'[m:267]',
            'F&'=>'[m:28]',     "F'"=>'[m:380]',    'F('=>'[m:177]',    'F)'=>'[m:179]',    'F*'=>'[m:178]',
            'F+'=>'[m:381]',    'F,'=>'[m:414]',    'F-'=>'[m:315]',    'F.'=>'[m:314]',    'F/'=>'[m:316]',
            'F0'=>'[m:818]',    'F1'=>'[m:173]',    'F2'=>'[m:334]',    'F3'=>'[m:303]',    'F4'=>'[m:382]',
            'F5'=>'[m:173]',    'F6'=>'[m:173]',    'F7'=>'[m:173]',    'F8'=>'[m:173]',    'F9'=>'[m:40]',
            'F:'=>'[m:41]',     'F;'=>'[m:41]',     'F<'=>'[m:180]',    'F='=>'[m:181]',    'F>'=>'[m:182]',
            'F?'=>'[m:183]',    'F@'=>'[m:184]',    'FA'=>'[m:185]',    'FB'=>'[m:186]',    'FC'=>'[m:187]',
            'FD'=>'[m:188]',    'FE'=>'[m:325]',    'FF'=>'[m:285]',    'FG'=>'[m:383]',    'FH'=>'[m:384]',
            'FI'=>'[m:385]',    'FJ'=>'[m:386]',    'FK'=>'[m:387]',    'FL'=>'[m:388]',    'FM'=>'[m:389]',
            'FN'=>'[m:390]',    'FO'=>'[m:391]',    'FP'=>'[m:140]',    'FQ'=>'[m:141]',    'FR'=>'[m:29]',
            'FS'=>'[m:30]',     'FT'=>'[m:63]',     'FU'=>'[m:64]',     'FV'=>'[m:70]',     'FW'=>'[m:42]',
            'FX'=>'[m:43]',     'FY'=>'[m:71]',     'FZ'=>'[m:6]',      'F['=>'[m:5]',      'F\\'=>'[m:8]',
            'F]'=>'[m:7]',      'F^'=>'[m:392]',    'F_'=>'[m:192]',    'F`'=>'[m:193]',    'Fa'=>'[m:194]',
            'Fb'=>'[m:195]',    'Fc'=>'[m:196]',    'Fd'=>'[m:197]',    'Fe'=>'[m:198]',    'Ff'=>'[m:199]',
            'Fg'=>'[m:200]',    'Fh'=>'[m:201]',    'Fi'=>'[m:202]',    'Fj'=>'[m:203]',    'Fk'=>'[m:204]',
            'Fl'=>'[m:173]',    'Fm'=>'[m:326]',    'Fn'=>'[m:81]',     'Fo'=>'[m:82]',     'Fp'=>'[m:393]',
            'Fq'=>'[m:394]',    'Fr'=>'[m:1]',      'Fs'=>'[m:173]',    'Ft'=>'[m:173]',    'Fu'=>'[m:173]',
            'Fv'=>'[m:173]',    'Fw'=>'[m:173]',    'Fx'=>'[m:173]',    'Fy'=>'[m:173]',    'Fz'=>'[m:173]',
            'O!'=>'[m:395]',    'O"'=>'[m:396]',    'O#'=>'[m:397]',    'O$'=>'[m:113]',    'O%'=>'[m:256]',
            'O&'=>'[m:398]',    "O'"=>'[m:255]',    'O('=>'[m:399]',    'O)'=>'[m:173]',    'O*'=>'[m:294]',
            'O+'=>'[m:400]',    'O,'=>'[m:401]',    'O-'=>'[m:402]',    'O.'=>'[m:176]',    'O/'=>'[m:403]',
            'O0'=>'[m:404]',    'O1'=>'[m:268]',    'O2'=>'[m:405]',    'O3'=>'[m:104]',    'O4'=>'[m:312]',
            'O5'=>'[m:279]',    'O6'=>'[m:126]',    'O7'=>'[m:13]',     'O8'=>'[m:407]',    'O9'=>'[m:793]',
            'O:'=>'[m:124]',    'O;'=>'[m:408]',    'O<'=>'[m:295]',    'O='=>'[m:409]',    'O>'=>'[m:297]',
            'O?'=>'[m:410]',    'O@'=>'[m:411]',    'OA'=>'[m:412]',    'OB'=>'[m:413]',    'OC'=>'[m:83]',
            'OD'=>'[m:226]',    'OE'=>'[m:48]',     'OF'=>'[m:291]',    'OG'=>'[m:415]',    'OH'=>'[m:803]',
            'OI'=>'[m:272]',    'OJ'=>'[m:416]',    'OK'=>'[m:417]',    'OL'=>'[m:418]',    'OM'=>'[m:419]',
            'ON'=>'[m:420]',    'OO'=>'[m:69]',     'OP'=>'[m:282]',    'OQ'=>'[m:330]',    'OR'=>'[m:422]',
            'OS'=>'[m:61]',     'OT'=>'[m:262]',    'OU'=>'[m:69]',     'OV'=>'[m:3]',      'OW'=>'[m:2]',
            'OX'=>'[m:423]',    'OY'=>'[m:424]',    'OZ'=>'[m:425]',    'O['=>'[m:426]',    'O\\'=>'[m:427]',
            'O]'=>'[m:428]',    'O^'=>'[m:429]',    'O_'=>'[m:430]',    'O`'=>'[m:333]',    'Oa'=>'[m:431]',
            'Ob'=>'[m:244]',    'Oc'=>'[m:432]',    'Od'=>'[m:433]',    'Oe'=>'[m:434]',    'Of'=>'[m:435]',
            'Og'=>'[m:243]',    'Oh'=>'[m:238]',    'Oi'=>'[m:436]',    'Oj'=>'[m:437]',    'Ok'=>'[m:313]',
            'Ol'=>'[m:438]',    'Om'=>'[m:439]',    'P!'=>'[m:351]',    'P"'=>'[m:440]',    'P#'=>'[m:441]',
            'P$'=>'[m:442]',    'P%'=>'[m:348]',    'P&'=>'[m:443]',    "P'"=>'[m:444]',    'P('=>'[m:445]',
            'P)'=>'[m:264]',    'P*'=>'[m:446]',    'P+'=>'[m:447]',    'P,'=>'[m:448]',    'P-'=>'[m:449]',
            'P.'=>'[m:450]',    'P/'=>'[m:447]',    'P0'=>'[m:451]',    'P1'=>'[m:259]',    'P2'=>'[m:786]',
            'P3'=>'[m:791]',    'P4'=>'[m:454]',    'P5'=>'[m:257]',    'P6'=>'[m:779]',    'P7'=>'[m:455]',
            'P8'=>'[m:456]',    'P9'=>'[m:317]',    'P:'=>'[m:457]',    'P;'=>'[m:318]',    'P<'=>'[m:458]',
            'P='=>'[m:459]',    'P>'=>'[m:463]',    'P?'=>'[m:460]',    'P@'=>'[m:461]',    'PA'=>'[m:462]',
            'PB'=>'[m:463]',    'PC'=>'[m:464]',    'PD'=>'[m:465]',    'PE'=>'[m:467]',    'PF'=>'[m:466]',
            'PG'=>'[m:820]',    'PH'=>'[m:173]',    'PI'=>'[m:468]',    'PJ'=>'[m:307]',    'PK'=>'[m:96]',
            'PL'=>'[m:470]',    'PM'=>'[m:471]',    'PN'=>'[m:125]',    'PO'=>'[m:148]',    'PP'=>'[m:472]',
            'PQ'=>'[m:473]',    'PR'=>'[m:474]',    'PS'=>'[m:475]',    'PT'=>'[m:341]',    'PU'=>'[m:217]',
            'PV'=>'[m:476]',    'PW'=>'[m:770]',    'PX'=>'[m:477]',    'PY'=>'[m:478]',    'PZ'=>'[m:479]',
            'P['=>'[m:480]',    'P\\'=>'[m:481]',   'P]'=>'[m:340]',    'P^'=>'[m:810]',    'P_'=>'[m:483]',
            'P`'=>'[m:484]',    'Pa'=>'[m:485]',    'Pb'=>'[m:486]',    'Pc'=>'[m:190]',    'Pd'=>'[m:173]',
            'Pe'=>'[m:487]',    'Pf'=>'[m:488]',    'Pg'=>'[m:358]',    'Ph'=>'[m:489]',    'Pi'=>'[m:493]',
            'Pj'=>'[m:371]',    'Pk'=>'[m:490]',    'Pl'=>'[m:491]',    'Q!'=>'[m:492]',    'Q"'=>'[m:309]',
            'Q#'=>'[m:494]',    'Q$'=>'[m:495]',    'Q%'=>'[m:496]',    'Q&'=>'[m:497]',    "Q'"=>'[m:110]',
            'Q('=>'[m:498]',    'Q)'=>'[m:228]',    'Q*'=>'[m:173]',    'Q+'=>'[m:237]',    'Q,'=>'[m:90]',
            'Q-'=>'[m:499]',    'Q.'=>'[m:700]',    'Q/'=>'[m:701]',    'Q0'=>'[m:702]',    'Q1'=>'[m:366]',
            'Q2'=>'[m:367]',    'Q3'=>'[m:703]',    'Q4'=>'[m:704]',    'Q5'=>'[m:705]',    'Q6'=>'[m:706]',
            'Q7'=>'[m:707]',    'Q8'=>'[m:708]',    'Q9'=>'[m:709]',    'Q:'=>'[m:710]',    'Q;'=>'[m:711]',
            'Q<'=>'[m:712]',    'Q='=>'[m:173]',    'Q>'=>'[m:173]',    'Q?'=>'[m:714]',    'Q@'=>'[m:713]',
            'QA'=>'[m:78]',     'QB'=>'[m:715]',    'QC'=>'[m:78]',     'QD'=>'[m:173]',    'QE'=>'[m:716]',
            'QF'=>'[m:717]',    'QG'=>'[m:718]',    'QH'=>'[m:249]',    'QI'=>'[m:192]',    'QJ'=>'[m:134]',
            'QK'=>'[m:719]',    'QL'=>'[m:247]',    'QM'=>'[m:720]',    'QN'=>'[m:721]',    'QO'=>'[m:722]',
            'QP'=>'[m:723]',    'QQ'=>'[m:250]',    'QR'=>'[m:724]',    'QS'=>'[m:725]',    'QT'=>'[m:727]',
            'QU'=>'[m:726]',    'QV'=>'[m:728]',    'QW'=>'[m:54]',     'QX'=>'[m:173]',    'QY'=>'[m:173]',
            'QZ'=>'[m:173]',    'Q['=>'[m:173]',    'Q\\'=>'[m:173]',   'Q]'=>'[m:173]',    'Q^'=>'[m:173]',
        );
        return empty($map[$hex])?'[m:173]':$map[$hex];
    }

    /**
     * SoftBankからDoCoMoへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function softbank2docomo($hex)
    {
        $map = array(
            'G!'=>'&#63893;',   'G"'=>'&#63893;',   'G#'=>'&#63902;',   'G$'=>'&#63893;',   'G%'=>'&#63893;',
            'G&'=>'&#63923;',   "G'"=>'&#63738;',   'G('=>'&#63714;',   'G)'=>'&#63720;',   'G*'=>'&#63721;',
            'G+'=>'&#63860;',   'G,'=>'&#63931;',   'G-'=>'&#63906;',   'G.'=>'&#63948;',   'G/'=>'〓',
            'G0'=>'&#63732;',   'G1'=>'&#63733;',   'G2'=>'&#63734;',   'G3'=>'&#63672;',   'G4'=>'&#63669;',
            'G5'=>'&#63670;',   'G6'=>'&#63668;',   'G7'=>'&#63927;',   'G8'=>'&#63671;',   'G9'=>'&#63990;',
            'G:'=>'&#63993;',   'G;'=>'&#63679;',   'G<'=>'&#63815;',   'G='=>'&#63683;',   'G>'=>'&#63676;',
            'G?'=>'&#63678;',   'G@'=>'[?]',        'GA'=>'&#63911;',   'GB'=>'&#63889;',   'GC'=>'&#63891;',
            'GD'=>'&#63838;',   'GE'=>'&#63838;',   'GF'=>'&#63838;',   'GG'=>'&#63838;',   'GH'=>'&#63838;',
            'GI'=>'&#63838;',   'GJ'=>'&#63838;',   'GK'=>'&#63838;',   'GL'=>'&#63838;',   'GM'=>'&#63838;',
            'GN'=>'&#63838;',   'GO'=>'&#63838;',   'GP'=>'&#63981;',   'GQ'=>'&#63935;',   'GR'=>'〓',
            'GS'=>'&#63816;',   'GT'=>'&#63936;',   'GU'=>'&#63936;',   'GV'=>'&#63684;',   'GW'=>'〓',
            'GX'=>'&#63685;',   'GY'=>'〓',         'GZ'=>'&#63692;',   'G['=>'&#63973;',   'G\\'=>'&#63703;',
            'G]'=>'&#63704;',   'G^'=>'&#63899;',   'G_'=>'&#63869;',   'G`'=>'〓',         'Ga'=>'〓',
            'Gb'=>'〓',         'Gc'=>'&#63696;',   'Gd'=>'&#63698;',   'Ge'=>'&#63697;',   'Gf'=>'&#63983;',
            'Gg'=>'&#63699;',   'Gh'=>'&#63650;',   'Gi'=>'&#63648;',   'Gj'=>'&#63647;',   'Gk'=>'&#63649;',
            'Gl'=>'&#63811;',   'Gm'=>'&#63647;',   'Gn'=>'〓',         'Go'=>'&#63814;',   'Gp'=>'〓',
            'Gq'=>'〓',         'Gr'=>'&#63813;',   'Gs'=>'〓',         'Gt'=>'〓',         'Gu'=>'&#63989;',
            'Gv'=>'&#63893;',   'Gw'=>'&#63893;',   'Gx'=>'&#63895;',   'Gy'=>'&#63894;',   'Gz'=>'〓',
            'E!'=>'&#63686;',   'E"'=>'&#63686;',   'E#'=>'&#63859;',   'E$'=>'&#63858;',   'E%'=>'&#63949;',
            'E&'=>'&#63947;',   "E'"=>'&#63996;',   'E('=>'&#63944;',   'E)'=>'〓',         'E*'=>'〓',
            'E+'=>'&#63994;',   'E,'=>'〓',         'E-'=>'〓',         'E.'=>'&#63935;',   'E/'=>'&#63904;',
            'E0'=>'&#63974;',   'E1'=>'&#63902;',   'E2'=>'&#63718;',   'E3'=>'〓',         'E4'=>'&#63873;',
            'E5'=>'&#63960;',   'E6'=>'〓',         'E7'=>'〓',         'E8'=>'&#63980;',   'E9'=>'〓',
            'E:'=>'〓',         'E;'=>'〓',         'E<'=>'〓',         'E='=>'〓',         'E>'=>'&#63715;',
            'E?'=>'&#63830;',   'E@'=>'&#63700;',   'EA'=>'〓',         'EB'=>'〓',         'EC'=>'&#63900;',
            'ED'=>'〓',         'EE'=>'&#63711;',   'EF'=>'&#63725;',   'EG'=>'&#63725;',   'EH'=>'〓',
            'EI'=>'〓',         'EJ'=>'&#63723;',   'EK'=>'〓',         'EL'=>'〓',         'EM'=>'〓',
            'EN'=>'[VS]',       'EO'=>'&#63930;',   'EP'=>'〓',         'EQ'=>'〓',         'ER'=>'&#63674;',
            'ES'=>'[777]',      'ET'=>'&#63993;',   'EU'=>'&#63815;',   'EV'=>'&#63938;',   'EW'=>'〓',
            'EX'=>'[♂]',       'EY'=>'[♀]',       'EZ'=>'〓',         'E['=>'〓',         'E\\'=>'&#63910;',
            'E]'=>'&#63651;',   'E^'=>'&#63701;',   'E_'=>'&#63900;',   'E`'=>'&#63695;',   'Ea'=>'〓',
            'Eb'=>'〓',         'Ec'=>'〓',         'Ed'=>'&#63869;',   'Ee'=>'&#63869;',   'Ef'=>'〓',
            'Eg'=>'〓',         'Eh'=>'&#63716;',   'Ei'=>'[$\]',       'Ej'=>'〓',         'Ek'=>'〓',
            'El'=>'〓',         'Em'=>'&#63688;',   'En'=>'&#63694;',   'Eo'=>'&#63693;',   'Ep'=>'〓',
            'Eq'=>'&#63695;',   'Er'=>'〓',         'Es'=>'&#63686;',   'Et'=>'&#63689;',   'Eu'=>'&#63687;',
            'Ev'=>'&#63691;',   'Ew'=>'&#63971;',   'Ex'=>'&#63690;',   'Ey'=>'&#63681;',   'Ez'=>'&#63679;',
            'F!'=>'&#63960;',   'F"'=>'&#63682;',   'F#'=>'[ココ]',     'F$'=>'&#63901;',   'F%'=>'&#63901;',
            'F&'=>'&#63901;',   "F'"=>'〓',         'F('=>'&#63713;',   'F)'=>'〓',         'F*'=>'&#63740;',
            'F+'=>'〓',         'F,'=>'&#63726;',   'F-'=>'&#63728;',   'F.'=>'&#63727;',   'F/'=>'&#63729;',
            'F0'=>'&#63877;',   'F1'=>'&#63876;',   'F2'=>'&#63874;',   'F3'=>'[UP]',       'F4'=>'[COOL]',
            'F5'=>'[有]',       'F6'=>'[無]',       'F7'=>'[月]',       'F8'=>'[申]',       'F9'=>'&#63808;',
            'F:'=>'&#63808;',   'F;'=>'&#63808;',   'F<'=>'&#63879;',   'F='=>'&#63880;',   'F>'=>'&#63881;',
            'F?'=>'&#63882;',   'F@'=>'&#63883;',   'FA'=>'&#63884;',   'FB'=>'&#63885;',   'FC'=>'&#63886;',
            'FD'=>'&#63887;',   'FE'=>'&#63888;',   'FF'=>'[得]',       'FG'=>'[割]',       'FH'=>'[サ]',
            'FI'=>'&#63868;',   'FJ'=>'&#63968;',   'FK'=>'&#63966;',   'FL'=>'[指]',       'FM'=>'[営]',
            'FN'=>'[↑]',       'FO'=>'[↓]',       'FP'=>'[←]',       'FQ'=>'[→]',       'FR'=>'[↑]',
            'FS'=>'[↓]',       'FT'=>'[→]',       'FU'=>'[←]',       'FV'=>'&#63705;',   'FW'=>'&#63736;',
            'FX'=>'&#63735;',   'FY'=>'&#63817;',   'FZ'=>'[>]',        'F['=>'[<]',        'F\\'=>'[>>]',
            'F]'=>'[<<]',       'F^'=>'〓',         'F_'=>'&#63655;',   'F`'=>'&#63656;',   'Fa'=>'&#63657;',
            'Fb'=>'&#63658;',   'Fc'=>'&#63659;',   'Fd'=>'&#63660;',   'Fe'=>'&#63661;',   'Ff'=>'&#63662;',
            'Fg'=>'&#63663;',   'Fh'=>'&#63664;',   'Fi'=>'&#63665;',   'Fj'=>'&#63666;',   'Fk'=>'〓',
            'Fl'=>'[TOP]',      'Fm'=>'&#63920;',   'Fn'=>'&#63958;',   'Fo'=>'&#63963;',   'Fp'=>'〓',
            'Fq'=>'〓',         'Fr'=>'&#63964;',   'Fs'=>'〓',         'Ft'=>'〓',         'Fu'=>'〓',
            'Fv'=>'〓',         'Fw'=>'〓',         'Fx'=>'〓',         'Fy'=>'〓',         'Fz'=>'〓',
            'O!'=>'&#63722;',   'O"'=>'〓',         'O#'=>'〓',         'O$'=>'&#63976;',   'O%'=>'〓',
            'O&'=>'〓',         "O'"=>'〓',         'O('=>'〓',         'O)'=>'[WC]',       'O*'=>'&#63707;',
            'O+'=>'&#63984;',   'O,'=>'&#63699;',   'O-'=>'[祝]',       'O.'=>'&#63712;',   'O/'=>'〓',
            'O0'=>'〓',         'O1'=>'&#63907;',   'O2'=>'〓',         'O3'=>'&#63702;',   'O4'=>'&#63717;',
            'O5'=>'&#63961;',   'O6'=>'〓',         'O7'=>'〓',         'O8'=>'〓',         'O9'=>'〓',
            'O:'=>'&#63701;',   'O;'=>'〓',         'O<'=>'&#63925;',   'O='=>'〓',         'O>'=>'〓',
            'O?'=>'&#63702;',   'O@'=>'〓',         'OA'=>'〓',         'OB'=>'〓',         'OC'=>'&#63715;',
            'OD'=>'&#63824;',   'OE'=>'&#63928;',   'OF'=>'&#63908;',   'OG'=>'&#63889;',   'OH'=>'&#63890;',
            'OI'=>'&#63889;',   'OJ'=>'&#63889;',   'OK'=>'&#63889;',   'OL'=>'&#63889;',   'OM'=>'&#63889;',
            'ON'=>'&#63903;',   'OO'=>'[☆]',       'OP'=>'&#63917;',   'OQ'=>'&#63915;',   'OR'=>'&#63812;',
            'OS'=>'[×]',       'OT'=>'&#63905;',   'OU'=>'[☆]',       'OV'=>'[?]',        'OW'=>'&#63911;',
            'OX'=>'&#63939;',   'OY'=>'&#63986;',   'OZ'=>'〓',         'O['=>'〓',         'O\\'=>'〓',
            'O]'=>'〓',         'O^'=>'&#63985;',   'O_'=>'〓',         'O`'=>'&#63985;',   'Oa'=>'〓',
            'Ob'=>'&#63982;',   'Oc'=>'〓',         'Od'=>'〓',         'Oe'=>'&#63978;',   'Of'=>'〓',
            'Og'=>'〓',         'Oh'=>'〓',         'Oi'=>'〓',         'Oj'=>'〓',         'Ok'=>'&#63719;',
            'Ol'=>'〓',         'Om'=>'〓',         'P!'=>'&#63944;',   'P"'=>'&#63953;',   'P#'=>'&#63941;',
            'P$'=>'&#63992;',   'P%'=>'&#63950;',   'P&'=>'&#63952;',   "P'"=>'&#63896;',   'P('=>'&#63910;',
            'P)'=>'&#63949;',   'P*'=>'&#63942;',   'P+'=>'&#63996;',   'P,'=>'〓',         'P-'=>'&#63951;',
            'P.'=>'&#63946;',   'P/'=>'&#63944;',   'P0'=>'&#63897;',   'P1'=>'&#63954;',   'P2'=>'%i140%%i1034%',
            'P3'=>'&#63955;',   'P4'=>'&#63893;',   'P5'=>'&#63893;',   'P6'=>'&#63945;',   'P7'=>'&#63947;',
            'P8'=>'&#63947;',   'P9'=>'&#63730;',   'P:'=>'〓',         'P;'=>'&#63731;',   'P<'=>'&#63902;',
            'P='=>'〓',         'P>'=>'&#63734;',   'P?'=>'〓',         'P@'=>'&#63920;',   'PA'=>'&#63909;',
            'PB'=>'&#63734;',   'PC'=>'&#63956;',   'PD'=>'&#63920;',   'PE'=>'&#63890;',   'PF'=>'[m(_ _)m]',
            'PG'=>'[＼(^o^)／]','PH'=>'〓',         'PI'=>'〓',         'PJ'=>'&#63673;',   'PK'=>'〓',
            'PL'=>'〓',         'PM'=>'〓',         'PN'=>'&#63680;',   'PO'=>'〓',         'PP'=>'〓',
            'PQ'=>'〓',         'PR'=>'〓',         'PS'=>'〓',         'PT'=>'&#63677;',   'PU'=>'&#63678;',
            'PV'=>'〓',         'PW'=>'〓',         'PX'=>'〓',         'PY'=>'〓',         'PZ'=>'〓',
            'P['=>'〓',         'P\\'=>'&#63654;',  'P]'=>'〓',         'P^'=>'&#63972;',   'P_'=>'〓',
            'P`'=>'〓',         'Pa'=>'〓',         'Pb'=>'〓',         'Pc'=>'&#63652;',   'Pd'=>'〓',
            'Pe'=>'〓',         'Pf'=>'〓',         'Pg'=>'〓',         'Ph'=>'〓',         'Pi'=>'&#63647;',
            'Pj'=>'&#63647;',   'Pk'=>'&#63831;',   'Pl'=>'〓',         'Q!'=>'&#63690;',   'Q"'=>'&#63708;',
            'Q#'=>'&#63709;',   'Q$'=>'〓',         'Q%'=>'〓',         'Q&'=>'〓',         "Q'"=>'&#63704;',
            'Q('=>'〓',         'Q)'=>'〓',         'Q*'=>'〓',         'Q+'=>'〓',         'Q,'=>'〓',
            'Q-'=>'〓',         'Q.'=>'〓',         'Q/'=>'〓',         'Q0'=>'〓',         'Q1'=>'〓',
            'Q2'=>'〓',         'Q3'=>'〓',         'Q4'=>'〓',         'Q5'=>'〓',         'Q6'=>'〓',
            'Q7'=>'〓',         'Q8'=>'〓',         'Q9'=>'〓',         'Q:'=>'〓',         'Q;'=>'〓',
            'Q<'=>'〓',         'Q='=>'〓',         'Q>'=>'〓',         'Q?'=>'〓',         'Q@'=>'〓',
            'QA'=>'&#63988;',   'QB'=>'&#63990;',   'QC'=>'&#63988;',   'QD'=>'〓',         'QE'=>'〓',
            'QF'=>'〓',         'QG'=>'〓',         'QH'=>'〓',         'QI'=>'〓',         'QJ'=>'&#63813;',
            'QK'=>'〓',         'QL'=>'〓',         'QM'=>'〓',         'QN'=>'〓',         'QO'=>'〓',
            'QP'=>'〓',         'QQ'=>'〓',         'QR'=>'[A]',        'QS'=>'[B]',        'QT'=>'[AB]',
            'QU'=>'[O]',        'QV'=>'&#63737;',   'QW'=>'&#63959;',   'QX'=>'〓',         'QY'=>'〓',
            'QZ'=>'〓',         'Q['=>'〓',         'Q\\'=>'[v',        'Q]'=>'oda;',       'Q^'=>'&#xFone]',
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * SoftBankからEZwebへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function softbank2ezweb($hex)
    {
        $map = array(
            'G!'=>'<img localsrc="80">;',     'G"'=>'<img localsrc="50">;',     'G#'=>'<img localsrc="273">;',    'G$'=>'<img localsrc="80">;',     'G%'=>'<img localsrc="50">;',
            'G&'=>'<img localsrc="335">;',    "G'"=>'<img localsrc="336">;',    'G('=>'<img localsrc="94">;',     'G)'=>'<img localsrc="85">;',     'G*'=>'<img localsrc="161">;',
            'G+'=>'<img localsrc="166">;',    'G,'=>'<img localsrc="337">;',    'G-'=>'<img localsrc="281">;',    'G.'=>'<img localsrc="287">;',    'G/'=>'<img localsrc="284">;',
            'G0'=>'<img localsrc="817">;',    'G1'=>'<img localsrc="319">;',    'G2'=>'<img localsrc="320">;',    'G3'=>'<img localsrc="421">;',    'G4'=>'<img localsrc="306">;',
            'G5'=>'<img localsrc="220">;',    'G6'=>'<img localsrc="45">;',     'G7'=>'<img localsrc="751">;',    'G8'=>'<img localsrc="219">;',    'G9'=>'<img localsrc="203">;',
            'G:'=>'<img localsrc="248">;',    'G;'=>'<img localsrc="125">;',    'G<'=>'<img localsrc="169">;',    'G='=>'<img localsrc="168">;',    'G>'=>'<img localsrc="172">;',
            'G?'=>'<img localsrc="217">;',    'G@'=>'<img localsrc="3">;',      'GA'=>'<img localsrc="2">;',      'GB'=>'<img localsrc="51">;',     'GC'=>'<img localsrc="265">;',
            'GD'=>'<img localsrc="46">;',     'GE'=>'<img localsrc="46">;',     'GF'=>'<img localsrc="46">;',     'GG'=>'<img localsrc="46">;',     'GH'=>'<img localsrc="46">;',
            'GI'=>'<img localsrc="46">;',     'GJ'=>'<img localsrc="46">;',     'GK'=>'<img localsrc="46">;',     'GL'=>'<img localsrc="46">;',     'GM'=>'<img localsrc="46">;',
            'GN'=>'<img localsrc="46">;',     'GO'=>'<img localsrc="46">;',     'GP'=>'<img localsrc="235">;',    'GQ'=>'<img localsrc="354">;',    'GR'=>'<img localsrc="339">;',
            'GS'=>'<img localsrc="234">;',    'GT'=>'<img localsrc="72">;',     'GU'=>'<img localsrc="72">;',     'GV'=>'<img localsrc="112">;',    'GW'=>'<img localsrc="340">;',
            'GX'=>'<img localsrc="156">;',    'GY'=>'<img localsrc="795">;',    'GZ'=>'<img localsrc="213">;',    'G['=>'<img localsrc="342">;',    'G\\'=>'<img localsrc="289">;',
            'G]'=>'<img localsrc="110">;',    'G^'=>'<img localsrc="343">;',    'G_'=>'<img localsrc="120">;',    'G`'=>'〓',                       'Ga'=>'<img localsrc="292">;',
            'Gb'=>'<img localsrc="469">;',    'Gc'=>'<img localsrc="146">;',    'Gd'=>'<img localsrc="52">;',     'Ge'=>'<img localsrc="93">;',     'Gf'=>'<img localsrc="239">;',
            'Gg'=>'<img localsrc="65">;',     'Gh'=>'<img localsrc="191">;',    'Gi'=>'<img localsrc="107">;',    'Gj'=>'<img localsrc="44">;',     'Gk'=>'<img localsrc="95">;',
            'Gl'=>'<img localsrc="15">;',     'Gm'=>'<img localsrc="493">;',    'Gn'=>'<img localsrc="344">;',    'Go'=>'<img localsrc="251">;',    'Gp'=>'<img localsrc="345">;',
            'Gq'=>'<img localsrc="346">;',    'Gr'=>'<img localsrc="134">;',    'Gs'=>'<img localsrc="347">;',    'Gt'=>'<img localsrc="246">;',    'Gu'=>'<img localsrc="252">;',
            'Gv'=>'<img localsrc="454">;',    'Gw'=>'<img localsrc="257">;',    'Gx'=>'<img localsrc="444">;',    'Gy'=>'<img localsrc="258">;',    'Gz'=>'<img localsrc="283">;',
            'E!'=>'<img localsrc="129">;',    'E"'=>'<img localsrc="129">;',    'E#'=>'<img localsrc="784">;',    'E$'=>'<img localsrc="513">;',    'E%'=>'<img localsrc="264">;',
            'E&'=>'<img localsrc="349">;',    "E'"=>'<img localsrc="350">;',    'E('=>'<img localsrc="351">;',    'E)'=>'<img localsrc="249">;',    'E*'=>'<img localsrc="352">;',
            'E+'=>'<img localsrc="254">;',    'E,'=>'<img localsrc="274">;',    'E-'=>'<img localsrc="353">;',    'E.'=>'<img localsrc="354">;',    'E/'=>'<img localsrc="77">;',
            'E0'=>'<img localsrc="53">;',     'E1'=>'<img localsrc="355">;',    'E2'=>'<img localsrc="144">;',    'E3'=>'<img localsrc="296">;',    'E4'=>'<img localsrc="119">;',
            'E5'=>'<img localsrc="218">;',    'E6'=>'<img localsrc="356">;',    'E7'=>'<img localsrc="357">;',    'E8'=>'<img localsrc="133">;',    'E9'=>'<img localsrc="358">;',
            'E:'=>'<img localsrc="277">;',    'E;'=>'<img localsrc="236">;',    'E<'=>'<img localsrc="286">;',    'E='=>'<img localsrc="269">;',    'E>'=>'<img localsrc="359">;',
            'E?'=>'〓',                       'E@'=>'<img localsrc="245">;',    'EA'=>'<img localsrc="360">;',    'EB'=>'<img localsrc="361">;',    'EC'=>'<img localsrc="224">;',
            'ED'=>'<img localsrc="223">;',    'EE'=>'<img localsrc="106">;',    'EF'=>'<img localsrc="300">;',    'EG'=>'<img localsrc="300">;',    'EH'=>'<img localsrc="338">;',
            'EI'=>'<img localsrc="115">;',    'EJ'=>'<img localsrc="288">;',    'EK'=>'<img localsrc="274">;',    'EL'=>'〓',                       'EM'=>'<img localsrc="362">;',
            'EN'=>'<img localsrc="363">;',    'EO'=>'<img localsrc="233">;',    'EP'=>'<img localsrc="231">;',    'EQ'=>'<img localsrc="364">;',    'ER'=>'<img localsrc="222">;',
            'ES'=>'<img localsrc="229">;',    'ET'=>'<img localsrc="248">;',    'EU'=>'<img localsrc="169">;',    'EV'=>'<img localsrc="215">;',    'EW'=>'<img localsrc="368">;',
            'EX'=>'[♂]',                     'EY'=>'[♀]',                     'EZ'=>'<img localsrc="710">;',    'E['=>'<img localsrc="304">;',    'E\\'=>'<img localsrc="261">;',
            'E]'=>'<img localsrc="16">;',     'E^'=>'<img localsrc="124">;',    'E_'=>'<img localsrc="369">;',    'E`'=>'<img localsrc="207">;',    'Ea'=>'<img localsrc="13">;',
            'Eb'=>'<img localsrc="13">;',     'Ec'=>'<img localsrc="370">;',    'Ed'=>'<img localsrc="138">;',    'Ee'=>'<img localsrc="138">;',    'Ef'=>'<img localsrc="371">;',
            'Eg'=>'<img localsrc="240">;',    'Eh'=>'<img localsrc="122">;',    'Ei'=>'[$\]',                     'Ej'=>'<img localsrc="373">;',    'Ek'=>'<img localsrc="210">;',
            'El'=>'<img localsrc="271">;',    'Em'=>'<img localsrc="212">;',    'En'=>'<img localsrc="99">;',     'Eo'=>'<img localsrc="208">;',    'Ep'=>'<img localsrc="209">;',
            'Eq'=>'<img localsrc="207">;',    'Er'=>'<img localsrc="374">;',    'Es'=>'<img localsrc="375">;',    'Et'=>'<img localsrc="205">;',    'Eu'=>'<img localsrc="376">;',
            'Ev'=>'<img localsrc="206">;',    'Ew'=>'<img localsrc="377">;',    'Ex'=>'<img localsrc="378">;',    'Ey'=>'<img localsrc="216">;',    'Ez'=>'<img localsrc="125">;',
            'F!'=>'<img localsrc="800">;',    'F"'=>'<img localsrc="379">;',    'F#'=>'[ココ]',                   'F$'=>'<img localsrc="51">;',     'F%'=>'<img localsrc="267">;',
            'F&'=>'<img localsrc="28">;',     "F'"=>'<img localsrc="380">;',    'F('=>'<img localsrc="177">;',    'F)'=>'<img localsrc="179">;',    'F*'=>'<img localsrc="178">;',
            'F+'=>'<img localsrc="381">;',    'F,'=>'<img localsrc="414">;',    'F-'=>'<img localsrc="315">;',    'F.'=>'<img localsrc="314">;',    'F/'=>'<img localsrc="316">;',
            'F0'=>'<img localsrc="818">;',    'F1'=>'〓',                       'F2'=>'<img localsrc="334">;',    'F3'=>'<img localsrc="303">;',    'F4'=>'<img localsrc="382">;',
            'F5'=>'[有]',                     'F6'=>'[無]',                     'F7'=>'[月]',                     'F8'=>'[申]',                     'F9'=>'<img localsrc="40">;',
            'F:'=>'<img localsrc="41">;',     'F;'=>'<img localsrc="41">;',     'F<'=>'<img localsrc="180">;',    'F='=>'<img localsrc="181">;',    'F>'=>'<img localsrc="182">;',
            'F?'=>'<img localsrc="183">;',    'F@'=>'<img localsrc="184">;',    'FA'=>'<img localsrc="185">;',    'FB'=>'<img localsrc="186">;',    'FC'=>'<img localsrc="187">;',
            'FD'=>'<img localsrc="188">;',    'FE'=>'<img localsrc="325">;',    'FF'=>'<img localsrc="285">;',    'FG'=>'<img localsrc="383">;',    'FH'=>'<img localsrc="384">;',
            'FI'=>'<img localsrc="385">;',    'FJ'=>'<img localsrc="386">;',    'FK'=>'<img localsrc="387">;',    'FL'=>'<img localsrc="388">;',    'FM'=>'<img localsrc="389">;',
            'FN'=>'<img localsrc="390">;',    'FO'=>'<img localsrc="391">;',    'FP'=>'<img localsrc="140">;',    'FQ'=>'<img localsrc="141">;',    'FR'=>'<img localsrc="29">;',
            'FS'=>'<img localsrc="30">;',     'FT'=>'<img localsrc="63">;',     'FU'=>'<img localsrc="64">;',     'FV'=>'<img localsrc="70">;',     'FW'=>'<img localsrc="42">;',
            'FX'=>'<img localsrc="43">;',     'FY'=>'<img localsrc="71">;',     'FZ'=>'<img localsrc="6">;',      'F['=>'<img localsrc="5">;',      'F\\'=>'<img localsrc="8">;',
            'F]'=>'<img localsrc="7">;',      'F^'=>'<img localsrc="392">;',    'F_'=>'<img localsrc="192">;',    'F`'=>'<img localsrc="193">;',    'Fa'=>'<img localsrc="194">;',
            'Fb'=>'<img localsrc="195">;',    'Fc'=>'<img localsrc="196">;',    'Fd'=>'<img localsrc="197">;',    'Fe'=>'<img localsrc="198">;',    'Ff'=>'<img localsrc="199">;',
            'Fg'=>'<img localsrc="200">;',    'Fh'=>'<img localsrc="201">;',    'Fi'=>'<img localsrc="202">;',    'Fj'=>'<img localsrc="203">;',    'Fk'=>'<img localsrc="204">;',
            'Fl'=>'[TOP]',                    'Fm'=>'<img localsrc="326">;',    'Fn'=>'<img localsrc="81">;',     'Fo'=>'<img localsrc="82">;',     'Fp'=>'<img localsrc="393">;',
            'Fq'=>'<img localsrc="394">;',    'Fr'=>'<img localsrc="1">;',      'Fs'=>'〓',                       'Ft'=>'〓',                       'Fu'=>'〓',
            'Fv'=>'〓',                       'Fw'=>'〓',                       'Fx'=>'〓',                       'Fy'=>'〓',                       'Fz'=>'〓',
            'O!'=>'<img localsrc="395">;',    'O"'=>'<img localsrc="396">;',    'O#'=>'<img localsrc="397">;',    'O$'=>'<img localsrc="113">;',    'O%'=>'<img localsrc="256">;',
            'O&'=>'<img localsrc="398">;',    "O'"=>'<img localsrc="255">;',    'O('=>'<img localsrc="399">;',    'O)'=>'[WC]',                     'O*'=>'<img localsrc="294">;',
            'O+'=>'<img localsrc="400">;',    'O,'=>'<img localsrc="401">;',    'O-'=>'<img localsrc="402">;',    'O.'=>'<img localsrc="176">;',    'O/'=>'<img localsrc="403">;',
            'O0'=>'<img localsrc="404">;',    'O1'=>'<img localsrc="268">;',    'O2'=>'<img localsrc="405">;',    'O3'=>'<img localsrc="104">;',    'O4'=>'<img localsrc="312">;',
            'O5'=>'<img localsrc="279">;',    'O6'=>'<img localsrc="126">;',    'O7'=>'<img localsrc="13">;',     'O8'=>'<img localsrc="407">;',    'O9'=>'<img localsrc="793">;',
            'O:'=>'<img localsrc="124">;',    'O;'=>'<img localsrc="408">;',    'O<'=>'<img localsrc="295">;',    'O='=>'<img localsrc="409">;',    'O>'=>'<img localsrc="297">;',
            'O?'=>'<img localsrc="410">;',    'O@'=>'<img localsrc="411">;',    'OA'=>'<img localsrc="412">;',    'OB'=>'<img localsrc="413">;',    'OC'=>'<img localsrc="83">;',
            'OD'=>'<img localsrc="226">;',    'OE'=>'<img localsrc="48">;',     'OF'=>'<img localsrc="291">;',    'OG'=>'<img localsrc="415">;',    'OH'=>'<img localsrc="803">;',
            'OI'=>'<img localsrc="272">;',    'OJ'=>'<img localsrc="416">;',    'OK'=>'<img localsrc="417">;',    'OL'=>'<img localsrc="418">;',    'OM'=>'<img localsrc="419">;',
            'ON'=>'<img localsrc="420">;',    'OO'=>'<img localsrc="69">;',     'OP'=>'<img localsrc="282">;',    'OQ'=>'<img localsrc="330">;',    'OR'=>'<img localsrc="422">;',
            'OS'=>'<img localsrc="61">;',     'OT'=>'<img localsrc="262">;',    'OU'=>'<img localsrc="69">;',     'OV'=>'<img localsrc="3">;',      'OW'=>'<img localsrc="2">;',
            'OX'=>'<img localsrc="423">;',    'OY'=>'<img localsrc="424">;',    'OZ'=>'<img localsrc="425">;',    'O['=>'<img localsrc="426">;',    'O\\'=>'<img localsrc="427">;',
            'O]'=>'<img localsrc="428">;',    'O^'=>'<img localsrc="429">;',    'O_'=>'<img localsrc="430">;',    'O`'=>'<img localsrc="333">;',    'Oa'=>'<img localsrc="431">;',
            'Ob'=>'<img localsrc="244">;',    'Oc'=>'<img localsrc="432">;',    'Od'=>'<img localsrc="433">;',    'Oe'=>'<img localsrc="434">;',    'Of'=>'<img localsrc="435">;',
            'Og'=>'<img localsrc="243">;',    'Oh'=>'<img localsrc="238">;',    'Oi'=>'<img localsrc="436">;',    'Oj'=>'<img localsrc="437">;',    'Ok'=>'<img localsrc="313">;',
            'Ol'=>'<img localsrc="438">;',    'Om'=>'<img localsrc="439">;',    'P!'=>'<img localsrc="351">;',    'P"'=>'<img localsrc="440">;',    'P#'=>'<img localsrc="441">;',
            'P$'=>'<img localsrc="442">;',    'P%'=>'<img localsrc="348">;',    'P&'=>'<img localsrc="443">;',    "P'"=>'<img localsrc="444">;',    'P('=>'<img localsrc="445">;',
            'P)'=>'<img localsrc="264">;',    'P*'=>'<img localsrc="446">;',    'P+'=>'<img localsrc="447">;',    'P,'=>'<img localsrc="448">;',    'P-'=>'<img localsrc="449">;',
            'P.'=>'<img localsrc="450">;',    'P/'=>'<img localsrc="447">;',    'P0'=>'<img localsrc="451">;',    'P1'=>'<img localsrc="259">;',    'P2'=>'<img localsrc="786">;',
            'P3'=>'<img localsrc="791">;',    'P4'=>'<img localsrc="454">;',    'P5'=>'<img localsrc="257">;',    'P6'=>'<img localsrc="779">;',    'P7'=>'<img localsrc="455">;',
            'P8'=>'<img localsrc="456">;',    'P9'=>'<img localsrc="317">;',    'P:'=>'<img localsrc="457">;',    'P;'=>'<img localsrc="318">;',    'P<'=>'<img localsrc="458">;',
            'P='=>'<img localsrc="459">;',    'P>'=>'<img localsrc="463">;',    'P?'=>'<img localsrc="460">;',    'P@'=>'<img localsrc="461">;',    'PA'=>'<img localsrc="462">;',
            'PB'=>'<img localsrc="463">;',    'PC'=>'<img localsrc="464">;',    'PD'=>'<img localsrc="465">;',    'PE'=>'<img localsrc="467">;',    'PF'=>'<img localsrc="466">;',
            'PG'=>'<img localsrc="820">;',    'PH'=>'〓',                       'PI'=>'<img localsrc="468">;',    'PJ'=>'<img localsrc="307">;',    'PK'=>'<img localsrc="96">;',
            'PL'=>'<img localsrc="470">;',    'PM'=>'<img localsrc="471">;',    'PN'=>'<img localsrc="125">;',    'PO'=>'<img localsrc="148">;',    'PP'=>'<img localsrc="472">;',
            'PQ'=>'<img localsrc="473">;',    'PR'=>'<img localsrc="474">;',    'PS'=>'<img localsrc="475">;',    'PT'=>'<img localsrc="341">;',    'PU'=>'<img localsrc="217">;',
            'PV'=>'<img localsrc="476">;',    'PW'=>'<img localsrc="770">;',    'PX'=>'<img localsrc="477">;',    'PY'=>'<img localsrc="478">;',    'PZ'=>'<img localsrc="479">;',
            'P['=>'<img localsrc="480">;',    'P\\'=>'<img localsrc="481">;',   'P]'=>'<img localsrc="340">;',    'P^'=>'<img localsrc="810">;',    'P_'=>'<img localsrc="483">;',
            'P`'=>'<img localsrc="484">;',    'Pa'=>'<img localsrc="485">;',    'Pb'=>'<img localsrc="486">;',    'Pc'=>'<img localsrc="190">;',    'Pd'=>'〓',
            'Pe'=>'<img localsrc="487">;',    'Pf'=>'<img localsrc="488">;',    'Pg'=>'<img localsrc="358">;',    'Ph'=>'<img localsrc="489">;',    'Pi'=>'<img localsrc="493">;',
            'Pj'=>'<img localsrc="371">;',    'Pk'=>'<img localsrc="490">;',    'Pl'=>'<img localsrc="491">;',    'Q!'=>'<img localsrc="492">;',    'Q"'=>'<img localsrc="309">;',
            'Q#'=>'<img localsrc="494">;',    'Q$'=>'<img localsrc="495">;',    'Q%'=>'<img localsrc="496">;',    'Q&'=>'<img localsrc="497">;',    "Q'"=>'<img localsrc="110">;',
            'Q('=>'<img localsrc="498">;',    'Q)'=>'<img localsrc="228">;',    'Q*'=>'〓',                       'Q+'=>'<img localsrc="237">;',    'Q,'=>'<img localsrc="90">;',
            'Q-'=>'<img localsrc="499">;',    'Q.'=>'<img localsrc="700">;',    'Q/'=>'<img localsrc="701">;',    'Q0'=>'<img localsrc="702">;',    'Q1'=>'<img localsrc="366">;',
            'Q2'=>'<img localsrc="367">;',    'Q3'=>'<img localsrc="703">;',    'Q4'=>'<img localsrc="704">;',    'Q5'=>'<img localsrc="705">;',    'Q6'=>'<img localsrc="706">;',
            'Q7'=>'<img localsrc="707">;',    'Q8'=>'<img localsrc="708">;',    'Q9'=>'<img localsrc="709">;',    'Q:'=>'<img localsrc="710">;',    'Q;'=>'<img localsrc="711">;',
            'Q<'=>'<img localsrc="712">;',    'Q='=>'〓',                       'Q>'=>'〓',                       'Q?'=>'<img localsrc="714">;',    'Q@'=>'<img localsrc="713">;',
            'QA'=>'<img localsrc="78">;',     'QB'=>'<img localsrc="715">;',    'QC'=>'<img localsrc="78">;',     'QD'=>'〓',                       'QE'=>'<img localsrc="716">;',
            'QF'=>'<img localsrc="717">;',    'QG'=>'<img localsrc="718">;',    'QH'=>'<img localsrc="249">;',    'QI'=>'<img localsrc="192">;',    'QJ'=>'<img localsrc="134">;',
            'QK'=>'<img localsrc="719">;',    'QL'=>'<img localsrc="247">;',    'QM'=>'<img localsrc="720">;',    'QN'=>'<img localsrc="721">;',    'QO'=>'<img localsrc="722">;',
            'QP'=>'<img localsrc="723">;',    'QQ'=>'<img localsrc="250">;',    'QR'=>'<img localsrc="724">;',    'QS'=>'<img localsrc="725">;',    'QT'=>'<img localsrc="727">;',
            'QU'=>'<img localsrc="726">;',    'QV'=>'<img localsrc="728">;',    'QW'=>'<img localsrc="54">;',     'QX'=>'〓',                       'QY'=>'〓',
            'QZ'=>'〓',                       'Q['=>'〓',                       'Q\\'=>'[v',                      'Q]'=>'oda;',                     'Q^'=>'&#xFone]',
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * SoftBankからSoftBankへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function softbank2softbank($hex)
    {
        $map = array(
            'G!'=>'G!',    'G"'=>'G"',    'G#'=>'G#',    'G$'=>'G$',    'G%'=>'G%',
            'G&'=>'G&',    "G'"=>"G'",    'G('=>'G(',    'G)'=>'G)',    'G*'=>'G*',
            'G+'=>'G+',    'G,'=>'G,',    'G-'=>'G-',    'G.'=>'G.',    'G/'=>'G/',
            'G0'=>'G0',    'G1'=>'G1',    'G2'=>'G2',    'G3'=>'G3',    'G4'=>'G4',
            'G5'=>'G5',    'G6'=>'G6',    'G7'=>'G7',    'G8'=>'G8',    'G9'=>'G9',
            'G:'=>'G:',    'G;'=>'G;',    'G<'=>'G<',    'G='=>'G=',    'G>'=>'G>',
            'G?'=>'G?',    'G@'=>'G@',    'GA'=>'GA',    'GB'=>'GB',    'GC'=>'GC',
            'GD'=>'GD',    'GE'=>'GE',    'GF'=>'GF',    'GG'=>'GG',    'GH'=>'GH',
            'GI'=>'GI',    'GJ'=>'GJ',    'GK'=>'GK',    'GL'=>'GL',    'GM'=>'GM',
            'GN'=>'GN',    'GO'=>'GO',    'GP'=>'GP',    'GQ'=>'GQ',    'GR'=>'GR',
            'GS'=>'GS',    'GT'=>'GT',    'GU'=>'GU',    'GV'=>'GV',    'GW'=>'GW',
            'GX'=>'GX',    'GY'=>'GY',    'GZ'=>'GZ',    'G['=>'G[',    'G\\'=>'G\\',
            'G]'=>'G]',    'G^'=>'G^',    'G_'=>'G_',    'G`'=>'G`',    'Ga'=>'Ga',
            'Gb'=>'Gb',    'Gc'=>'Gc',    'Gd'=>'Gd',    'Ge'=>'Ge',    'Gf'=>'Gf',
            'Gg'=>'Gg',    'Gh'=>'Gh',    'Gi'=>'Gi',    'Gj'=>'Gj',    'Gk'=>'Gk',
            'Gl'=>'Gl',    'Gm'=>'Gm',    'Gn'=>'Gn',    'Go'=>'Go',    'Gp'=>'Gp',
            'Gq'=>'Gq',    'Gr'=>'Gr',    'Gs'=>'Gs',    'Gt'=>'Gt',    'Gu'=>'Gu',
            'Gv'=>'Gv',    'Gw'=>'Gw',    'Gx'=>'Gx',    'Gy'=>'Gy',    'Gz'=>'Gz',
            'E!'=>'E!',    'E"'=>'E"',    'E#'=>'E#',    'E$'=>'E$',    'E%'=>'E%',
            'E&'=>'E&',    "E'"=>"E'",    'E('=>'E(',    'E)'=>'E)',    'E*'=>'E*',
            'E+'=>'E+',    'E,'=>'E,',    'E-'=>'E-',    'E.'=>'E.',    'E/'=>'E/',
            'E0'=>'E0',    'E1'=>'E1',    'E2'=>'E2',    'E3'=>'E3',    'E4'=>'E4',
            'E5'=>'E5',    'E6'=>'E6',    'E7'=>'E7',    'E8'=>'E8',    'E9'=>'E9',
            'E:'=>'E:',    'E;'=>'E;',    'E<'=>'E<',    'E='=>'E=',    'E>'=>'E>',
            'E?'=>'E?',    'E@'=>'E@',    'EA'=>'EA',    'EB'=>'EB',    'EC'=>'EC',
            'ED'=>'ED',    'EE'=>'EE',    'EF'=>'EF',    'EG'=>'EG',    'EH'=>'EH',
            'EI'=>'EI',    'EJ'=>'EJ',    'EK'=>'EK',    'EL'=>'EL',    'EM'=>'EM',
            'EN'=>'EN',    'EO'=>'EO',    'EP'=>'EP',    'EQ'=>'EQ',    'ER'=>'ER',
            'ES'=>'ES',    'ET'=>'ET',    'EU'=>'EU',    'EV'=>'EV',    'EW'=>'EW',
            'EX'=>'EX',    'EY'=>'EY',    'EZ'=>'EZ',    'E['=>'E[',    'E\\'=>'E\\',
            'E]'=>'E]',    'E^'=>'E^',    'E_'=>'E_',    'E`'=>'E`',    'Ea'=>'Ea',
            'Eb'=>'Eb',    'Ec'=>'Ec',    'Ed'=>'Ed',    'Ee'=>'Ee',    'Ef'=>'Ef',
            'Eg'=>'Eg',    'Eh'=>'Eh',    'Ei'=>'Ei',    'Ej'=>'Ej',    'Ek'=>'Ek',
            'El'=>'El',    'Em'=>'Em',    'En'=>'En',    'Eo'=>'Eo',    'Ep'=>'Ep',
            'Eq'=>'Eq',    'Er'=>'Er',    'Es'=>'Es',    'Et'=>'Et',    'Eu'=>'Eu',
            'Ev'=>'Ev',    'Ew'=>'Ew',    'Ex'=>'Ex',    'Ey'=>'Ey',    'Ez'=>'Ez',
            'F!'=>'F!',    'F"'=>'F"',    'F#'=>'F#',    'F$'=>'F$',    'F%'=>'F%',
            'F&'=>'F&',    "F'"=>"F'",    'F('=>'F(',    'F)'=>'F)',    'F*'=>'F*',
            'F+'=>'F+',    'F,'=>'F,',    'F-'=>'F-',    'F.'=>'F.',    'F/'=>'F/',
            'F0'=>'F0',    'F1'=>'F1',    'F2'=>'F2',    'F3'=>'F3',    'F4'=>'F4',
            'F5'=>'F5',    'F6'=>'F6',    'F7'=>'F7',    'F8'=>'F8',    'F9'=>'F9',
            'F:'=>'F:',    'F;'=>'F;',    'F<'=>'F<',    'F='=>'F=',    'F>'=>'F>',
            'F?'=>'F?',    'F@'=>'F@',    'FA'=>'FA',    'FB'=>'FB',    'FC'=>'FC',
            'FD'=>'FD',    'FE'=>'FE',    'FF'=>'FF',    'FG'=>'FG',    'FH'=>'FH',
            'FI'=>'FI',    'FJ'=>'FJ',    'FK'=>'FK',    'FL'=>'FL',    'FM'=>'FM',
            'FN'=>'FN',    'FO'=>'FO',    'FP'=>'FP',    'FQ'=>'FQ',    'FR'=>'FR',
            'FS'=>'FS',    'FT'=>'FT',    'FU'=>'FU',    'FV'=>'FV',    'FW'=>'FW',
            'FX'=>'FX',    'FY'=>'FY',    'FZ'=>'FZ',    'F['=>'F[',    'F\\'=>'F\\',
            'F]'=>'F]',    'F^'=>'F^',    'F_'=>'F_',    'F`'=>'F`',    'Fa'=>'Fa',
            'Fb'=>'Fb',    'Fc'=>'Fc',    'Fd'=>'Fd',    'Fe'=>'Fe',    'Ff'=>'Ff',
            'Fg'=>'Fg',    'Fh'=>'Fh',    'Fi'=>'Fi',    'Fj'=>'Fj',    'Fk'=>'Fk',
            'Fl'=>'Fl',    'Fm'=>'Fm',    'Fn'=>'Fn',    'Fo'=>'Fo',    'Fp'=>'Fp',
            'Fq'=>'Fq',    'Fr'=>'Fr',    'Fs'=>'Fs',    'Ft'=>'Ft',    'Fu'=>'Fu',
            'Fv'=>'Fv',    'Fw'=>'Fw',    'Fx'=>'Fx',    'Fy'=>'Fy',    'Fz'=>'Fz',
            'O!'=>'O!',    'O"'=>'O"',    'O#'=>'O#',    'O$'=>'O$',    'O%'=>'O%',
            'O&'=>'O&',    "O'"=>"O'",    'O('=>'O(',    'O)'=>'O)',    'O*'=>'O*',
            'O+'=>'O+',    'O,'=>'O,',    'O-'=>'O-',    'O.'=>'O.',    'O/'=>'O/',
            'O0'=>'O0',    'O1'=>'O1',    'O2'=>'O2',    'O3'=>'O3',    'O4'=>'O4',
            'O5'=>'O5',    'O6'=>'O6',    'O7'=>'O7',    'O8'=>'O8',    'O9'=>'O9',
            'O:'=>'O:',    'O;'=>'O;',    'O<'=>'O<',    'O='=>'O=',    'O>'=>'O>',
            'O?'=>'O?',    'O@'=>'O@',    'OA'=>'OA',    'OB'=>'OB',    'OC'=>'OC',
            'OD'=>'OD',    'OE'=>'OE',    'OF'=>'OF',    'OG'=>'OG',    'OH'=>'OH',
            'OI'=>'OI',    'OJ'=>'OJ',    'OK'=>'OK',    'OL'=>'OL',    'OM'=>'OM',
            'ON'=>'ON',    'OO'=>'OO',    'OP'=>'OP',    'OQ'=>'OQ',    'OR'=>'OR',
            'OS'=>'OS',    'OT'=>'OT',    'OU'=>'OU',    'OV'=>'OV',    'OW'=>'OW',
            'OX'=>'OX',    'OY'=>'OY',    'OZ'=>'OZ',    'O['=>'O[',    'O\\'=>'O\\',
            'O]'=>'O]',    'O^'=>'O^',    'O_'=>'O_',    'O`'=>'O`',    'Oa'=>'Oa',
            'Ob'=>'Ob',    'Oc'=>'Oc',    'Od'=>'Od',    'Oe'=>'Oe',    'Of'=>'Of',
            'Og'=>'Og',    'Oh'=>'Oh',    'Oi'=>'Oi',    'Oj'=>'Oj',    'Ok'=>'Ok',
            'Ol'=>'Ol',    'Om'=>'Om',    'P!'=>'P!',    'P"'=>'P"',    'P#'=>'P#',
            'P$'=>'P$',    'P%'=>'P%',    'P&'=>'P&',    "P'"=>"P'",    'P('=>'P(',
            'P)'=>'P)',    'P*'=>'P*',    'P+'=>'P+',    'P,'=>'P,',    'P-'=>'P-',
            'P.'=>'P.',    'P/'=>'P/',    'P0'=>'P0',    'P1'=>'P1',    'P2'=>'P2',
            'P3'=>'P3',    'P4'=>'P4',    'P5'=>'P5',    'P6'=>'P6',    'P7'=>'P7',
            'P8'=>'P8',    'P9'=>'P9',    'P:'=>'P:',    'P;'=>'P;',    'P<'=>'P<',
            'P='=>'P=',    'P>'=>'P>',    'P?'=>'P?',    'P@'=>'P@',    'PA'=>'PA',
            'PB'=>'PB',    'PC'=>'PC',    'PD'=>'PD',    'PE'=>'PE',    'PF'=>'PF',
            'PG'=>'PG',    'PH'=>'PH',    'PI'=>'PI',    'PJ'=>'PJ',    'PK'=>'PK',
            'PL'=>'PL',    'PM'=>'PM',    'PN'=>'PN',    'PO'=>'PO',    'PP'=>'PP',
            'PQ'=>'PQ',    'PR'=>'PR',    'PS'=>'PS',    'PT'=>'PT',    'PU'=>'PU',
            'PV'=>'PV',    'PW'=>'PW',    'PX'=>'PX',    'PY'=>'PY',    'PZ'=>'PZ',
            'P['=>'P[',    'P\\'=>'P\\',  'P]'=>'P]',    'P^'=>'P^',    'P_'=>'P_',
            'P`'=>'P`',    'Pa'=>'Pa',    'Pb'=>'Pb',    'Pc'=>'Pc',    'Pd'=>'Pd',
            'Pe'=>'Pe',    'Pf'=>'Pf',    'Pg'=>'Pg',    'Ph'=>'Ph',    'Pi'=>'Pi',
            'Pj'=>'Pj',    'Pk'=>'Pk',    'Pl'=>'Pl',    'Q!'=>'Q!',    'Q"'=>'Q"',
            'Q#'=>'Q#',    'Q$'=>'Q$',    'Q%'=>'Q%',    'Q&'=>'Q&',    "Q'"=>"Q'",
            'Q('=>'Q(',    'Q)'=>'Q)',    'Q*'=>'Q*',    'Q+'=>'Q+',    'Q,'=>'Q,',
            'Q-'=>'Q-',    'Q.'=>'Q.',    'Q/'=>'Q/',    'Q0'=>'Q0',    'Q1'=>'Q1',
            'Q2'=>'Q2',    'Q3'=>'Q3',    'Q4'=>'Q4',    'Q5'=>'Q5',    'Q6'=>'Q6',
            'Q7'=>'Q7',    'Q8'=>'Q8',    'Q9'=>'Q9',    'Q:'=>'Q:',    'Q;'=>'Q;',
            'Q<'=>'Q<',    'Q='=>'Q=',    'Q>'=>'Q>',    'Q?'=>'Q?',    'Q@'=>'Q@',
            'QA'=>'QA',    'QB'=>'QB',    'QC'=>'QC',    'QD'=>'QD',    'QE'=>'QE',
            'QF'=>'QF',    'QG'=>'QG',    'QH'=>'QH',    'QI'=>'QI',    'QJ'=>'QJ',
            'QK'=>'QK',    'QL'=>'QL',    'QM'=>'QM',    'QN'=>'QN',    'QO'=>'QO',
            'QP'=>'QP',    'QQ'=>'QQ',    'QR'=>'QR',    'QS'=>'QS',    'QT'=>'QT',
            'QU'=>'QU',    'QV'=>'QV',    'QW'=>'QW',    'QX'=>'QX',    'QY'=>'QY',
            'QZ'=>'QZ',    'Q['=>'Q[',    'Q\\'=>'Q\\',  'Q]'=>'Q]',    'Q^'=>'Q^',
        );

        return empty($map[$hex])?'':''.$map[$hex].'';
    }
} // emoji_SoftBank
?>