<?php
/* SVN FILE: $Id: EZweb.php 454 2008-05-22 09:23:33Z bb_yujiro $ */
/**
 * EZweb用絵文字変換
 *
 * 参考資料：
 *       [絵文字の相互変換リスト] http://labs.unoh.net/2007/02/post_65.html
 *
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 454 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:23:33 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * EZweb用絵文字変換
 *
 * @category        Emoji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 454 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:23:33 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_Emoji_EZweb
{
    /**
     * EZwebから独自タグへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function ezweb2tag($hex)
    {
        $map = array(
            '63065'=>'[m:1]',      '63066'=>'[m:2]',      '63067'=>'[m:3]',      '63304'=>'[m:4]',      '63305'=>'[m:5]',
            '63306'=>'[m:6]',      '63307'=>'[m:7]',      '63308'=>'[m:8]',      '63309'=>'[m:9]',      '63310'=>'[m:10]',
            '63311'=>'[m:11]',     '63130'=>'[m:12]',     '63210'=>'[m:13]',     '63382'=>'[m:14]',     '63070'=>'[m:15]',
            '63071'=>'[m:16]',     '63312'=>'[m:17]',     '63313'=>'[m:18]',     '63314'=>'[m:19]',     '63315'=>'[m:20]',
            '63316'=>'[m:21]',     '63317'=>'[m:22]',     '63318'=>'[m:23]',     '63319'=>'[m:24]',     '63383'=>'[m:25]',
            '63320'=>'[m:26]',     '63321'=>'[m:27]',     '63322'=>'[m:28]',     '63323'=>'[m:29]',     '63324'=>'[m:30]',
            '63325'=>'[m:31]',     '63326'=>'[m:32]',     '63327'=>'[m:33]',     '63328'=>'[m:34]',     '63329'=>'[m:35]',
            '63330'=>'[m:36]',     '63331'=>'[m:37]',     '63332'=>'[m:38]',     '63333'=>'[m:39]',     '63334'=>'[m:40]',
            '63335'=>'[m:41]',     '63336'=>'[m:42]',     '63337'=>'[m:43]',     '63072'=>'[m:44]',     '63123'=>'[m:45]',
            '63409'=>'[m:46]',     '63073'=>'[m:47]',     '63211'=>'[m:48]',     '63356'=>'[m:49]',     '63187'=>'[m:50]',
            '63410'=>'[m:51]',     '63131'=>'[m:52]',     '63212'=>'[m:53]',     '63338'=>'[m:54]',     '63339'=>'[m:55]',
            '63357'=>'[m:56]',     '63384'=>'[m:57]',     '63060'=>'[m:58]',     '63358'=>'[m:59]',     '63074'=>'[m:60]',
            '63340'=>'[m:61]',     '63341'=>'[m:62]',     '63342'=>'[m:63]',     '63343'=>'[m:64]',     '63132'=>'[m:65]',
            '63344'=>'[m:66]',     '63360'=>'[m:67]',     '63188'=>'[m:68]',     '63075'=>'[m:69]',     '63345'=>'[m:70]',
            '63346'=>'[m:71]',     '63213'=>'[m:72]',     '63347'=>'[m:73]',     '63160'=>'[m:74]',     '63040'=>'[m:75]',
            '63044'=>'[m:76]',     '63054'=>'[m:77]',     '63161'=>'[m:78]',     '63404'=>'[m:79]',     '63189'=>'[m:80]',
            '63348'=>'[m:81]',     '63349'=>'[m:82]',     '63092'=>'[m:83]',     '63405'=>'[m:84]',     '63411'=>'[m:85]',
            '63190'=>'[m:86]',     '63385'=>'[m:87]',     '63350'=>'[m:88]',     '63351'=>'[m:89]',     '63376'=>'[m:90]',
            '63093'=>'[m:91]',     '63361'=>'[m:92]',     '63412'=>'[m:93]',     '63214'=>'[m:94]',     '63076'=>'[m:95]',
            '63124'=>'[m:96]',     '63362'=>'[m:97]',     '63068'=>'[m:98]',     '63042'=>'[m:99]',     '63363'=>'[m:100]',
            '63364'=>'[m:101]',    '63365'=>'[m:102]',    '63366'=>'[m:103]',    '63215'=>'[m:104]',    '63367'=>'[m:105]',
            '63094'=>'[m:106]',    '63077'=>'[m:107]',    '63226'=>'[m:108]',    '63386'=>'[m:109]',    '63216'=>'[m:110]',
            '63387'=>'[m:111]',    '63108'=>'[m:112]',    '63165'=>'[m:113]',    '63388'=>'[m:114]',    '63389'=>'[m:115]',
            '63191'=>'[m:116]',    '63352'=>'[m:117]',    '63353'=>'[m:118]',    '63217'=>'[m:119]',    '63218'=>'[m:120]',
            '63368'=>'[m:121]',    '63095'=>'[m:122]',    '63390'=>'[m:123]',    '63219'=>'[m:124]',    '63114'=>'[m:125]',
            '63391'=>'[m:126]',    '63377'=>'[m:127]',    '63378'=>'[m:128]',    '63220'=>'[m:129]',    '63392'=>'[m:130]',
            '63369'=>'[m:131]',    '63354'=>'[m:132]',    '63143'=>'[m:133]',    '63162'=>'[m:134]',    '63393'=>'[m:135]',
            '63355'=>'[m:136]',    '63370'=>'[m:137]',    '63221'=>'[m:138]',    '63394'=>'[m:139]',    '63192'=>'[m:140]',
            '63193'=>'[m:141]',    '63371'=>'[m:142]',    '63096'=>'[m:143]',    '63144'=>'[m:144]',    '63222'=>'[m:145]',
            '63109'=>'[m:146]',    '63372'=>'[m:147]',    '63115'=>'[m:148]',    '63097'=>'[m:149]',    '63395'=>'[m:150]',
            '63406'=>'[m:151]',    '63396'=>'[m:152]',    '63407'=>'[m:153]',    '63408'=>'[m:154]',    '63223'=>'[m:155]',
            '63110'=>'[m:156]',    '63373'=>'[m:157]',    '63098'=>'[m:158]',    '63379'=>'[m:159]',    '63133'=>'[m:160]',
            '63397'=>'[m:161]',    '63398'=>'[m:162]',    '63194'=>'[m:163]',    '63399'=>'[m:164]',    '63224'=>'[m:165]',
            '63225'=>'[m:166]',    '63078'=>'[m:167]',    '63116'=>'[m:168]',    '63117'=>'[m:169]',    '63137'=>'[m:170]',
            '63400'=>'[m:171]',    '63118'=>'[m:172]',    '63401'=>'[m:173]',    '63402'=>'[m:174]',    '63403'=>'[m:175]',
            '63061'=>'[m:176]',    '63062'=>'[m:177]',    '63063'=>'[m:178]',    '63064'=>'[m:179]',    '63227'=>'[m:180]',
            '63228'=>'[m:181]',    '63296'=>'[m:182]',    '63297'=>'[m:183]',    '63298'=>'[m:184]',    '63299'=>'[m:185]',
            '63300'=>'[m:186]',    '63301'=>'[m:187]',    '63302'=>'[m:188]',    '63303'=>'[m:189]',    '63041'=>'[m:190]',
            '63069'=>'[m:191]',    '63079'=>'[m:192]',    '63080'=>'[m:193]',    '63081'=>'[m:194]',    '63082'=>'[m:195]',
            '63083'=>'[m:196]',    '63084'=>'[m:197]',    '63085'=>'[m:198]',    '63086'=>'[m:199]',    '63087'=>'[m:200]',
            '63088'=>'[m:201]',    '63089'=>'[m:202]',    '63090'=>'[m:203]',    '63091'=>'[m:204]',    '63099'=>'[m:205]',
            '63100'=>'[m:206]',    '63101'=>'[m:207]',    '63102'=>'[m:208]',    '63104'=>'[m:209]',    '63105'=>'[m:210]',
            '63106'=>'[m:211]',    '63107'=>'[m:212]',    '63374'=>'[m:213]',    '63375'=>'[m:214]',    '63111'=>'[m:215]',
            '63112'=>'[m:216]',    '63113'=>'[m:217]',    '63043'=>'[m:218]',    '63119'=>'[m:219]',    '63120'=>'[m:220]',
            '63121'=>'[m:221]',    '63122'=>'[m:222]',    '63045'=>'[m:223]',    '63125'=>'[m:224]',    '63126'=>'[m:225]',
            '63127'=>'[m:226]',    '63128'=>'[m:227]',    '63129'=>'[m:228]',    '63046'=>'[m:229]',    '63047'=>'[m:230]',
            '63134'=>'[m:231]',    '63135'=>'[m:232]',    '63136'=>'[m:233]',    '63138'=>'[m:234]',    '63139'=>'[m:235]',
            '63140'=>'[m:236]',    '63141'=>'[m:237]',    '63142'=>'[m:238]',    '63145'=>'[m:239]',    '63146'=>'[m:240]',
            '63147'=>'[m:241]',    '63148'=>'[m:242]',    '63149'=>'[m:243]',    '63150'=>'[m:244]',    '63151'=>'[m:245]',
            '63048'=>'[m:246]',    '63152'=>'[m:247]',    '63153'=>'[m:248]',    '63154'=>'[m:249]',    '63155'=>'[m:250]',
            '63156'=>'[m:251]',    '63157'=>'[m:252]',    '63158'=>'[m:253]',    '63159'=>'[m:254]',    '63163'=>'[m:255]',
            '63164'=>'[m:256]',    '63049'=>'[m:257]',    '63050'=>'[m:258]',    '63051'=>'[m:259]',    '63052'=>'[m:260]',
            '63053'=>'[m:261]',    '63166'=>'[m:262]',    '63167'=>'[m:263]',    '63168'=>'[m:264]',    '63055'=>'[m:265]',
            '63056'=>'[m:266]',    '63057'=>'[m:267]',    '63058'=>'[m:268]',    '63059'=>'[m:269]',    '63169'=>'[m:270]',
            '63170'=>'[m:271]',    '63171'=>'[m:272]',    '63172'=>'[m:273]',    '63173'=>'[m:274]',    '63174'=>'[m:275]',
            '63175'=>'[m:276]',    '63176'=>'[m:277]',    '63177'=>'[m:278]',    '63178'=>'[m:279]',    '63179'=>'[m:280]',
            '63180'=>'[m:281]',    '63181'=>'[m:282]',    '63182'=>'[m:283]',    '63183'=>'[m:284]',    '63184'=>'[m:285]',
            '63185'=>'[m:286]',    '63186'=>'[m:287]',    '63195'=>'[m:288]',    '63196'=>'[m:289]',    '63197'=>'[m:290]',
            '63198'=>'[m:291]',    '63199'=>'[m:292]',    '63200'=>'[m:293]',    '63201'=>'[m:294]',    '63202'=>'[m:295]',
            '63203'=>'[m:296]',    '63204'=>'[m:297]',    '63380'=>'[m:298]',    '63381'=>'[m:299]',    '63205'=>'[m:300]',
            '63206'=>'[m:301]',    '63207'=>'[m:302]',    '63208'=>'[m:303]',    '63209'=>'[m:304]',    '63413'=>'[m:305]',
            '63414'=>'[m:306]',    '63415'=>'[m:307]',    '63416'=>'[m:308]',    '63417'=>'[m:309]',    '63418'=>'[m:310]',
            '63419'=>'[m:311]',    '63420'=>'[m:312]',    '63421'=>'[m:313]',    '63422'=>'[m:314]',    '63423'=>'[m:315]',
            '63424'=>'[m:316]',    '63425'=>'[m:317]',    '63426'=>'[m:318]',    '63427'=>'[m:319]',    '63428'=>'[m:320]',
            '63429'=>'[m:321]',    '63430'=>'[m:322]',    '63431'=>'[m:323]',    '63432'=>'[m:324]',    '63433'=>'[m:325]',
            '63434'=>'[m:326]',    '63435'=>'[m:327]',    '63436'=>'[m:328]',    '63437'=>'[m:329]',    '63438'=>'[m:330]',
            '63439'=>'[m:331]',    '63440'=>'[m:332]',    '63441'=>'[m:333]',    '63461'=>'[m:334]',    '63462'=>'[m:335]',
            '63463'=>'[m:336]',    '63464'=>'[m:337]',    '63465'=>'[m:338]',    '63466'=>'[m:339]',    '63467'=>'[m:340]',
            '63468'=>'[m:341]',    '63469'=>'[m:342]',    '63470'=>'[m:343]',    '63471'=>'[m:344]',    '63472'=>'[m:345]',
            '63473'=>'[m:346]',    '63474'=>'[m:347]',    '63475'=>'[m:348]',    '63476'=>'[m:349]',    '63477'=>'[m:350]',
            '63478'=>'[m:351]',    '63479'=>'[m:352]',    '63480'=>'[m:353]',    '63481'=>'[m:354]',    '63482'=>'[m:355]',
            '63483'=>'[m:356]',    '63484'=>'[m:357]',    '62272'=>'[m:358]',    '62273'=>'[m:359]',    '62274'=>'[m:360]',
            '62275'=>'[m:361]',    '62276'=>'[m:362]',    '62277'=>'[m:363]',    '62278'=>'[m:364]',    '62279'=>'[m:365]',
            '62280'=>'[m:366]',    '62281'=>'[m:367]',    '62282'=>'[m:368]',    '62283'=>'[m:369]',    '62284'=>'[m:370]',
            '62285'=>'[m:371]',    '62286'=>'[m:372]',    '62287'=>'[m:373]',    '62288'=>'[m:374]',    '62289'=>'[m:375]',
            '62290'=>'[m:376]',    '62291'=>'[m:377]',    '62292'=>'[m:378]',    '62293'=>'[m:379]',    '62294'=>'[m:380]',
            '62295'=>'[m:381]',    '62296'=>'[m:382]',    '62297'=>'[m:383]',    '62298'=>'[m:384]',    '62299'=>'[m:385]',
            '62300'=>'[m:386]',    '62301'=>'[m:387]',    '62302'=>'[m:388]',    '62303'=>'[m:389]',    '62304'=>'[m:390]',
            '62305'=>'[m:391]',    '62306'=>'[m:392]',    '62307'=>'[m:393]',    '62308'=>'[m:394]',    '62309'=>'[m:395]',
            '62310'=>'[m:396]',    '62311'=>'[m:397]',    '62312'=>'[m:398]',    '62313'=>'[m:399]',    '62314'=>'[m:400]',
            '62315'=>'[m:401]',    '62316'=>'[m:402]',    '62317'=>'[m:403]',    '62318'=>'[m:404]',    '62319'=>'[m:405]',
            '62320'=>'[m:406]',    '62321'=>'[m:407]',    '62322'=>'[m:408]',    '62323'=>'[m:409]',    '62324'=>'[m:410]',
            '62325'=>'[m:411]',    '62326'=>'[m:412]',    '62327'=>'[m:413]',    '62328'=>'[m:414]',    '62329'=>'[m:415]',
            '62330'=>'[m:416]',    '62331'=>'[m:417]',    '62332'=>'[m:418]',    '62333'=>'[m:419]',    '62334'=>'[m:420]',
            '62336'=>'[m:421]',    '62337'=>'[m:422]',    '62338'=>'[m:423]',    '62339'=>'[m:424]',    '62340'=>'[m:425]',
            '62341'=>'[m:426]',    '62342'=>'[m:427]',    '62343'=>'[m:428]',    '62344'=>'[m:429]',    '62345'=>'[m:430]',
            '62346'=>'[m:431]',    '62347'=>'[m:432]',    '62348'=>'[m:433]',    '62349'=>'[m:434]',    '62350'=>'[m:435]',
            '62351'=>'[m:436]',    '62352'=>'[m:437]',    '62353'=>'[m:438]',    '62354'=>'[m:439]',    '62355'=>'[m:440]',
            '62356'=>'[m:441]',    '62357'=>'[m:442]',    '62358'=>'[m:443]',    '62359'=>'[m:444]',    '62360'=>'[m:445]',
            '62361'=>'[m:446]',    '62362'=>'[m:447]',    '62363'=>'[m:448]',    '62364'=>'[m:449]',    '62365'=>'[m:450]',
            '62366'=>'[m:451]',    '62367'=>'[m:452]',    '62368'=>'[m:453]',    '62369'=>'[m:454]',    '62370'=>'[m:455]',
            '62371'=>'[m:456]',    '62372'=>'[m:457]',    '62373'=>'[m:458]',    '62374'=>'[m:459]',    '62375'=>'[m:460]',
            '62376'=>'[m:461]',    '62377'=>'[m:462]',    '62378'=>'[m:463]',    '62379'=>'[m:464]',    '62380'=>'[m:465]',
            '62381'=>'[m:466]',    '62382'=>'[m:467]',    '62383'=>'[m:468]',    '62384'=>'[m:469]',    '62385'=>'[m:470]',
            '62386'=>'[m:471]',    '62387'=>'[m:472]',    '62388'=>'[m:473]',    '62389'=>'[m:474]',    '62390'=>'[m:475]',
            '62391'=>'[m:476]',    '62392'=>'[m:477]',    '62393'=>'[m:478]',    '62394'=>'[m:479]',    '62395'=>'[m:480]',
            '62396'=>'[m:481]',    '62397'=>'[m:482]',    '62398'=>'[m:483]',    '62399'=>'[m:484]',    '62400'=>'[m:485]',
            '62401'=>'[m:486]',    '62402'=>'[m:487]',    '62403'=>'[m:488]',    '62404'=>'[m:489]',    '62405'=>'[m:490]',
            '62406'=>'[m:491]',    '62407'=>'[m:492]',    '62408'=>'[m:493]',    '62409'=>'[m:494]',    '62410'=>'[m:495]',
            '62411'=>'[m:496]',    '62412'=>'[m:497]',    '62413'=>'[m:498]',    '62414'=>'[m:499]',    '63442'=>'[m:500]',
            '63443'=>'[m:501]',    '63444'=>'[m:502]',    '63445'=>'[m:503]',    '63446'=>'[m:504]',    '63447'=>'[m:505]',
            '63448'=>'[m:506]',    '63449'=>'[m:507]',    '63450'=>'[m:508]',    '63451'=>'[m:509]',    '63452'=>'[m:510]',
            '63453'=>'[m:511]',    '63454'=>'[m:512]',    '63455'=>'[m:513]',    '63456'=>'[m:514]',    '63457'=>'[m:515]',
            '63458'=>'[m:516]',    '63459'=>'[m:517]',    '63460'=>'[m:518]',    '62415'=>'[m:700]',    '62416'=>'[m:701]',
            '62417'=>'[m:702]',    '62418'=>'[m:703]',    '62419'=>'[m:704]',    '62420'=>'[m:705]',    '62421'=>'[m:706]',
            '62422'=>'[m:707]',    '62423'=>'[m:708]',    '62424'=>'[m:709]',    '62425'=>'[m:710]',    '62426'=>'[m:711]',
            '62427'=>'[m:712]',    '62428'=>'[m:713]',    '62429'=>'[m:714]',    '62430'=>'[m:715]',    '62431'=>'[m:716]',
            '62432'=>'[m:717]',    '62433'=>'[m:718]',    '62434'=>'[m:719]',    '62435'=>'[m:720]',    '62436'=>'[m:721]',
            '62437'=>'[m:722]',    '62438'=>'[m:723]',    '62439'=>'[m:724]',    '62440'=>'[m:725]',    '62441'=>'[m:726]',
            '62442'=>'[m:727]',    '62443'=>'[m:728]',    '62444'=>'[m:729]',    '62445'=>'[m:730]',    '62446'=>'[m:731]',
            '62447'=>'[m:732]',    '62448'=>'[m:733]',    '62449'=>'[m:734]',    '62450'=>'[m:735]',    '62451'=>'[m:736]',
            '62452'=>'[m:737]',    '62453'=>'[m:738]',    '62454'=>'[m:739]',    '62455'=>'[m:740]',    '62456'=>'[m:741]',
            '62457'=>'[m:742]',    '62458'=>'[m:743]',    '62459'=>'[m:744]',    '62460'=>'[m:745]',    '62528'=>'[m:746]',
            '62529'=>'[m:747]',    '62530'=>'[m:748]',    '62531'=>'[m:749]',    '62532'=>'[m:750]',    '62533'=>'[m:751]',
            '62534'=>'[m:752]',    '62535'=>'[m:753]',    '62536'=>'[m:754]',    '62537'=>'[m:755]',    '62538'=>'[m:756]',
            '62539'=>'[m:757]',    '62540'=>'[m:758]',    '62541'=>'[m:759]',    '62542'=>'[m:760]',    '62543'=>'[m:761]',
            '62544'=>'[m:762]',    '62545'=>'[m:763]',    '62546'=>'[m:764]',    '62547'=>'[m:765]',    '62548'=>'[m:766]',
            '62549'=>'[m:767]',    '62550'=>'[m:768]',    '62551'=>'[m:769]',    '62552'=>'[m:770]',    '62553'=>'[m:771]',
            '62554'=>'[m:772]',    '62555'=>'[m:773]',    '62556'=>'[m:774]',    '62557'=>'[m:775]',    '62558'=>'[m:776]',
            '62559'=>'[m:777]',    '62560'=>'[m:778]',    '62561'=>'[m:779]',    '62562'=>'[m:780]',    '62563'=>'[m:781]',
            '62564'=>'[m:782]',    '62565'=>'[m:783]',    '62566'=>'[m:784]',    '62567'=>'[m:785]',    '62568'=>'[m:786]',
            '62569'=>'[m:787]',    '62570'=>'[m:788]',    '62571'=>'[m:789]',    '62572'=>'[m:790]',    '62573'=>'[m:791]',
            '62574'=>'[m:792]',    '62575'=>'[m:793]',    '62576'=>'[m:794]',    '62577'=>'[m:795]',    '62578'=>'[m:796]',
            '62579'=>'[m:797]',    '62580'=>'[m:798]',    '62581'=>'[m:799]',    '62582'=>'[m:800]',    '62583'=>'[m:801]',
            '62584'=>'[m:802]',    '62585'=>'[m:803]',    '62586'=>'[m:804]',    '62587'=>'[m:805]',    '62588'=>'[m:806]',
            '62589'=>'[m:807]',    '62590'=>'[m:808]',    '62592'=>'[m:809]',    '62593'=>'[m:810]',    '62594'=>'[m:811]',
            '62595'=>'[m:812]',    '62596'=>'[m:813]',    '62597'=>'[m:814]',    '62598'=>'[m:815]',    '62599'=>'[m:816]',
            '62600'=>'[m:817]',    '62601'=>'[m:818]',    '62602'=>'[m:819]',    '62603'=>'[m:820]',    '62604'=>'[m:821]',
            '62605'=>'[m:822]',    
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * EZwebからDoCoMoへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function ezweb2docomo($hex)
    {
        $map = array(
            '63065'=>'&#63964;',        '63066'=>'&#63911;',        '63067'=>'？',              '63304'=>'&#63878;',        '63305'=>'<',
            '63306'=>'>',               '63307'=>'<<',              '63308'=>'>>',              '63309'=>'■',              '63310'=>'■',
            '63311'=>'[i]',             '63130'=>'&#63995;',        '63210'=>'[スピーカ]',      '63382'=>'&#63930;',        '63070'=>'&#63811;',
            '63071'=>'&#63651;',        '63312'=>'■',              '63313'=>'■',              '63314'=>'◆',              '63315'=>'◆',
            '63316'=>'■',              '63317'=>'■',              '63318'=>'&#63808;',        '63319'=>'&#63808;',        '63383'=>'&#63940;',
            '63320'=>'＋',              '63321'=>'－',              '63322'=>'＊',              '63323'=>'↑',              '63324'=>'↓',
            '63325'=>'&#63965;',        '63326'=>'▼',              '63327'=>'▲',              '63328'=>'▼',              '63329'=>'▲',
            '63330'=>'◆',              '63331'=>'◆',              '63332'=>'■',              '63333'=>'■',              '63334'=>'&#63808;',
            '63335'=>'&#63808;',        '63336'=>'&#63736;',        '63337'=>'&#63735;',        '63072'=>'&#63647;',        '63123'=>'&#63668;',
            '63409'=>'&#63838;',        '63073'=>'&#63810;',        '63211'=>'&#63928;',        '63356'=>'φ',              '63187'=>'&#63893;',
            '63410'=>'&#63889;',        '63131'=>'&#63698;',        '63212'=>'&#63974;',        '63338'=>'&#63959;',        '63339'=>'×',
            '63357'=>'&#63722;',        '63384'=>'&#63937;',        '63060'=>'&#63937;',        '63358'=>'[フロッピー]',    '63074'=>'[雪結晶]',
            '63340'=>'×',              '63341'=>'×',              '63342'=>'→',              '63343'=>'←',              '63132'=>'&#63699;',
            '63344'=>'÷',              '63360'=>'[カレンダー]',    '63188'=>'&#63893;',        '63075'=>'☆',              '63345'=>'&#63705;',
            '63346'=>'&#63817;',        '63213'=>'&#63936;',        '63347'=>'[チェックマーク]','63160'=>'&#63813;',        '63040'=>'☆彡',
            '63044'=>'&#63903;',        '63054'=>'&#63904;',        '63161'=>'&#63988;',        '63404'=>'[フォルダ]',      '63189'=>'&#63893;',
            '63348'=>'&#63958;',        '63349'=>'&#63963;',        '63092'=>'&#63715;',        '63405'=>'[フォルダ]',      '63411'=>'&#63720;',
            '63190'=>'[フキダシ]',      '63385'=>'[カード]',        '63350'=>'▲',              '63351'=>'▼',              '63376'=>'[USA]',
            '63093'=>'&#63716;',        '63361'=>'&#63722;',        '63412'=>'&#63697;',        '63214'=>'&#63714;',        '63076'=>'&#63649;',
            '63124'=>'[フットボール]',  '63362'=>'&#63716;',        '63068'=>'&#63956;',        '63042'=>'&#63694;',        '63363'=>'&#63716;',
            '63364'=>'&#63716;',        '63365'=>'&#63716;',        '63366'=>'&#63722;',        '63215'=>'&#63702;',        '63367'=>'[カレンダー]',
            '63094'=>'&#63711;',        '63077'=>'&#63648;',        '63226'=>'&#63863;',        '63386'=>'&#63866;',        '63216'=>'&#63704;',
            '63387'=>'&#63704;',        '63108'=>'&#63684;',        '63165'=>'&#63976;',        '63388'=>'[包丁]',          '63389'=>'[ビデオ]',
            '63191'=>'&#63739;',        '63352'=>'└→',            '63353'=>'&#63870;',        '63217'=>'&#63873;',        '63218'=>'&#63869;',
            '63368'=>'&#63716;',        '63095'=>'&#63716;',        '63390'=>'[ネジ]',          '63219'=>'&#63701;',        '63114'=>'&#63679;',
            '63391'=>'[フロッピー]',    '63377'=>'[グラフ]',        '63378'=>'[グラフ]',        '63220'=>'&#63686;',        '63392'=>'&#63904;',
            '63369'=>'&#63716;',        '63354'=>'[チェックマーク]','63143'=>'&#63980;',        '63162'=>'&#63813;',        '63393'=>'[電池]',
            '63355'=>'&#63919;',        '63370'=>'[画びょう]',      '63221'=>'&#63869;',        '63394'=>'&#63930;',        '63192'=>'←',
            '63193'=>'→',              '63371'=>'&#63716;',        '63096'=>'&#63957;',        '63144'=>'&#63718;',        '63222'=>'[名札]',
            '63109'=>'&#63696;',        '63372'=>'&#63716;',        '63115'=>'[トラック]',      '63097'=>'&#63934;',        '63395'=>'[PDC]',
            '63406'=>'&#63859;',        '63396'=>'&#63933;',        '63407'=>'[送信BOX]',       '63408'=>'[受信BOX]',       '63223'=>'&#63720;',
            '63110'=>'&#63685;',        '63373'=>'[定規]',          '63098'=>'[三角定規]',      '63379'=>'[グラフ]',        '63133'=>'[肉]',
            '63397'=>'&#63721;',        '63398'=>'[コンセント]',    '63194'=>'[家族]',          '63399'=>'[リンク]',        '63224'=>'&#63718;',
            '63225'=>'&#63860;',        '63078'=>'&#63647;',        '63116'=>'&#63683;',        '63117'=>'&#63815;',        '63137'=>'[サイコロ]',
            '63400'=>'[新聞]',          '63118'=>'&#63676;',        '63401'=>'　',              '63402'=>'',                '63403'=>'',
            '63061'=>'&#63712;',        '63062'=>'&#63713;',        '63063'=>'&#63740;',        '63064'=>'[若葉マーク]',    '63227'=>'&#63879;',
            '63228'=>'&#63880;',        '63296'=>'&#63881;',        '63297'=>'&#63882;',        '63298'=>'&#63883;',        '63299'=>'&#63884;',
            '63300'=>'&#63885;',        '63301'=>'&#63886;',        '63302'=>'&#63887;',        '63303'=>'[10]',            '63041'=>'&#63652;',
            '63069'=>'&#63650;',        '63079'=>'&#63655;',        '63080'=>'&#63656;',        '63081'=>'&#63657;',        '63082'=>'&#63658;',
            '63083'=>'&#63659;',        '63084'=>'&#63660;',        '63085'=>'&#63661;',        '63086'=>'&#63662;',        '63087'=>'&#63663;',
            '63088'=>'&#63664;',        '63089'=>'&#63665;',        '63090'=>'&#63666;',        '63091'=>'[蛇使座]',        '63099'=>'&#63689;',
            '63100'=>'&#63691;',        '63101'=>'&#63695;',        '63102'=>'&#63693;',        '63104'=>'[バス停]',        '63105'=>'[アンテナ]',
            '63106'=>'&#63682;',        '63107'=>'&#63688;',        '63374'=>'&#63692;',        '63375'=>'[地図]',          '63111'=>'&#63938;',
            '63112'=>'&#63681;',        '63113'=>'&#63678;',        '63043'=>'&#63960;',        '63119'=>'&#63671;',        '63120'=>'&#63670;',
            '63121'=>'&#63927;',        '63122'=>'&#63674;',        '63045'=>'[観覧車]',        '63125'=>'&#63900;',        '63126'=>'&#63984;',
            '63127'=>'&#63824;',        '63128'=>'&#63831;',        '63129'=>'[東京タワー]',    '63046'=>'[777]',           '63047'=>'[オメデトウ]',
            '63134'=>'[的中]',          '63135'=>'&#63724;',        '63136'=>'&#63930;',        '63138'=>'&#63816;',        '63139'=>'&#63981;',
            '63140'=>'[お化け]',        '63141'=>'[日の丸]',        '63142'=>'[スイカ]',        '63145'=>'&#63983;',        '63146'=>'[フライパン]',
            '63147'=>'&#63975;',        '63148'=>'&#63990;',        '63149'=>'[イチゴ]',        '63150'=>'&#63982;',        '63151'=>'&#63700;',
            '63048'=>'[クジラ]',        '63152'=>'[ウサギ]',        '63153'=>'&#63993;',        '63154'=>'[サル]',          '63155'=>'[カエル]',
            '63156'=>'&#63814;',        '63157'=>'&#63989;',        '63158'=>'[アリ]',          '63159'=>'&#63994;',        '63163'=>'[ビーチ]',
            '63164'=>'[ひまわり]',      '63049'=>'&#63893;',        '63050'=>'&#63894;',        '63051'=>'&#63954;',        '63052'=>'&#63952;',
            '63053'=>'&#63910;',        '63166'=>'&#63905;',        '63167'=>'&#63916;',        '63168'=>'&#63949;',        '63055'=>'&#63891;',
            '63056'=>'&#63892;',        '63057'=>'&#63903;',        '63058'=>'&#63907;',        '63059'=>'[炎]',            '63169'=>'[SOS]',
            '63170'=>'[力こぶ]',        '63171'=>'&#63889;',        '63172'=>'&#63902;',        '63173'=>'[宇宙人]',        '63174'=>'&#63652;',
            '63175'=>'&#63737;',        '63176'=>'[アクマ]',        '63177'=>'[花丸]',          '63178'=>'&#63961;',        '63179'=>'[100点]',
            '63180'=>'&#63906;',        '63181'=>'&#63917;',        '63182'=>'[ウンチ]',        '63183'=>'[人差し指]',      '63184'=>'[得]',
            '63185'=>'[ドクロ]',        '63186'=>'&#63948;',        '63195'=>'&#63723;',        '63196'=>'&#63703;',        '63197'=>'&#63924;',
            '63198'=>'&#63908;',        '63199'=>'[ギター]',        '63200'=>'[バイオリン]',    '63201'=>'&#63707;',        '63202'=>'&#63925;',
            '63203'=>'[ピストル]',      '63204'=>'[エステ]',        '63380'=>'[EZ]',            '63381'=>'&#63867;',        '63205'=>'&#63725;',
            '63206'=>'&#63923;',        '63207'=>'[UFO]',           '63208'=>'[UP!]',           '63209'=>'[注射]',          '63413'=>'&#63653;',
            '63414'=>'&#63669;',        '63415'=>'&#63673;',        '63416'=>'&#63675;',        '63417'=>'&#63708;',        '63418'=>'[演劇]',
            '63419'=>'&#63710;',        '63420'=>'&#63717;',        '63421'=>'&#63719;',        '63422'=>'&#63727;',        '63423'=>'&#63728;',
            '63424'=>'&#63729;',        '63425'=>'&#63730;',        '63426'=>'&#63731;',        '63427'=>'&#63733;',        '63428'=>'&#63734;',
            '63429'=>'&#63808;',        '63430'=>'&#63809;',        '63431'=>'&#63810;',        '63432'=>'&#63872;',        '63433'=>'&#63888;',
            '63434'=>'&#63920;',        '63435'=>'&#63897;',        '63436'=>'&#63890;',        '63437'=>'&#63914;',        '63438'=>'&#63915;',
            '63439'=>'[ezplus]',        '63440'=>'[地球]',          '63441'=>'&#63985;',        '63461'=>'&#63874;',        '63462'=>'&#63923;',
            '63463'=>'&#63738;',        '63464'=>'&#63931;',        '63465'=>'[ラジオ]',        '63466'=>'[バラ]',          '63467'=>'[教会]',
            '63468'=>'&#63677;',        '63469'=>'&#63973;',        '63470'=>'&#63899;',        '63471'=>'[天使]',          '63472'=>'[トラ]',
            '63473'=>'[クマ]',          '63474'=>'[ネズミ]',        '63475'=>'&#63950;',        '63476'=>'&#63947;',        '63477'=>'&#63996;',
            '63478'=>'&#63944;',        '63479'=>'[タコ]',          '63480'=>'[ロケット]',      '63481'=>'&#63935;',        '63482'=>'&#63902;',
            '63483'=>'[ハンマー]',      '63484'=>'[花火]',          '62272'=>'&#63980;',        '62273'=>'&#63715;',        '62274'=>'[噴水]',
            '62275'=>'[キャンプ]',      '62276'=>'[麻雀]',          '62277'=>'[VS]',            '62278'=>'[トロフィー]',    '62279'=>'[カメ]',
            '62280'=>'[スペイン]',      '62281'=>'[ロシア]',        '62282'=>'[工事中]',        '62283'=>'&#63900;',        '62284'=>'[祝日]',
            '62285'=>'[夕焼け]',        '62286'=>'&#63988;',        '62287'=>'[株価]',          '62288'=>'[警官]',          '62289'=>'&#63686;',
            '62290'=>'&#63687;',        '62291'=>'&#63971;',        '62292'=>'&#63690;',        '62293'=>'&#63682;',        '62294'=>'[18禁]',
            '62295'=>'[バリ3]',         '62296'=>'[COOL]',          '62297'=>'[割]',            '62298'=>'[サービス]',      '62299'=>'&#63868;',
            '62300'=>'&#63968;',        '62301'=>'&#63966;',        '62302'=>'[指]',            '62303'=>'[営]',            '62304'=>'↑',
            '62305'=>'↓',              '62306'=>'[占い]',          '62307'=>'[マナーモード]',  '62308'=>'[ケータイOFF]',   '62309'=>'&#63722;',
            '62310'=>'[ネクタイ]',      '62311'=>'[ハイビスカス]',  '62312'=>'[花束]',          '62313'=>'[サボテン]',      '62314'=>'&#63984;',
            '62315'=>'&#63699;',        '62316'=>'[祝]',            '62317'=>'[薬]',            '62318'=>'[風船]',          '62319'=>'[クラッカー]',
            '62320'=>'[EZナビ]',        '62321'=>'[帽子]',          '62322'=>'[ブーツ]',        '62323'=>'[マニキュア]',    '62324'=>'[美容院]',
            '62325'=>'[床屋]',          '62326'=>'[着物]',          '62327'=>'[ビキニ]',        '62328'=>'&#63726;',        '62329'=>'&#63889;',
            '62330'=>'&#63889;',        '62331'=>'&#63889;',        '62332'=>'&#63889;',        '62333'=>'&#63889;',        '62334'=>'&#63903;',
            '62336'=>'&#63672;',        '62337'=>'&#63812;',        '62338'=>'&#63939;',        '62339'=>'&#63986;',        '62340'=>'[ソフトクリーム]',
            '62341'=>'[ポテト]',        '62342'=>'[だんご]',        '62343'=>'[せんべい]',      '62344'=>'&#63985;',        '62345'=>'[パスタ]',
            '62346'=>'[カレー]',        '62347'=>'[おでん]',        '62348'=>'[すし]',          '62349'=>'&#63978;',        '62350'=>'[みかん]',
            '62351'=>'[トマト]',        '62352'=>'[ナス]',          '62353'=>'[弁当]',          '62354'=>'[鍋]',            '62355'=>'&#63953;',
            '62356'=>'&#63941;',        '62357'=>'&#63992;',        '62358'=>'&#63952;',        '62359'=>'&#63896;',        '62360'=>'&#63910;',
            '62361'=>'&#63942;',        '62362'=>'&#63996;',        '62363'=>'[風邪ひき]',      '62364'=>'[熱]',            '62365'=>'&#63946;',
            '62366'=>'&#63897;',        '62367'=>'&#63944;',        '62368'=>'&#63908;',        '62369'=>'&#63893;',        '62370'=>'(>３<)',
            '62371'=>'(´３｀)',        '62372'=>'[鼻]',            '62373'=>'&#63902;',        '62374'=>'(>人<)',          '62375'=>'[拍手]',
            '62376'=>'&#63920;',        '62377'=>'&#63909;',        '62378'=>'&#63734;',        '62379'=>'&#63956;',        '62380'=>'&#63920;',
            '62381'=>'m(_ _)m',         '62382'=>'&#63890;',        '62383'=>'[バニー]',        '62384'=>'[トランペット]',  '62385'=>'[ビリヤード]',
            '62386'=>'[水泳]',          '62387'=>'[消防車]',        '62388'=>'[救急車]',        '62389'=>'[パトカー]',      '62390'=>'[ジェットコースター]',
            '62391'=>'[門松]',          '62392'=>'[ひな祭り]',      '62393'=>'[卒業式]',        '62394'=>'[ランドセル]',    '62395'=>'[こいのぼり]',
            '62396'=>'&#63654;',        '62397'=>'[花嫁]',          '62398'=>'[カキ氷]',        '62399'=>'[線香花火]',      '62400'=>'[巻貝]',
            '62401'=>'[風鈴]',          '62402'=>'[ハロウィン]',    '62403'=>'[お月見]',        '62404'=>'[サンタ]',        '62405'=>'&#63831;',
            '62406'=>'[虹]',            '62407'=>'&#63690;',        '62408'=>'&#63647;',        '62409'=>'&#63709;',        '62410'=>'[デパート]',
            '62411'=>'[城]',            '62412'=>'[城]',            '62413'=>'[工場]',          '62414'=>'[フランス]',      '63442'=>'[オープンウェブ]',
            '63443'=>'[カギ]',          '63444'=>'[ABCD]',          '63445'=>'[abcd]',          '63446'=>'[1234]',          '63447'=>'[記号]',
            '63448'=>'[可]',            '63449'=>'[チェックマーク]','63450'=>'&#63826;',        '63451'=>'[ラジオボタン]',  '63452'=>'&#63873;',
            '63453'=>'[←BACK]',        '63454'=>'[ブックマーク]',  '63455'=>'&#63858;',        '63456'=>'&#63684;',        '63457'=>'&#63686;',
            '63458'=>'&#63722;',        '63459'=>'&#63869;',        '63460'=>'&#63962;',        '62415'=>'[ドイツ]',        '62416'=>'[イタリア]',
            '62417'=>'[イギリス]',      '62418'=>'[中国]',          '62419'=>'[韓国]',          '62420'=>'[白人]',          '62421'=>'[中国人]',
            '62422'=>'[インド人]',      '62423'=>'[おじいさん]',    '62424'=>'[おばあさん]',    '62425'=>'[赤ちゃん]',      '62426'=>'[工事現場の人]',
            '62427'=>'[お姫様]',        '62428'=>'[イルカ]',        '62429'=>'[ダンス]',        '62430'=>'&#63990;',        '62431'=>'[ゲジゲジ]',
            '62432'=>'[ゾウ]',          '62433'=>'[コアラ]',        '62434'=>'[牛]',            '62435'=>'[ヘビ]',          '62436'=>'[ニワトリ]',
            '62437'=>'[イノシシ]',      '62438'=>'[ラクダ]',        '62439'=>'[A]',             '62440'=>'[B]',             '62441'=>'[O]',
            '62442'=>'[AB]',            '62443'=>'&#63737;',        '62444'=>'&#63738;',        '62445'=>'&#63875;',        '62446'=>'&#63898;',
            '62447'=>'&#63909;',        '62448'=>'&#63912;',        '62449'=>'&#63913;',        '62450'=>'&#63919;',        '62451'=>'[メロン]',
            '62452'=>'[パイナップル]',  '62453'=>'[ブドウ]',        '62454'=>'&#63977;',        '62455'=>'[とうもろこし]',  '62456'=>'[キノコ]',
            '62457'=>'[栗]',            '62458'=>'[モモ]',          '62459'=>'[やきいも]',      '62460'=>'[ピザ]',          '62528'=>'[チキン]',
            '62529'=>'[七夕]',          '62530'=>'&#63698;',        '62531'=>'[辰]',            '62532'=>'[ピアノ]',        '62533'=>'&#63927;',
            '62534'=>'&#63990;',        '62535'=>'[ボーリング]',    '62536'=>'[なまはげ]',      '62537'=>'[天狗]',          '62538'=>'[パンダ]',
            '62539'=>'&#63949;',        '62540'=>'&#63994;',        '62541'=>'[花]',            '62542'=>'[アイスクリーム]','62543'=>'[ドーナツ]',
            '62544'=>'[クッキー]',      '62545'=>'[チョコ]',        '62546'=>'[キャンディ]',    '62547'=>'[キャンディ]',    '62548'=>'(/_＼)',
            '62549'=>'(・×・)',        '62550'=>'|(・×・)|',      '62551'=>'[火山]',          '62552'=>'&#63889;',        '62553'=>'[ABC]',
            '62554'=>'[プリン]',        '62555'=>'[ミツバチ]',      '62556'=>'[てんとう虫]',    '62557'=>'[ハチミツ]',      '62558'=>'&#63978;',
            '62559'=>'[飛んでいくお金]','62560'=>'[クラクラ]',      '62561'=>'&#63945;',        '62562'=>'&#63945;',        '62563'=>'&#63831;',
            '62564'=>'(´３｀)',        '62565'=>'&#63893;',        '62566'=>'&#63859;',        '62567'=>'&#63951;',        '62568'=>'&#63951;',
            '62569'=>'&#63947;',        '62570'=>'&#63896;',        '62571'=>'&#63896;',        '62572'=>'&#63955;',        '62573'=>'&#63955;',
            '62574'=>'&#63992;',        '62575'=>'[ドレス]',        '62576'=>'[モアイ]',        '62577'=>'[駅]',            '62578'=>'[花札]',
            '62579'=>'[ジョーカー]',    '62580'=>'[エビフライ]',    '62581'=>'&#63863;',        '62582'=>'&#63960;',        '62583'=>'[パトカー]',
            '62584'=>'[EZムービー]',    '62585'=>'&#63890;',        '62586'=>'&#63988;',        '62587'=>'&#63926;',        '62588'=>'&#63932;',
            '62589'=>'&#63962;',        '62590'=>'&#63969;',        '62592'=>'&#63970;',        '62593'=>'&#63972;',        '62594'=>'&#63979;',
            '62595'=>'&#63987;',        '62596'=>'&#63992;',        '62597'=>'&#63992;',        '62598'=>'[Cメール]',       '62599'=>'&#63974;',
            '62600'=>'&#63732;',        '62601'=>'&#63877;',        '62602'=>'(^-^)/',          '62603'=>'＼(^o^)／',       '62604'=>'&#63896;',
            '62605'=>'&#63945;',
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * EZwebからEZweb(内部画像)へ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function ezweb2ezweb($hex)
    {
        $map = array(
            '63065'=>'F659',    '63066'=>'F65A',    '63067'=>'F65B',    '63304'=>'F748',    '63305'=>'F749',
            '63306'=>'F74A',    '63307'=>'F74B',    '63308'=>'F74C',    '63309'=>'F74D',    '63310'=>'F74E',
            '63311'=>'F74F',    '63130'=>'F69A',    '63210'=>'F6EA',    '63382'=>'F796',    '63070'=>'F65E',
            '63071'=>'F65F',    '63312'=>'F750',    '63313'=>'F751',    '63314'=>'F752',    '63315'=>'F753',
            '63316'=>'F754',    '63317'=>'F755',    '63318'=>'F756',    '63319'=>'F757',    '63383'=>'F797',
            '63320'=>'F758',    '63321'=>'F759',    '63322'=>'F75A',    '63323'=>'F75B',    '63324'=>'F75C',
            '63325'=>'F75D',    '63326'=>'F75E',    '63327'=>'F75F',    '63328'=>'F760',    '63329'=>'F761',
            '63330'=>'F762',    '63331'=>'F763',    '63332'=>'F764',    '63333'=>'F765',    '63334'=>'F766',
            '63335'=>'F767',    '63336'=>'F768',    '63337'=>'F769',    '63072'=>'F660',    '63123'=>'F693',
            '63409'=>'F7B1',    '63073'=>'F661',    '63211'=>'F6EB',    '63356'=>'F77C',    '63187'=>'F6D3',
            '63410'=>'F7B2',    '63131'=>'F69B',    '63212'=>'F6EC',    '63338'=>'F76A',    '63339'=>'F76B',
            '63357'=>'F77D',    '63384'=>'F798',    '63060'=>'F654',    '63358'=>'F77E',    '63074'=>'F662',
            '63340'=>'F76C',    '63341'=>'F76D',    '63342'=>'F76E',    '63343'=>'F76F',    '63132'=>'F69C',
            '63344'=>'F770',    '63360'=>'F780',    '63188'=>'F6D4',    '63075'=>'F663',    '63345'=>'F771',
            '63346'=>'F772',    '63213'=>'F6ED',    '63347'=>'F773',    '63160'=>'F6B8',    '63040'=>'F640',
            '63044'=>'F644',    '63054'=>'F64E',    '63161'=>'F6B9',    '63404'=>'F7AC',    '63189'=>'F6D5',
            '63348'=>'F774',    '63349'=>'F775',    '63092'=>'F674',    '63405'=>'F7AD',    '63411'=>'F7B3',
            '63190'=>'F6D6',    '63385'=>'F799',    '63350'=>'F776',    '63351'=>'F777',    '63376'=>'F790',
            '63093'=>'F675',    '63361'=>'F781',    '63412'=>'F7B4',    '63214'=>'F6EE',    '63076'=>'F664',
            '63124'=>'F694',    '63362'=>'F782',    '63068'=>'F65C',    '63042'=>'F642',    '63363'=>'F783',
            '63364'=>'F784',    '63365'=>'F785',    '63366'=>'F786',    '63215'=>'F6EF',    '63367'=>'F787',
            '63094'=>'F676',    '63077'=>'F665',    '63226'=>'F6FA',    '63386'=>'F79A',    '63216'=>'F6F0',
            '63387'=>'F79B',    '63108'=>'F684',    '63165'=>'F6BD',    '63388'=>'F79C',    '63389'=>'F79D',
            '63191'=>'F6D7',    '63352'=>'F778',    '63353'=>'F779',    '63217'=>'F6F1',    '63218'=>'F6F2',
            '63368'=>'F788',    '63095'=>'F677',    '63390'=>'F79E',    '63219'=>'F6F3',    '63114'=>'F68A',
            '63391'=>'F79F',    '63377'=>'F791',    '63378'=>'F792',    '63220'=>'F6F4',    '63392'=>'F7A0',
            '63369'=>'F789',    '63354'=>'F77A',    '63143'=>'F6A7',    '63162'=>'F6BA',    '63393'=>'F7A1',
            '63355'=>'F77B',    '63370'=>'F78A',    '63221'=>'F6F5',    '63394'=>'F7A2',    '63192'=>'F6D8',
            '63193'=>'F6D9',    '63371'=>'F78B',    '63096'=>'F678',    '63144'=>'F6A8',    '63222'=>'F6F6',
            '63109'=>'F685',    '63372'=>'F78C',    '63115'=>'F68B',    '63097'=>'F679',    '63395'=>'F7A3',
            '63406'=>'F7AE',    '63396'=>'F7A4',    '63407'=>'F7AF',    '63408'=>'F7B0',    '63223'=>'F6F7',
            '63110'=>'F686',    '63373'=>'F78D',    '63098'=>'F67A',    '63379'=>'F793',    '63133'=>'F69D',
            '63397'=>'F7A5',    '63398'=>'F7A6',    '63194'=>'F6DA',    '63399'=>'F7A7',    '63224'=>'F6F8',
            '63225'=>'F6F9',    '63078'=>'F666',    '63116'=>'F68C',    '63117'=>'F68D',    '63137'=>'F6A1',
            '63400'=>'F7A8',    '63118'=>'F68E',    '63401'=>'F7A9',    '63402'=>'F7AA',    '63403'=>'F7AB',
            '63061'=>'F655',    '63062'=>'F656',    '63063'=>'F657',    '63064'=>'F658',    '63227'=>'F6FB',
            '63228'=>'F6FC',    '63296'=>'F740',    '63297'=>'F741',    '63298'=>'F742',    '63299'=>'F743',
            '63300'=>'F744',    '63301'=>'F745',    '63302'=>'F746',    '63303'=>'F747',    '63041'=>'F641',
            '63069'=>'F65D',    '63079'=>'F667',    '63080'=>'F668',    '63081'=>'F669',    '63082'=>'F66A',
            '63083'=>'F66B',    '63084'=>'F66C',    '63085'=>'F66D',    '63086'=>'F66E',    '63087'=>'F66F',
            '63088'=>'F670',    '63089'=>'F671',    '63090'=>'F672',    '63091'=>'F673',    '63099'=>'F67B',
            '63100'=>'F67C',    '63101'=>'F67D',    '63102'=>'F67E',    '63104'=>'F680',    '63105'=>'F681',
            '63106'=>'F682',    '63107'=>'F683',    '63374'=>'F78E',    '63375'=>'F78F',    '63111'=>'F687',
            '63112'=>'F688',    '63113'=>'F689',    '63043'=>'F643',    '63119'=>'F68F',    '63120'=>'F690',
            '63121'=>'F691',    '63122'=>'F692',    '63045'=>'F645',    '63125'=>'F695',    '63126'=>'F696',
            '63127'=>'F697',    '63128'=>'F698',    '63129'=>'F699',    '63046'=>'F646',    '63047'=>'F647',
            '63134'=>'F69E',    '63135'=>'F69F',    '63136'=>'F6A0',    '63138'=>'F6A2',    '63139'=>'F6A3',
            '63140'=>'F6A4',    '63141'=>'F6A5',    '63142'=>'F6A6',    '63145'=>'F6A9',    '63146'=>'F6AA',
            '63147'=>'F6AB',    '63148'=>'F6AC',    '63149'=>'F6AD',    '63150'=>'F6AE',    '63151'=>'F6AF',
            '63048'=>'F648',    '63152'=>'F6B0',    '63153'=>'F6B1',    '63154'=>'F6B2',    '63155'=>'F6B3',
            '63156'=>'F6B4',    '63157'=>'F6B5',    '63158'=>'F6B6',    '63159'=>'F6B7',    '63163'=>'F6BB',
            '63164'=>'F6BC',    '63049'=>'F649',    '63050'=>'F64A',    '63051'=>'F64B',    '63052'=>'F64C',
            '63053'=>'F64D',    '63166'=>'F6BE',    '63167'=>'F6BF',    '63168'=>'F6C0',    '63055'=>'F64F',
            '63056'=>'F650',    '63057'=>'F651',    '63058'=>'F652',    '63059'=>'F653',    '63169'=>'F6C1',
            '63170'=>'F6C2',    '63171'=>'F6C3',    '63172'=>'F6C4',    '63173'=>'F6C5',    '63174'=>'F6C6',
            '63175'=>'F6C7',    '63176'=>'F6C8',    '63177'=>'F6C9',    '63178'=>'F6CA',    '63179'=>'F6CB',
            '63180'=>'F6CC',    '63181'=>'F6CD',    '63182'=>'F6CE',    '63183'=>'F6CF',    '63184'=>'F6D0',
            '63185'=>'F6D1',    '63186'=>'F6D2',    '63195'=>'F6DB',    '63196'=>'F6DC',    '63197'=>'F6DD',
            '63198'=>'F6DE',    '63199'=>'F6DF',    '63200'=>'F6E0',    '63201'=>'F6E1',    '63202'=>'F6E2',
            '63203'=>'F6E3',    '63204'=>'F6E4',    '63380'=>'F794',    '63381'=>'F795',    '63205'=>'F6E5',
            '63206'=>'F6E6',    '63207'=>'F6E7',    '63208'=>'F6E8',    '63209'=>'F6E9',    '63413'=>'F7B5',
            '63414'=>'F7B6',    '63415'=>'F7B7',    '63416'=>'F7B8',    '63417'=>'F7B9',    '63418'=>'F7BA',
            '63419'=>'F7BB',    '63420'=>'F7BC',    '63421'=>'F7BD',    '63422'=>'F7BE',    '63423'=>'F7BF',
            '63424'=>'F7C0',    '63425'=>'F7C1',    '63426'=>'F7C2',    '63427'=>'F7C3',    '63428'=>'F7C4',
            '63429'=>'F7C5',    '63430'=>'F7C6',    '63431'=>'F7C7',    '63432'=>'F7C8',    '63433'=>'F7C9',
            '63434'=>'F7CA',    '63435'=>'F7CB',    '63436'=>'F7CC',    '63437'=>'F7CD',    '63438'=>'F7CE',
            '63439'=>'F7CF',    '63440'=>'F7D0',    '63441'=>'F7D1',    '63461'=>'F7E5',    '63462'=>'F7E6',
            '63463'=>'F7E7',    '63464'=>'F7E8',    '63465'=>'F7E9',    '63466'=>'F7EA',    '63467'=>'F7EB',
            '63468'=>'F7EC',    '63469'=>'F7ED',    '63470'=>'F7EE',    '63471'=>'F7EF',    '63472'=>'F7F0',
            '63473'=>'F7F1',    '63474'=>'F7F2',    '63475'=>'F7F3',    '63476'=>'F7F4',    '63477'=>'F7F5',
            '63478'=>'F7F6',    '63479'=>'F7F7',    '63480'=>'F7F8',    '63481'=>'F7F9',    '63482'=>'F7FA',
            '63483'=>'F7FB',    '63484'=>'F7FC',    '62272'=>'F340',    '62273'=>'F341',    '62274'=>'F342',
            '62275'=>'F343',    '62276'=>'F344',    '62277'=>'F345',    '62278'=>'F346',    '62279'=>'F347',
            '62280'=>'F348',    '62281'=>'F349',    '62282'=>'F34A',    '62283'=>'F34B',    '62284'=>'F34C',
            '62285'=>'F34D',    '62286'=>'F34E',    '62287'=>'F34F',    '62288'=>'F350',    '62289'=>'F351',
            '62290'=>'F352',    '62291'=>'F353',    '62292'=>'F354',    '62293'=>'F355',    '62294'=>'F356',
            '62295'=>'F357',    '62296'=>'F358',    '62297'=>'F359',    '62298'=>'F35A',    '62299'=>'F35B',
            '62300'=>'F35C',    '62301'=>'F35D',    '62302'=>'F35E',    '62303'=>'F35F',    '62304'=>'F360',
            '62305'=>'F361',    '62306'=>'F362',    '62307'=>'F363',    '62308'=>'F364',    '62309'=>'F365',
            '62310'=>'F366',    '62311'=>'F367',    '62312'=>'F368',    '62313'=>'F369',    '62314'=>'F36A',
            '62315'=>'F36B',    '62316'=>'F36C',    '62317'=>'F36D',    '62318'=>'F36E',    '62319'=>'F36F',
            '62320'=>'F370',    '62321'=>'F371',    '62322'=>'F372',    '62323'=>'F373',    '62324'=>'F374',
            '62325'=>'F375',    '62326'=>'F376',    '62327'=>'F377',    '62328'=>'F378',    '62329'=>'F379',
            '62330'=>'F37A',    '62331'=>'F37B',    '62332'=>'F37C',    '62333'=>'F37D',    '62334'=>'F37E',
            '62336'=>'F380',    '62337'=>'F381',    '62338'=>'F382',    '62339'=>'F383',    '62340'=>'F384',
            '62341'=>'F385',    '62342'=>'F386',    '62343'=>'F387',    '62344'=>'F388',    '62345'=>'F389',
            '62346'=>'F38A',    '62347'=>'F38B',    '62348'=>'F38C',    '62349'=>'F38D',    '62350'=>'F38E',
            '62351'=>'F38F',    '62352'=>'F390',    '62353'=>'F391',    '62354'=>'F392',    '62355'=>'F393',
            '62356'=>'F394',    '62357'=>'F395',    '62358'=>'F396',    '62359'=>'F397',    '62360'=>'F398',
            '62361'=>'F399',    '62362'=>'F39A',    '62363'=>'F39B',    '62364'=>'F39C',    '62365'=>'F39D',
            '62366'=>'F39E',    '62367'=>'F39F',    '62368'=>'F3A0',    '62369'=>'F3A1',    '62370'=>'F3A2',
            '62371'=>'F3A3',    '62372'=>'F3A4',    '62373'=>'F3A5',    '62374'=>'F3A6',    '62375'=>'F3A7',
            '62376'=>'F3A8',    '62377'=>'F3A9',    '62378'=>'F3AA',    '62379'=>'F3AB',    '62380'=>'F3AC',
            '62381'=>'F3AD',    '62382'=>'F3AE',    '62383'=>'F3AF',    '62384'=>'F3B0',    '62385'=>'F3B1',
            '62386'=>'F3B2',    '62387'=>'F3B3',    '62388'=>'F3B4',    '62389'=>'F3B5',    '62390'=>'F3B6',
            '62391'=>'F3B7',    '62392'=>'F3B8',    '62393'=>'F3B9',    '62394'=>'F3BA',    '62395'=>'F3BB',
            '62396'=>'F3BC',    '62397'=>'F3BD',    '62398'=>'F3BE',    '62399'=>'F3BF',    '62400'=>'F3C0',
            '62401'=>'F3C1',    '62402'=>'F3C2',    '62403'=>'F3C3',    '62404'=>'F3C4',    '62405'=>'F3C5',
            '62406'=>'F3C6',    '62407'=>'F3C7',    '62408'=>'F3C8',    '62409'=>'F3C9',    '62410'=>'F3CA',
            '62411'=>'F3CB',    '62412'=>'F3CC',    '62413'=>'F3CD',    '62414'=>'F3CE',    '63442'=>'F7D2',
            '63443'=>'F7D3',    '63444'=>'F7D4',    '63445'=>'F7D5',    '63446'=>'F7D6',    '63447'=>'F7D7',
            '63448'=>'F7D8',    '63449'=>'F7D9',    '63450'=>'F7DA',    '63451'=>'F7DB',    '63452'=>'F7DC',
            '63453'=>'F7DD',    '63454'=>'F7DE',    '63455'=>'F7DF',    '63456'=>'F7E0',    '63457'=>'F7E1',
            '63458'=>'F7E2',    '63459'=>'F7E3',    '63460'=>'F7E4',    '62415'=>'F3CF',    '62416'=>'F3D0',
            '62417'=>'F3D1',    '62418'=>'F3D2',    '62419'=>'F3D3',    '62420'=>'F3D4',    '62421'=>'F3D5',
            '62422'=>'F3D6',    '62423'=>'F3D7',    '62424'=>'F3D8',    '62425'=>'F3D9',    '62426'=>'F3DA',
            '62427'=>'F3DB',    '62428'=>'F3DC',    '62429'=>'F3DD',    '62430'=>'F3DE',    '62431'=>'F3DF',
            '62432'=>'F3E0',    '62433'=>'F3E1',    '62434'=>'F3E2',    '62435'=>'F3E3',    '62436'=>'F3E4',
            '62437'=>'F3E5',    '62438'=>'F3E6',    '62439'=>'F3E7',    '62440'=>'F3E8',    '62441'=>'F3E9',
            '62442'=>'F3EA',    '62443'=>'F3EB',    '62444'=>'F3EC',    '62445'=>'F3ED',    '62446'=>'F3EE',
            '62447'=>'F3EF',    '62448'=>'F3F0',    '62449'=>'F3F1',    '62450'=>'F3F2',    '62451'=>'F3F3',
            '62452'=>'F3F4',    '62453'=>'F3F5',    '62454'=>'F3F6',    '62455'=>'F3F7',    '62456'=>'F3F8',
            '62457'=>'F3F9',    '62458'=>'F3FA',    '62459'=>'F3FB',    '62460'=>'F3FC',    '62528'=>'F440',
            '62529'=>'F441',    '62530'=>'F442',    '62531'=>'F443',    '62532'=>'F444',    '62533'=>'F445',
            '62534'=>'F446',    '62535'=>'F447',    '62536'=>'F448',    '62537'=>'F449',    '62538'=>'F44A',
            '62539'=>'F44B',    '62540'=>'F44C',    '62541'=>'F44D',    '62542'=>'F44E',    '62543'=>'F44F',
            '62544'=>'F450',    '62545'=>'F451',    '62546'=>'F452',    '62547'=>'F453',    '62548'=>'F454',
            '62549'=>'F455',    '62550'=>'F456',    '62551'=>'F457',    '62552'=>'F458',    '62553'=>'F459',
            '62554'=>'F45A',    '62555'=>'F45B',    '62556'=>'F45C',    '62557'=>'F45D',    '62558'=>'F45E',
            '62559'=>'F45F',    '62560'=>'F460',    '62561'=>'F461',    '62562'=>'F462',    '62563'=>'F463',
            '62564'=>'F464',    '62565'=>'F465',    '62566'=>'F466',    '62567'=>'F467',    '62568'=>'F468',
            '62569'=>'F469',    '62570'=>'F46A',    '62571'=>'F46B',    '62572'=>'F46C',    '62573'=>'F46D',
            '62574'=>'F46E',    '62575'=>'F46F',    '62576'=>'F470',    '62577'=>'F471',    '62578'=>'F472',
            '62579'=>'F473',    '62580'=>'F474',    '62581'=>'F475',    '62582'=>'F476',    '62583'=>'F477',
            '62584'=>'F478',    '62585'=>'F479',    '62586'=>'F47A',    '62587'=>'F47B',    '62588'=>'F47C',
            '62589'=>'F47D',    '62590'=>'F47E',    '62592'=>'F480',    '62593'=>'F481',    '62594'=>'F482',
            '62595'=>'F483',    '62596'=>'F484',    '62597'=>'F485',    '62598'=>'F486',    '62599'=>'F487',
            '62600'=>'F488',    '62601'=>'F489',    '62602'=>'F48A',    '62603'=>'F48B',    '62604'=>'F48C',
            '62605'=>'F48D',    '62606'=>'F48E',    '62607'=>'F48F',    '62608'=>'F490',    '62609'=>'F491',
            '62610'=>'F492',    '62611'=>'F493',    
        );
        return empty($map[$hex])?'':pack('H4',$map[$hex]);
    }


    /**
     * EZwebからSoftBankへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function ezweb2softbank($hex)
    {
        $map = array(
            '63065'=>'$Fr',             '63066'=>'$GA',             '63067'=>'$G@',             '63304'=>'[Q]',               '63305'=>'$F[',
            '63306'=>'$FZ',             '63307'=>'$F]',             '63308'=>'$F\',             '63309'=>'$F;',             '63310'=>'$F:',
            '63311'=>'[i]',               '63130'=>'$Gd',             '63210'=>'$Ea',             '63382'=>'$EO',             '63070'=>'$Gl',
            '63071'=>'$E]',             '63312'=>'$F;',             '63313'=>'$F:',             '63314'=>'$F;',             '63315'=>'$F;',
            '63316'=>'$F;',             '63317'=>'$F:',             '63318'=>'$F9',             '63319'=>'$F9',             '63383'=>'[腕時計]',
            '63320'=>'＋',                '63321'=>'－',                '63322'=>'＊',                '63323'=>'$FR',             '63324'=>'$FS',
            '63325'=>'[禁止]',            '63326'=>'▼',                '63327'=>'▲',                '63328'=>'▼',                '63329'=>'▲',
            '63330'=>'$F;',             '63331'=>'$F;',             '63332'=>'$F;',             '63333'=>'$F:',             '63334'=>'$F9',
            '63335'=>'$F9',             '63336'=>'$FW',             '63337'=>'$FX',             '63072'=>'$Gj',             '63123'=>'$G6',
            '63409'=>'$GM',             '63073'=>'$Gl',             '63211'=>'$OE',             '63356'=>'φ',                '63187'=>'$G"',
            '63410'=>'$GB',             '63131'=>'$Gd',             '63212'=>'$E0',             '63338'=>'$QW',             '63339'=>'$OS',
            '63357'=>'$O!',             '63384'=>'[砂時計]',          '63060'=>'[砂時計]',          '63358'=>'$O6',             '63074'=>'[雪結晶]',
            '63340'=>'$OS',             '63341'=>'$OS',             '63342'=>'$FT',             '63343'=>'$FU',             '63132'=>'$Gg',
            '63344'=>'÷',                '63360'=>'[カレンダー]',      '63188'=>'$Gv',             '63075'=>'$OO',             '63345'=>'$FV',
            '63346'=>'$FY',             '63213'=>'$GT',             '63347'=>'[チェックマーク]',  '63160'=>'$Gr',             '63040'=>'☆彡',
            '63044'=>'$ON',             '63054'=>'$E/',             '63161'=>'$QC',             '63404'=>'[フォルダ]',        '63189'=>'$G!',
            '63348'=>'$Fn',             '63349'=>'$Fo',             '63092'=>'$OC',             '63405'=>'[フォルダ]',        '63411'=>'$G)',
            '63190'=>'[フキダシ]',        '63385'=>'[カード]',          '63350'=>'▲',                '63351'=>'▼',                '63376'=>'$Q,',
            '63093'=>'$Eh',             '63361'=>'$O!',             '63412'=>'$Ge',             '63214'=>'$G(',             '63076'=>'$Gk',
            '63124'=>'$PK',             '63362'=>'$Eh',             '63068'=>'$EW',             '63042'=>'$En',             '63363'=>'$Eh',
            '63364'=>'$Eh',             '63365'=>'$Eh',             '63366'=>'$O!',             '63215'=>'$O3',             '63367'=>'[カレンダー]',
            '63094'=>'$EE',             '63077'=>'$Gi',             '63226'=>'$E#',             '63386'=>'￥',                '63216'=>'$G]',
            '63387'=>'$G]',             '63108'=>'$GV',             '63165'=>'$O$',             '63388'=>'[包丁]',            '63389'=>'$EI',
            '63191'=>'[メガネ]',          '63352'=>'└→',              '63353'=>'←┘',              '63217'=>'$E4',             '63218'=>'$G_',
            '63368'=>'$Eh',             '63095'=>'$Eh',             '63390'=>'[ネジ]',            '63219'=>'$E^',             '63114'=>'$G;',
            '63391'=>'$O6',             '63377'=>'$Ej',             '63378'=>'$Ej',             '63220'=>'$E!',             '63392'=>'[懐中電灯]',
            '63369'=>'$Eh',             '63354'=>'[チェックマーク]',  '63143'=>'$E8',             '63162'=>'$Gr',             '63393'=>'[電池]',
            '63355'=>'[スクロール]',      '63370'=>'[画びょう]',        '63221'=>'$Ed',             '63394'=>'$EO',             '63192'=>'$FP',
            '63193'=>'$FQ',             '63371'=>'$Eh',             '63096'=>'[クリップ]',        '63144'=>'$E2',             '63222'=>'[名札]',
            '63109'=>'$Gc',             '63372'=>'$Eh',             '63115'=>'$PO',             '63097'=>'$O!',             '63395'=>'[PDC]',
            '63406'=>'$E#',             '63396'=>'[レンチ]',          '63407'=>'[送信BOX]',         '63408'=>'[受信BOX]',         '63223'=>'$G)',
            '63110'=>'$GX',             '63373'=>'[定規]',            '63098'=>'[三角定規]',        '63379'=>'[グラフ]',          '63133'=>'[肉]',
            '63397'=>'$G*',             '63398'=>'[コンセント]',      '63194'=>'[家族]',            '63399'=>'[リンク]',          '63224'=>'$E2',
            '63225'=>'$G+',             '63078'=>'$Gj',             '63116'=>'$G=',             '63117'=>'$G<',             '63137'=>'[サイコロ]',
            '63400'=>'[新聞]',            '63118'=>'$G>',             '63401'=>'　',                '63402'=>'',                  '63403'=>'',
            '63061'=>'$O.',             '63062'=>'$F(',             '63063'=>'$F*',             '63064'=>'$F)',             '63227'=>'$F<',
            '63228'=>'$F=',             '63296'=>'$F>',             '63297'=>'$F?',             '63298'=>'$F@',             '63299'=>'$FA',
            '63300'=>'$FB',             '63301'=>'$FC',             '63302'=>'$FD',             '63303'=>'[10]',              '63041'=>'$Pc',
            '63069'=>'$Gh',             '63079'=>'$F_',             '63080'=>'$F`',             '63081'=>'$Fa',             '63082'=>'$Fb',
            '63083'=>'$Fc',             '63084'=>'$Fd',             '63085'=>'$Fe',             '63086'=>'$Ff',             '63087'=>'$Fg',
            '63088'=>'$Fh',             '63089'=>'$Fi',             '63090'=>'$Fj',             '63091'=>'$Fk',             '63099'=>'$Et',
            '63100'=>'$Ev',             '63101'=>'$Eq',             '63102'=>'$Eo',             '63104'=>'$Ep',             '63105'=>'$Ek',
            '63106'=>'$F"',             '63107'=>'$Em',             '63374'=>'$GZ',             '63375'=>'[地図]',            '63111'=>'$EV',
            '63112'=>'$Ey',             '63113'=>'$G?',             '63043'=>'$E5',             '63119'=>'$G8',             '63120'=>'$G5',
            '63121'=>'[スノボ]',          '63122'=>'$ER',             '63045'=>'$ED',             '63125'=>'$EC',             '63126'=>'$O+',
            '63127'=>'$OD',             '63128'=>'$Pk',             '63129'=>'$Q)',             '63046'=>'$ES',             '63047'=>'[オメデトウ]',
            '63134'=>'$EP',             '63135'=>'[ゲーム]',          '63136'=>'$EO',             '63138'=>'$GS',             '63139'=>'$GP',
            '63140'=>'$E;',             '63141'=>'$Q+',             '63142'=>'$Oh',             '63145'=>'$Gf',             '63146'=>'$Eg',
            '63147'=>'[さくらんぼ]',      '63148'=>'$G9',             '63149'=>'$Og',             '63150'=>'$Ob',             '63151'=>'$E@',
            '63048'=>'$Gt',             '63152'=>'$QL',             '63153'=>'$G:',             '63154'=>'$E)',             '63155'=>'$QQ',
            '63156'=>'$Go',             '63157'=>'$Gu',             '63158'=>'[アリ]',            '63159'=>'$E+',             '63163'=>'$O'."'".'',
            '63164'=>'$O%',             '63049'=>'$Gw',             '63050'=>'$Gy',             '63051'=>'$P1',             '63052'=>'$P&',
            '63053'=>'$E\',             '63166'=>'$OT',             '63167'=>'$OQ',             '63168'=>'$E%',             '63055'=>'$GC',
            '63056'=>'$OG',             '63057'=>'$ON',             '63058'=>'$O1',             '63059'=>'$E=',             '63169'=>'[SOS]',
            '63170'=>'$El',             '63171'=>'$OI',             '63172'=>'$G#',             '63173'=>'$E,',             '63174'=>'[なると]',
            '63175'=>'$QV',             '63176'=>'$E:',             '63177'=>'[花丸]',            '63178'=>'$O5',             '63179'=>'[100点]',
            '63180'=>'$G-',             '63181'=>'$OP',             '63182'=>'$Gz',             '63183'=>'$G/',             '63184'=>'$FF',
            '63185'=>'$E<',             '63186'=>'$G.',             '63195'=>'$EJ',             '63196'=>'$G\',             '63197'=>'[財布]',
            '63198'=>'$OF',             '63199'=>'$Ga',             '63200'=>'[バイオリン]',      '63201'=>'$O*',             '63202'=>'$O<',
            '63203'=>'$E3',             '63204'=>'$O>',             '63380'=>'[EZ]',              '63381'=>'[FREE]',            '63205'=>'$EF',
            '63206'=>'$G&',             '63207'=>'$E,',             '63208'=>'$F3',             '63209'=>'$E[',             '63413'=>'[霧]',
            '63414'=>'$G4',             '63415'=>'$PJ',             '63416'=>'[ポケベル]',        '63417'=>'$Q"',             '63418'=>'$Q#',
            '63419'=>'[イベント]',        '63420'=>'$O4',             '63421'=>'$Ok',             '63422'=>'$F.',             '63423'=>'$F-',
            '63424'=>'$F/',             '63425'=>'$P9',             '63426'=>'$P;',             '63427'=>'$G1',             '63428'=>'$G2',
            '63429'=>'●',                '63430'=>'$Gl',             '63431'=>'$Gl',             '63432'=>'[CL]',              '63433'=>'$FE',
            '63434'=>'$Fm',             '63435'=>'$P&',             '63436'=>'$OG',             '63437'=>'[ドンッ]',          '63438'=>'$OQ',
            '63439'=>'[ezplus]',          '63440'=>'[地球]',            '63441'=>'$O`',             '63461'=>'$F2',             '63462'=>'$G&',
            '63463'=>'$G'."'".'',       '63464'=>'$G,',             '63465'=>'$EH',             '63466'=>'$GR',             '63467'=>'$GW',
            '63468'=>'$PT',             '63469'=>'$G[',             '63470'=>'$G^',             '63471'=>'$Gn',             '63472'=>'$Gp',
            '63473'=>'$Gq',             '63474'=>'$Gs',             '63475'=>'$P%',             '63476'=>'$E&',             '63477'=>'$P0',
            '63478'=>'$E(',             '63479'=>'$E*',             '63480'=>'$E-',             '63481'=>'$E.',             '63482'=>'$E1',
            '63483'=>'$E6',             '63484'=>'$E7',             '62272'=>'$E9',             '62273'=>'$E>',             '62274'=>'$EA',
            '62275'=>'$EB',             '62276'=>'$EM',             '62277'=>'$EN',             '62278'=>'$EQ',             '62279'=>'[カメ]',
            '62280'=>'$Q1',             '62281'=>'$Q2',             '62282'=>'$EW',             '62283'=>'$E_',             '62284'=>'$Ec',
            '62285'=>'$Ef',             '62286'=>'$QC',             '62287'=>'$Ej',             '62288'=>'$Er',             '62289'=>'$Es',
            '62290'=>'$Eu',             '62291'=>'$Ew',             '62292'=>'$Ex',             '62293'=>'$F"',             '62294'=>'$F'."'".'',
            '62295'=>'$F+',             '62296'=>'$F4',             '62297'=>'$FG',             '62298'=>'$FH',             '62299'=>'$FI',
            '62300'=>'$FJ',             '62301'=>'$FK',             '62302'=>'$FL',             '62303'=>'$FM',             '62304'=>'$FN',
            '62305'=>'$FO',             '62306'=>'$F^',             '62307'=>'$Fp',             '62308'=>'$Fq',             '62309'=>'$O!',
            '62310'=>'$O"',             '62311'=>'$O#',             '62312'=>'$O&',             '62313'=>'$O(',             '62314'=>'$O+',
            '62315'=>'$O,',             '62316'=>'$O-',             '62317'=>'$O/',             '62318'=>'$O0',             '62319'=>'$O2',
            '62320'=>'[EZナビ]',          '62321'=>'$O8',             '62322'=>'$O;',             '62323'=>'$O=',             '62324'=>'$O?',
            '62325'=>'$O@',             '62326'=>'$OA',             '62327'=>'$OB',             '62328'=>'$F,',             '62329'=>'$OG',
            '62330'=>'$OJ',             '62331'=>'$OK',             '62332'=>'$OL',             '62333'=>'$OM',             '62334'=>'$ON',
            '62336'=>'$G3',             '62337'=>'$OR',             '62338'=>'$OX',             '62339'=>'$OY',             '62340'=>'$OZ',
            '62341'=>'$O[',             '62342'=>'$O\',             '62343'=>'$O]',             '62344'=>'$O^',             '62345'=>'$O_',
            '62346'=>'$Oa',             '62347'=>'$Oc',             '62348'=>'$Od',             '62349'=>'$Oe',             '62350'=>'$Of',
            '62351'=>'$Oi',             '62352'=>'$Oj',             '62353'=>'$Ol',             '62354'=>'$Om',             '62355'=>'$P"',
            '62356'=>'$P#',             '62357'=>'$P$',             '62358'=>'$P&',             '62359'=>'$P'."'".'',       '62360'=>'$P(',
            '62361'=>'$P*',             '62362'=>'$P+',             '62363'=>'$P,',             '62364'=>'$P-',             '62365'=>'$P.',
            '62366'=>'$P0',             '62367'=>'$P/',             '62368'=>'$OF',             '62369'=>'$Gv',             '62370'=>'$P7',
            '62371'=>'$P8',             '62372'=>'$P:',             '62373'=>'$P<',             '62374'=>'$P=',             '62375'=>'$P?',
            '62376'=>'$P@',             '62377'=>'$PA',             '62378'=>'$P>',             '62379'=>'$PC',             '62380'=>'$PD',
            '62381'=>'$PF',             '62382'=>'$PE',             '62383'=>'$PI',             '62384'=>'$Gb',             '62385'=>'$PL',
            '62386'=>'$PM',             '62387'=>'$PP',             '62388'=>'$PQ',             '62389'=>'$PR',             '62390'=>'$PS',
            '62391'=>'$PV',             '62392'=>'$PX',             '62393'=>'$PY',             '62394'=>'$PZ',             '62395'=>'$P[',
            '62396'=>'$P\',             '62397'=>'[花嫁]',            '62398'=>'$P_',             '62399'=>'$P`',             '62400'=>'$Pa',
            '62401'=>'$Pb',             '62402'=>'$Pe',             '62403'=>'$Pf',             '62404'=>'$Ph',             '62405'=>'$Pk',
            '62406'=>'$Pl',             '62407'=>'$Q!',             '62408'=>'$Pi',             '62409'=>'$Q#',             '62410'=>'$Q$',
            '62411'=>'$Q%',             '62412'=>'$Q&',             '62413'=>'$Q(',             '62414'=>'$Q-',             '63442'=>'[オープンウェブ]',
            '63443'=>'$Ed',             '63444'=>'[ABCD]',            '63445'=>'[abcd]',            '63446'=>'[1234]',            '63447'=>'[記号]',
            '63448'=>'[可]',              '63449'=>'[チェックマーク]',  '63450'=>'[ペン]',            '63451'=>'[ラジオボタン]',    '63452'=>'$E4',
            '63453'=>'$FU',             '63454'=>'[ブックマーク]',    '63455'=>'$E$',             '63456'=>'$GV',             '63457'=>'$E!',
            '63458'=>'$O!',             '63459'=>'$Ed',             '63460'=>'↑↓',              '62415'=>'$Q.',             '62416'=>'$Q/',
            '62417'=>'$Q0',             '62418'=>'$Q3',             '62419'=>'$Q4',             '62420'=>'$Q5',             '62421'=>'$Q6',
            '62422'=>'$Q7',             '62423'=>'$Q8',             '62424'=>'$Q9',             '62425'=>'$Q:',             '62426'=>'$Q;',
            '62427'=>'$Q<',             '62428'=>'$Q@',             '62429'=>'$Q?',             '62430'=>'$QB',             '62431'=>'$QE',
            '62432'=>'$QF',             '62433'=>'$QG',             '62434'=>'$QK',             '62435'=>'$QM',             '62436'=>'$QN',
            '62437'=>'$QO',             '62438'=>'$QP',             '62439'=>'$QR',             '62440'=>'$QS',             '62441'=>'$QU',
            '62442'=>'$QT',             '62443'=>'$QV',             '62444'=>'$G'."'".'',       '62445'=>'[旗]',              '62446'=>'$FV',
            '62447'=>'$FX',             '62448'=>'！？',              '62449'=>'！！',              '62450'=>'～',                '62451'=>'[メロン]',
            '62452'=>'[パイナップル]',    '62453'=>'[ブドウ]',          '62454'=>'[バナナ]',          '62455'=>'[とうもろこし]',    '62456'=>'[キノコ]',
            '62457'=>'[栗]',              '62458'=>'[モモ]',            '62459'=>'[やきいも]',        '62460'=>'[ピザ]',            '62528'=>'[チキン]',
            '62529'=>'[七夕]',            '62530'=>'$Gd',             '62531'=>'[辰]',              '62532'=>'[ピアノ]',          '62533'=>'$G7',
            '62534'=>'$G9',             '62535'=>'[ボーリング]',      '62536'=>'[なまはげ]',        '62537'=>'[天狗]',            '62538'=>'[パンダ]',
            '62539'=>'$P)',             '62540'=>'$E+',             '62541'=>'$O%',             '62542'=>'[アイスクリーム]',  '62543'=>'[ドーナツ]',
            '62544'=>'[クッキー]',        '62545'=>'[チョコ]',          '62546'=>'[キャンディ]',      '62547'=>'[キャンディ]',      '62548'=>'(/_＼)',
            '62549'=>'(・×・)',          '62550'=>'|(・×・)|',        '62551'=>'[火山]',            '62552'=>'$OH',             '62553'=>'[ABC]',
            '62554'=>'[プリン]',          '62555'=>'[ミツバチ]',        '62556'=>'[てんとう虫]',      '62557'=>'[ハチミツ]',        '62558'=>'$Oe',
            '62559'=>'[飛んでいくお金]',  '62560'=>'$P'."'".'',       '62561'=>'$P6',             '62562'=>'$P6',             '62563'=>'$Pk',
            '62564'=>'$P8',             '62565'=>'$Gw',             '62566'=>'$E#',             '62567'=>'$P2',             '62568'=>'$P2',
            '62569'=>'$E&',             '62570'=>'$P#',             '62571'=>'$P#',             '62572'=>'$P3',             '62573'=>'$P3',
            '62574'=>'$P$',             '62575'=>'$O9',             '62576'=>'[モアイ]',          '62577'=>'$GY',             '62578'=>'[花札]',
            '62579'=>'[ジョーカー]',      '62580'=>'[エビフライ]',      '62581'=>'$E#',             '62582'=>'$F!',             '62583'=>'$PR',
            '62584'=>'[EZムービー]',      '62585'=>'$OG',             '62586'=>'$QC',             '62587'=>'[ジーンズ]',        '62588'=>'$E#',
            '62589'=>'↑↓',              '62590'=>'⇔',                '62592'=>'↑↓',              '62593'=>'$P^',             '62594'=>'$E0',
            '62595'=>'[カタツムリ]',      '62596'=>'$P$',             '62597'=>'$P$',             '62598'=>'[Cメール]',         '62599'=>'$E0',
            '62600'=>'$G0',             '62601'=>'$F0',             '62602'=>'$G2',             '62603'=>'$PG',             '62604'=>'$P#',
            '62605'=>'$P6',    
        );
        return empty($map[$hex])?'':$map[$hex];
    }
} // emoji_EZweb
?>