<?php
/* SVN FILE: $Id: DoCoMo.php 479 2008-05-23 16:36:27Z bb_yujiro $ */
/**
 * DoCoMo用絵文字変換
 *
 * 参考資料：
 *       [絵文字の相互変換リスト] http://labs.unoh.net/2007/02/post_65.html
 *
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * DoCoMo用絵文字変換
 *
 * @category        Emoji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_Emoji_DoCoMo
{
    /**
     * DoCoMoから独自タグへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function docomo2tag($hex)
    {
        $map = array(
            'F89F'=>'[m:44]',     'F8A0'=>'[m:107]',    'F8A1'=>'[m:95]',     'F8A2'=>'[m:191]',    'F8A3'=>'[m:16]',
            'F8A4'=>'[m:190]',    'F8A5'=>'[m:305]',    'F8A6'=>'[m:481]',    'F8A7'=>'[m:192]',    'F8A8'=>'[m:193]',
            'F8A9'=>'[m:194]',    'F8AA'=>'[m:195]',    'F8AB'=>'[m:196]',    'F8AC'=>'[m:197]',    'F8AD'=>'[m:198]',
            'F8AE'=>'[m:199]',    'F8AF'=>'[m:200]',    'F8B0'=>'[m:201]',    'F8B1'=>'[m:202]',    'F8B2'=>'[m:203]',
            'F8B3'=>'[m:173]',    'F8B4'=>'[m:45]',     'F8B5'=>'[m:306]',    'F8B6'=>'[m:220]',    'F8B7'=>'[m:219]',
            'F8B8'=>'[m:421]',    'F8B9'=>'[m:307]',    'F8BA'=>'[m:222]',    'F8BB'=>'[m:308]',    'F8BC'=>'[m:172]',
            'F8BD'=>'[m:341]',    'F8BE'=>'[m:217]',    'F8BF'=>'[m:125]',    'F8C0'=>'[m:125]',    'F8C1'=>'[m:216]',
            'F8C2'=>'[m:379]',    'F8C3'=>'[m:168]',    'F8C4'=>'[m:112]',    'F8C5'=>'[m:156]',    'F8C6'=>'[m:375]',
            'F8C7'=>'[m:376]',    'F8C8'=>'[m:212]',    'F8C9'=>'[m:205]',    'F8CA'=>'[m:378]',    'F8CB'=>'[m:206]',
            'F8CC'=>'[m:213]',    'F8CD'=>'[m:208]',    'F8CE'=>'[m:99]',     'F8CF'=>'[m:207]',    'F8D0'=>'[m:146]',
            'F8D1'=>'[m:93]',     'F8D2'=>'[m:52]',     'F8D3'=>'[m:65]',     'F8D4'=>'[m:245]',    'F8D5'=>'[m:124]',
            'F8D6'=>'[m:104]',    'F8D7'=>'[m:289]',    'F8D8'=>'[m:110]',    'F8D9'=>'[m:70]',     'F8DA'=>'[m:173]',
            'F8DB'=>'[m:294]',    'F8DC'=>'[m:309]',    'F8DD'=>'[m:494]',    'F8DE'=>'[m:311]',    'F8DF'=>'[m:106]',
            'F8E0'=>'[m:176]',    'F8E1'=>'[m:177]',    'F8E2'=>'[m:94]',     'F8E3'=>'[m:83]',     'F8E4'=>'[m:122]',
            'F8E5'=>'[m:312]',    'F8E6'=>'[m:144]',    'F8E7'=>'[m:313]',    'F8E8'=>'[m:85]',     'F8E9'=>'[m:161]',
            'F8EA'=>'[m:395]',    'F8EB'=>'[m:288]',    'F8EC'=>'[m:232]',    'F8ED'=>'[m:300]',    'F8EE'=>'[m:414]',
            'F8EF'=>'[m:314]',    'F8F0'=>'[m:315]',    'F8F1'=>'[m:316]',    'F8F2'=>'[m:317]',    'F8F3'=>'[m:318]',
            'F8F4'=>'[m:817]',    'F8F5'=>'[m:319]',    'F8F6'=>'[m:320]',    'F8F7'=>'[m:43]',     'F8F8'=>'[m:42]',
            'F8F9'=>'[m:728]',    'F8FA'=>'[m:729]',    'F8FB'=>'[m:116]',    'F8FC'=>'[m:178]',    'F940'=>'[m:321]',
            'F941'=>'[m:322]',    'F942'=>'[m:323]',    'F943'=>'[m:15]',     'F944'=>'[m:173]',    'F945'=>'[m:134]',
            'F946'=>'[m:251]',    'F947'=>'[m:169]',    'F948'=>'[m:234]',    'F949'=>'[m:71]',     'F972'=>'[m:513]',
            'F973'=>'[m:784]',    'F974'=>'[m:166]',    'F975'=>'[m:173]',    'F976'=>'[m:173]',    'F977'=>'[m:108]',
            'F978'=>'[m:173]',    'F979'=>'[m:173]',    'F97A'=>'[m:109]',    'F97B'=>'[m:299]',    'F97C'=>'[m:385]',
            'F97D'=>'[m:120]',    'F97E'=>'[m:118]',    'F980'=>'[m:324]',    'F981'=>'[m:119]',    'F982'=>'[m:334]',
            'F983'=>'[m:730]',    'F984'=>'[m:173]',    'F985'=>'[m:818]',    'F986'=>'[m:4]',      'F987'=>'[m:180]',
            'F988'=>'[m:181]',    'F989'=>'[m:182]',    'F98A'=>'[m:183]',    'F98B'=>'[m:184]',    'F98C'=>'[m:185]',
            'F98D'=>'[m:186]',    'F98E'=>'[m:187]',    'F98F'=>'[m:188]',    'F990'=>'[m:325]',    'F9B0'=>'[m:326]',
            'F991'=>'[m:51]',     'F992'=>'[m:803]',    'F993'=>'[m:265]',    'F994'=>'[m:266]',    'F995'=>'[m:257]',
            'F996'=>'[m:258]',    'F997'=>'[m:441]',    'F998'=>'[m:444]',    'F999'=>'[m:327]',    'F99A'=>'[m:731]',
            'F99B'=>'[m:343]',    'F99C'=>'[m:224]',    'F99D'=>'[m:173]',    'F99E'=>'[m:273]',    'F99F'=>'[m:420]',
            'F9A0'=>'[m:77]',     'F9A1'=>'[m:262]',    'F9A2'=>'[m:281]',    'F9A3'=>'[m:268]',    'F9A4'=>'[m:291]',
            'F9A5'=>'[m:732]',    'F9A6'=>'[m:261]',    'F9A7'=>'[m:2]',      'F9A8'=>'[m:733]',    'F9A9'=>'[m:734]',
            'F9AA'=>'[m:329]',    'F9AB'=>'[m:330]',    'F9AC'=>'[m:263]',    'F9AD'=>'[m:282]',    'F9AE'=>'[m:173]',
            'F9AF'=>'[m:735]',    'F950'=>'[m:226]',    'F951'=>'[m:173]',    'F952'=>'[m:508]',    'F955'=>'[m:173]',
            'F956'=>'[m:173]',    'F957'=>'[m:490]',    'F95B'=>'[m:173]',    'F95C'=>'[m:173]',    'F95D'=>'[m:173]',
            'F95E'=>'[m:46]',     'F9B1'=>'[m:173]',    'F9B2'=>'[m:173]',    'F9B3'=>'[m:335]',    'F9B4'=>'[m:290]',
            'F9B5'=>'[m:295]',    'F9B6'=>'[m:805]',    'F9B7'=>'[m:221]',    'F9B8'=>'[m:48]',     'F9B9'=>'[m:173]',
            'F9BA'=>'[m:233]',    'F9BB'=>'[m:337]',    'F9BC'=>'[m:806]',    'F9BD'=>'[m:152]',    'F9BE'=>'[m:149]',
            'F9BF'=>'[m:354]',    'F9C0'=>'[m:72]',     'F9C1'=>'[m:58]',     'F9C2'=>'[m:215]',    'F9C3'=>'[m:423]',
            'F9C4'=>'[m:25]',     'F9C5'=>'[m:441]',    'F9C6'=>'[m:446]',    'F9C7'=>'[m:173]',    'F9C8'=>'[m:351]',
            'F9C9'=>'[m:779]',    'F9CA'=>'[m:450]',    'F9CB'=>'[m:349]',    'F9CC'=>'[m:287]',    'F9CD'=>'[m:264]',
            'F9CE'=>'[m:348]',    'F9CF'=>'[m:446]',    'F9D0'=>'[m:443]',    'F9D1'=>'[m:440]',    'F9D2'=>'[m:259]',
            'F9D3'=>'[m:791]',    'F9D4'=>'[m:173]',    'F9D5'=>'[m:143]',    'F9D6'=>'[m:81]',     'F9D7'=>'[m:54]',
            'F9D8'=>'[m:218]',    'F9D9'=>'[m:279]',    'F9DA'=>'[m:807]',    'F9DB'=>'[m:82]',     'F9DC'=>'[m:1]',
            'F9DD'=>'[m:173]',    'F9DE'=>'[m:387]',    'F9DF'=>'[m:173]',    'F9E0'=>'[m:386]',    'F9E1'=>'[m:808]',
            'F9E2'=>'[m:809]',    'F9E3'=>'[m:377]',    'F9E4'=>'[m:810]',    'F9E5'=>'[m:342]',    'F9E6'=>'[m:53]',
            'F9E7'=>'[m:241]',    'F9E8'=>'[m:113]',    'F9E9'=>'[m:739]',    'F9EA'=>'[m:434]',    'F9EB'=>'[m:811]',
            'F9EC'=>'[m:133]',    'F9ED'=>'[m:235]',    'F9EE'=>'[m:244]',    'F9EF'=>'[m:239]',    'F9F0'=>'[m:400]',
            'F9F1'=>'[m:333]',    'F9F2'=>'[m:424]',    'F9F3'=>'[m:812]',    'F9F4'=>'[m:78]',     'F9F5'=>'[m:252]',
            'F9F6'=>'[m:203]',    'F9F7'=>'[m:454]',    'F9F8'=>'[m:814]',    'F9F9'=>'[m:248]',    'F9FA'=>'[m:254]',
            'F9FB'=>'[m:12]',     'F9FC'=>'[m:350]',    
        );
        return empty($map[$hex])?'[m:173]':$map[$hex];
    }

    /**
     * DoCoMoからDoCoMo(エスケープ)へ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function docomo2docomo($hex)
    {
        $map = array(
            'F946'=>'&#63814;',    'F947'=>'&#63815;',    'F948'=>'&#63816;',    'F949'=>'&#63817;',    'F972'=>'&#63858;',
            'F973'=>'&#63859;',    'F974'=>'&#63860;',    'F975'=>'&#63861;',    'F976'=>'&#63862;',    'F977'=>'&#63863;',
            'F978'=>'&#63864;',    'F979'=>'&#63865;',    'F97A'=>'&#63866;',    'F97B'=>'&#63867;',    'F97C'=>'&#63868;',
            'F97D'=>'&#63869;',    'F97E'=>'&#63870;',    'F980'=>'&#63872;',    'F981'=>'&#63873;',    'F982'=>'&#63874;',
            'F983'=>'&#63875;',    'F984'=>'&#63876;',    'F985'=>'&#63877;',    'F986'=>'&#63878;',    'F987'=>'&#63879;',
            'F988'=>'&#63880;',    'F989'=>'&#63881;',    'F98A'=>'&#63882;',    'F98B'=>'&#63883;',    'F98C'=>'&#63884;',
            'F98D'=>'&#63885;',    'F98E'=>'&#63886;',    'F98F'=>'&#63887;',    'F990'=>'&#63888;',    'F9B0'=>'&#63920;',
            'F991'=>'&#63889;',    'F992'=>'&#63890;',    'F993'=>'&#63891;',    'F994'=>'&#63892;',    'F995'=>'&#63893;',
            'F996'=>'&#63894;',    'F997'=>'&#63895;',    'F998'=>'&#63896;',    'F999'=>'&#63897;',    'F99A'=>'&#63898;',
            'F99B'=>'&#63899;',    'F99C'=>'&#63900;',    'F99D'=>'&#63901;',    'F99E'=>'&#63902;',    'F99F'=>'&#63903;',
            'F9A0'=>'&#63904;',    'F9A1'=>'&#63905;',    'F9A2'=>'&#63906;',    'F9A3'=>'&#63907;',    'F9A4'=>'&#63908;',
            'F9A5'=>'&#63909;',    'F9A6'=>'&#63910;',    'F9A7'=>'&#63911;',    'F9A8'=>'&#63912;',    'F9A9'=>'&#63913;',
            'F9AA'=>'&#63914;',    'F9AB'=>'&#63915;',    'F9AC'=>'&#63916;',    'F9AD'=>'&#63917;',    'F9AE'=>'&#63918;',
            'F9AF'=>'&#63919;',    'F950'=>'&#63824;',    'F951'=>'&#63825;',    'F952'=>'&#63826;',    'F955'=>'&#63829;',
            'F956'=>'&#63830;',    'F957'=>'&#63831;',    'F95B'=>'&#63835;',    'F95C'=>'&#63836;',    'F95D'=>'&#63837;',
            'F95E'=>'&#63838;',    'F9B1'=>'&#63921;',    'F9B2'=>'&#63922;',    'F9B3'=>'&#63923;',    'F9B4'=>'&#63924;',
            'F9B5'=>'&#63925;',    'F9B6'=>'&#63926;',    'F9B7'=>'&#63927;',    'F9B8'=>'&#63928;',    'F9B9'=>'&#63929;',
            'F9BA'=>'&#63930;',    'F9BB'=>'&#63931;',    'F9BC'=>'&#63932;',    'F9BD'=>'&#63933;',    'F9BE'=>'&#63934;',
            'F9BF'=>'&#63935;',    'F9C0'=>'&#63936;',    'F9C1'=>'&#63937;',    'F9C2'=>'&#63938;',    'F9C3'=>'&#63939;',
            'F9C4'=>'&#63940;',    'F9C5'=>'&#63941;',    'F9C6'=>'&#63942;',    'F9C7'=>'&#63943;',    'F9C8'=>'&#63944;',
            'F9C9'=>'&#63945;',    'F9CA'=>'&#63946;',    'F9CB'=>'&#63947;',    'F9CC'=>'&#63948;',    'F9CD'=>'&#63949;',
            'F9CE'=>'&#63950;',    'F9CF'=>'&#63951;',    'F9D0'=>'&#63952;',    'F9D1'=>'&#63953;',    'F9D2'=>'&#63954;',
            'F9D3'=>'&#63955;',    'F9D4'=>'&#63956;',    'F9D5'=>'&#63957;',    'F9D6'=>'&#63958;',    'F9D7'=>'&#63959;',
            'F9D8'=>'&#63960;',    'F9D9'=>'&#63961;',    'F9DA'=>'&#63962;',    'F9DB'=>'&#63963;',    'F9DC'=>'&#63964;',
            'F9DD'=>'&#63965;',    'F9DE'=>'&#63966;',    'F9DF'=>'&#63967;',    'F9E0'=>'&#63968;',    'F9E1'=>'&#63969;',
            'F9E2'=>'&#63970;',    'F9E3'=>'&#63971;',    'F9E4'=>'&#63972;',    'F9E5'=>'&#63973;',    'F9E6'=>'&#63974;',
            'F9E7'=>'&#63975;',    'F9E8'=>'&#63976;',    'F9E9'=>'&#63977;',    'F9EA'=>'&#63978;',    'F9EB'=>'&#63979;',
            'F9EC'=>'&#63980;',    'F9ED'=>'&#63981;',    'F9EE'=>'&#63982;',    'F9EF'=>'&#63983;',    'F9F0'=>'&#63984;',
            'F9F1'=>'&#63985;',    'F9F2'=>'&#63986;',    'F9F3'=>'&#63987;',    'F9F4'=>'&#63988;',    'F9F5'=>'&#63989;',
            'F9F6'=>'&#63990;',    'F9F7'=>'&#63991;',    'F9F8'=>'&#63992;',    'F9F9'=>'&#63993;',    'F9FA'=>'&#63994;',
            'F9FB'=>'&#63995;',    'F9FC'=>'&#63996;',    
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * DoCoMoからEZwebへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function docomo2ezweb($hex)
    {
        $map = array(
            'F89F'=>'<img localsrc="44">',     'F8A0'=>'<img localsrc="107">',       'F8A1'=>'<img localsrc="95">',        'F8A2'=>'<img localsrc="191">',    'F8A3'=>'<img localsrc="16">',
            'F8A4'=>'<img localsrc="190">',    'F8A5'=>'<img localsrc="305">',       'F8A6'=>'<img localsrc="481">',       'F8A7'=>'<img localsrc="192">',    'F8A8'=>'<img localsrc="193">',
            'F8A9'=>'<img localsrc="194">',    'F8AA'=>'<img localsrc="195">',       'F8AB'=>'<img localsrc="196">',       'F8AC'=>'<img localsrc="197">',    'F8AD'=>'<img localsrc="198">',
            'F8AE'=>'<img localsrc="199">',    'F8AF'=>'<img localsrc="200">',       'F8B0'=>'<img localsrc="201">',       'F8B1'=>'<img localsrc="202">',    'F8B2'=>'<img localsrc="203">',
            'F8B3'=>'〓',                      'F8B4'=>'<img localsrc="45">',        'F8B5'=>'<img localsrc="306">',       'F8B6'=>'<img localsrc="220">',    'F8B7'=>'<img localsrc="219">',
            'F8B8'=>'<img localsrc="421">',    'F8B9'=>'<img localsrc="307">',       'F8BA'=>'<img localsrc="222">',       'F8BB'=>'<img localsrc="308">',    'F8BC'=>'<img localsrc="172">',
            'F8BD'=>'<img localsrc="341">',    'F8BE'=>'<img localsrc="217">',       'F8BF'=>'<img localsrc="125">',       'F8C0'=>'<img localsrc="125">',    'F8C1'=>'<img localsrc="216">',
            'F8C2'=>'<img localsrc="379">',    'F8C3'=>'<img localsrc="168">',       'F8C4'=>'<img localsrc="112">',       'F8C5'=>'<img localsrc="156">',    'F8C6'=>'<img localsrc="375">',
            'F8C7'=>'<img localsrc="376">',    'F8C8'=>'<img localsrc="212">',       'F8C9'=>'<img localsrc="205">',       'F8CA'=>'<img localsrc="378">',    'F8CB'=>'<img localsrc="206">',
            'F8CC'=>'<img localsrc="213">',    'F8CD'=>'<img localsrc="208">',       'F8CE'=>'<img localsrc="99">',        'F8CF'=>'<img localsrc="207">',    'F8D0'=>'<img localsrc="146">',
            'F8D1'=>'<img localsrc="93">',     'F8D2'=>'<img localsrc="52">',        'F8D3'=>'<img localsrc="65">',        'F8D4'=>'<img localsrc="245">',    'F8D5'=>'<img localsrc="124">',
            'F8D6'=>'<img localsrc="104">',    'F8D7'=>'<img localsrc="289">',       'F8D8'=>'<img localsrc="110">',       'F8D9'=>'<img localsrc="70">',     'F8DA'=>'〓',
            'F8DB'=>'<img localsrc="294">',    'F8DC'=>'<img localsrc="309">',       'F8DD'=>'<img localsrc="494">',       'F8DE'=>'<img localsrc="311">',    'F8DF'=>'<img localsrc="106">',
            'F8E0'=>'<img localsrc="176">',    'F8E1'=>'<img localsrc="177">',       'F8E2'=>'<img localsrc="94">',        'F8E3'=>'<img localsrc="83">',     'F8E4'=>'<img localsrc="122">',
            'F8E5'=>'<img localsrc="312">',    'F8E6'=>'<img localsrc="144">',       'F8E7'=>'<img localsrc="313">',       'F8E8'=>'<img localsrc="85">',     'F8E9'=>'<img localsrc="161">',
            'F8EA'=>'<img localsrc="395">',    'F8EB'=>'<img localsrc="288">',       'F8EC'=>'<img localsrc="232">',       'F8ED'=>'<img localsrc="300">',    'F8EE'=>'<img localsrc="414">',
            'F8EF'=>'<img localsrc="314">',    'F8F0'=>'<img localsrc="315">',       'F8F1'=>'<img localsrc="316">',       'F8F2'=>'<img localsrc="317">',    'F8F3'=>'<img localsrc="318">',
            'F8F4'=>'<img localsrc="817">',    'F8F5'=>'<img localsrc="319">',       'F8F6'=>'<img localsrc="320">',       'F8F7'=>'<img localsrc="43">',     'F8F8'=>'<img localsrc="42">',
            'F8F9'=>'<img localsrc="728">',    'F8FA'=>'<img localsrc="729">',       'F8FB'=>'<img localsrc="116">',       'F8FC'=>'<img localsrc="178">',    'F940'=>'<img localsrc="321">',
            'F941'=>'<img localsrc="322">',    'F942'=>'<img localsrc="323">',       'F943'=>'<img localsrc="15">',        'F944'=>'○',                      'F945'=>'<img localsrc="134">',
            'F946'=>'<img localsrc="251">',    'F947'=>'<img localsrc="169">',       'F948'=>'<img localsrc="234">',       'F949'=>'<img localsrc="71">',     'F972'=>'<img localsrc="513">',
            'F973'=>'<img localsrc="784">',    'F974'=>'<img localsrc="166">',       'F975'=>'i-mode',                     'F976'=>'i-mode',                  'F977'=>'<img localsrc="108">',
            'F978'=>'[DoCoMo]',                'F979'=>'[DoCoMoP]',                  'F97A'=>'<img localsrc="109">',       'F97B'=>'<img localsrc="299">',    'F97C'=>'<img localsrc="385">',
            'F97D'=>'<img localsrc="120">',    'F97E'=>'<img localsrc="118">',       'F980'=>'<img localsrc="324">',       'F981'=>'<img localsrc="119">',    'F982'=>'<img localsrc="334">',
            'F983'=>'<img localsrc="730">',    'F984'=>'[0120]',                     'F985'=>'<img localsrc="818">',       'F986'=>'<img localsrc="4">',      'F987'=>'<img localsrc="180">',
            'F988'=>'<img localsrc="181">',    'F989'=>'<img localsrc="182">',       'F98A'=>'<img localsrc="183">',       'F98B'=>'<img localsrc="184">',    'F98C'=>'<img localsrc="185">',
            'F98D'=>'<img localsrc="186">',    'F98E'=>'<img localsrc="187">',       'F98F'=>'<img localsrc="188">',       'F990'=>'<img localsrc="325">',    'F9B0'=>'<img localsrc="326">',
            'F991'=>'<img localsrc="51">',     'F992'=>'<img localsrc="803">',       'F993'=>'<img localsrc="265">',       'F994'=>'<img localsrc="266">',    'F995'=>'<img localsrc="257">',
            'F996'=>'<img localsrc="258">',    'F997'=>'<img localsrc="441">',       'F998'=>'<img localsrc="444">',       'F999'=>'<img localsrc="327">',    'F99A'=>'<img localsrc="731">',
            'F99B'=>'<img localsrc="343">',    'F99C'=>'<img localsrc="224">',       'F99D'=>'〓',                         'F99E'=>'<img localsrc="273">',    'F99F'=>'<img localsrc="420">',
            'F9A0'=>'<img localsrc="77">',     'F9A1'=>'<img localsrc="262">',       'F9A2'=>'<img localsrc="281">',       'F9A3'=>'<img localsrc="268">',    'F9A4'=>'<img localsrc="291">',
            'F9A5'=>'<img localsrc="732">',    'F9A6'=>'<img localsrc="261">',       'F9A7'=>'<img localsrc="2">',         'F9A8'=>'<img localsrc="733">',    'F9A9'=>'<img localsrc="734">',
            'F9AA'=>'<img localsrc="329">',    'F9AB'=>'<img localsrc="330">',       'F9AC'=>'<img localsrc="263">',       'F9AD'=>'<img localsrc="282">',    'F9AE'=>'〓',
            'F9AF'=>'<img localsrc="735">',    'F950'=>'<img localsrc="226">',       'F951'=>'[ふくろ]',                   'F952'=>'<img localsrc="508">',    'F955'=>'〓',
            'F956'=>'[いす]',                  'F957'=>'<img localsrc="490">',       'F95B'=>'[ＳＯＯＮ]',                 'F95C'=>'[ＯＮ]',                  'F95D'=>'[ｅｎｄ]',
            'F95E'=>'<img localsrc="46">',     'F9B1'=>'[ｉアプリ]',                 'F9B2'=>'[ｉアプリ]',                 'F9B3'=>'<img localsrc="335">',    'F9B4'=>'<img localsrc="290">',
            'F9B5'=>'<img localsrc="295">',    'F9B6'=>'<img localsrc="805">',       'F9B7'=>'<img localsrc="221">',       'F9B8'=>'<img localsrc="48">',     'F9B9'=>'[ドア]',
            'F9BA'=>'<img localsrc="233">',    'F9BB'=>'<img localsrc="337">',       'F9BC'=>'<img localsrc="806">',       'F9BD'=>'<img localsrc="152">',    'F9BE'=>'<img localsrc="149">',
            'F9BF'=>'<img localsrc="354">',    'F9C0'=>'<img localsrc="72">',        'F9C1'=>'<img localsrc="58">',        'F9C2'=>'<img localsrc="215">',    'F9C3'=>'<img localsrc="423">',
            'F9C4'=>'<img localsrc="25">',     'F9C5'=>'<img localsrc="441">',       'F9C6'=>'<img localsrc="446">',       'F9C7'=>'<img localsrc="257">',    'F9C8'=>'<img localsrc="351">',
            'F9C9'=>'<img localsrc="779">',    'F9CA'=>'<img localsrc="450">',       'F9CB'=>'<img localsrc="349">',       'F9CC'=>'<img localsrc="287">',    'F9CD'=>'<img localsrc="264">',
            'F9CE'=>'<img localsrc="348">',    'F9CF'=>'<img localsrc="446">',       'F9D0'=>'<img localsrc="443">',       'F9D1'=>'<img localsrc="440">',    'F9D2'=>'<img localsrc="259">',
            'F9D3'=>'<img localsrc="791">',    'F9D4'=>'[ＮＧ]',                     'F9D5'=>'<img localsrc="143">',       'F9D6'=>'<img localsrc="81">',     'F9D7'=>'<img localsrc="54">',
            'F9D8'=>'<img localsrc="218">',    'F9D9'=>'<img localsrc="279">',       'F9DA'=>'<img localsrc="807">',       'F9DB'=>'<img localsrc="82">',     'F9DC'=>'<img localsrc="1">',
            'F9DD'=>'[禁]',                    'F9DE'=>'<img localsrc="387">',       'F9DF'=>'[合]',                       'F9E0'=>'<img localsrc="386">',    'F9E1'=>'<img localsrc="808">',
            'F9E2'=>'<img localsrc="809">',    'F9E3'=>'<img localsrc="377">',       'F9E4'=>'<img localsrc="810">',       'F9E5'=>'<img localsrc="342">',    'F9E6'=>'<img localsrc="53">',
            'F9E7'=>'<img localsrc="241">',    'F9E8'=>'<img localsrc="113">',       'F9E9'=>'<img localsrc="739">',       'F9EA'=>'<img localsrc="434">',    'F9EB'=>'<img localsrc="811">',
            'F9EC'=>'<img localsrc="133">',    'F9ED'=>'<img localsrc="235">',       'F9EE'=>'<img localsrc="244">',       'F9EF'=>'<img localsrc="239">',    'F9F0'=>'<img localsrc="400">',
            'F9F1'=>'<img localsrc="333">',    'F9F2'=>'<img localsrc="424">',       'F9F3'=>'<img localsrc="812">',       'F9F4'=>'<img localsrc="78">',     'F9F5'=>'<img localsrc="252">',
            'F9F6'=>'<img localsrc="203">',    'F9F7'=>'<img localsrc="454">',       'F9F8'=>'<img localsrc="814">',       'F9F9'=>'<img localsrc="248">',    'F9FA'=>'<img localsrc="254">',
            'F9FB'=>'<img localsrc="12">',     'F9FC'=>'<img localsrc="350">',
        );
        return empty($map[$hex])?'':$map[$hex];
    }

    /**
     * DoCoMoからSoftBankへ変換
     *
     * @access public
     * @param string $hex
     * @return string
     */
    public static function docomo2softbank($hex)
    {
        $map = array(
            'F89F'=>'$Gj',      'F8A0'=>'$Gi',      'F8A1'=>'$Gk',        'F8A2'=>'$Gh',       'F8A3'=>'$E]',
            'F8A4'=>'$Pc',      'F8A5'=>'[霧]',       'F8A6'=>'$P\',        'F8A7'=>'$F_',       'F8A8'=>'$F`',
            'F8A9'=>'$Fa',      'F8AA'=>'$Fb',      'F8AB'=>'$Fc',        'F8AC'=>'$Fd',       'F8AD'=>'$Fe',
            'F8AE'=>'$Ff',      'F8AF'=>'$Fg',      'F8B0'=>'$Fh',        'F8B1'=>'$Fi',       'F8B2'=>'$Fj',
            'F8B3'=>'〓',         'F8B4'=>'$G6',      'F8B5'=>'$G4',        'F8B6'=>'$G5',       'F8B7'=>'$G8',
            'F8B8'=>'$G3',      'F8B9'=>'$PJ',      'F8BA'=>'$ER',        'F8BB'=>'[ポケベル]',  'F8BC'=>'$G>',
            'F8BD'=>'$PT',      'F8BE'=>'$PU',      'F8BF'=>'$G;',        'F8C0'=>'$PN',       'F8C1'=>'$Ey',
            'F8C2'=>'$F"',      'F8C3'=>'$G=',      'F8C4'=>'$GV',        'F8C5'=>'$GX',       'F8C6'=>'$Es',
            'F8C7'=>'$Eu',      'F8C8'=>'$Em',      'F8C9'=>'$Et',        'F8CA'=>'$Ex',       'F8CB'=>'$Ev',
            'F8CC'=>'$GZ',      'F8CD'=>'$Eo',      'F8CE'=>'$En',        'F8CF'=>'$Eq',       'F8D0'=>'$Gc',
            'F8D1'=>'$Ge',      'F8D2'=>'$Gd',      'F8D3'=>'$Gg',        'F8D4'=>'$E@',       'F8D5'=>'$E^',
            'F8D6'=>'$O3',      'F8D7'=>'$G\',      'F8D8'=>'$G]',        'F8D9'=>'$FV',       'F8DA'=>'〓',
            'F8DB'=>'$O*',      'F8DC'=>'$Q"',      'F8DD'=>'$Q#',        'F8DE'=>'〓',          'F8DF'=>'$EE',
            'F8E0'=>'$O.',      'F8E1'=>'$F(',      'F8E2'=>'$G(',        'F8E3'=>'$OC',       'F8E4'=>'$Eh',
            'F8E5'=>'$O4',      'F8E6'=>'$E2',      'F8E7'=>'$Ok',        'F8E8'=>'$G)',       'F8E9'=>'$G*',
            'F8EA'=>'$O!',      'F8EB'=>'$EJ',      'F8EC'=>'[ゲーム]',     'F8ED'=>'$EF',       'F8EE'=>'$F,',
            'F8EF'=>'$F.',      'F8F0'=>'$F-',      'F8F1'=>'$F/',        'F8F2'=>'$P9',       'F8F3'=>'$P;',
            'F8F4'=>'$G0',      'F8F5'=>'$G1',      'F8F6'=>'$G2',        'F8F7'=>'$FX',       'F8F8'=>'$FW',
            'F8F9'=>'$QV',      'F8FA'=>'$G'."'".'','F8FB'=>'[メガネ]',     'F8FC'=>'$F*',       'F940'=>'●',
            'F941'=>'$Gl',      'F942'=>'$Gl',      'F943'=>'$Gl',        'F944'=>'○',          'F945'=>'$Gr',
            'F946'=>'$Go',      'F947'=>'$G<',      'F948'=>'$GS',        'F949'=>'$FY',       'F972'=>'$E$',
            'F973'=>'$E#',      'F974'=>'$G+',      'F975'=>'[ｉモード]',   'F976'=>'[ｉモード]',  'F977'=>'$E#',
            'F978'=>'[DoCoMo]',   'F979'=>'[DoCoMoP]',  'F97A'=>'￥',           'F97B'=>'[ＦＲＥＥ]',  'F97C'=>'$FI',
            'F97D'=>'$G_',      'F97E'=>'〓',         'F980'=>'[ＣＬ]',       'F981'=>'$E4',       'F982'=>'$F2',
            'F983'=>'〓',         'F984'=>'$F1',      'F985'=>'$F0',        'F986'=>'[Ｑ]',        'F987'=>'$F<',
            'F988'=>'$F=',      'F989'=>'$F>',      'F98A'=>'$F?',        'F98B'=>'$F@',       'F98C'=>'$FA',
            'F98D'=>'$FB',      'F98E'=>'$FC',      'F98F'=>'$FD',        'F990'=>'$FE',       'F9B0'=>'$Fm',
            'F991'=>'$GB',      'F992'=>'$OG',      'F993'=>'$GC',        'F994'=>'$OG',       'F995'=>'$Gw',
            'F996'=>'$Gy',      'F997'=>'$Gx',      'F998'=>'$P'."'".'',  'F999'=>'$P&',       'F99A'=>'$FV',
            'F99B'=>'$G^',      'F99C'=>'$EC',      'F99D'=>'〓',           'F99E'=>'$G#',       'F99F'=>'$ON',
            'F9A0'=>'$E/',      'F9A1'=>'$OT',      'F9A2'=>'$G-',        'F9A3'=>'$O1',       'F9A4'=>'$OF',
            'F9A5'=>'$FX',      'F9A6'=>'$E\',      'F9A7'=>'$GA',        'F9A8'=>'！？',        'F9A9'=>'！！',
            'F9AA'=>'〓',         'F9AB'=>'$OQ',      'F9AC'=>'$OQ',        'F9AD'=>'$OP',       'F9AE'=>'〓',
            'F9AF'=>'〓',         'F950'=>'$OD',      'F951'=>'[ふくろ]',     'F952'=>'[ペン]',      'F955'=>'〓',
            'F956'=>'$E?',      'F957'=>'$Pk',      'F95B'=>'[ＳＯＯＮ]',   'F95C'=>'[ＯＮ]',      'F95D'=>'[ｅｎｄ]',
            'F95E'=>'$GM',      'F9B1'=>'[ｉアプリ]', 'F9B2'=>'[ｉアプリ]',   'F9B3'=>'$G&',       'F9B4'=>'[財布]',
            'F9B5'=>'$O<',      'F9B6'=>'[ジーンズ]', 'F9B7'=>'[スノボ]',     'F9B8'=>'$OE',       'F9B9'=>'[ドア]',
            'F9BA'=>'$EO',      'F9BB'=>'$G,',      'F9BC'=>'$$E#',       'F9BD'=>'[レンチ]',    'F9BE'=>'$O!',
            'F9BF'=>'$E.',      'F9C0'=>'$GT',      'F9C1'=>'[砂時計]',     'F9C2'=>'$EV',       'F9C3'=>'$OX',
            'F9C4'=>'[腕時計]',   'F9C5'=>'$P#',      'F9C6'=>'$P*',        'F9C7'=>'$$P5',      'F9C8'=>'$E(',
            'F9C9'=>'$P6',      'F9CA'=>'$P.',      'F9CB'=>'$E&',        'F9CC'=>'$G.',       'F9CD'=>'$E%',
            'F9CE'=>'$P%',      'F9CF'=>'$P*',      'F9D0'=>'$P&',        'F9D1'=>'$P"',       'F9D2'=>'$P1',
            'F9D3'=>'$P3',      'F9D4'=>'[ＮＧ]',     'F9D5'=>'[クリップ]',   'F9D6'=>'$Fn',       'F9D7'=>'$QW',
            'F9D8'=>'$E5',      'F9D9'=>'$O5',      'F9DA'=>'〓',           'F9DB'=>'$Fo',       'F9DC'=>'$Fr',
            'F9DD'=>'[禁]',       'F9DE'=>'$FK',      'F9DF'=>'[合]',         'F9E0'=>'$FJ',       'F9E1'=>'⇔',
            'F9E2'=>'↑↓',       'F9E3'=>'$Ew',      'F9E4'=>'$P^',        'F9E5'=>'$G[',       'F9E6'=>'$E0',
            'F9E7'=>'[チェリー]', 'F9E8'=>'$O$',      'F9E9'=>'[バナナ]',     'F9EA'=>'$Oe',       'F9EB'=>'$E0',
            'F9EC'=>'$E8',      'F9ED'=>'$GP',      'F9EE'=>'$Ob',        'F9EF'=>'$Gf',       'F9F0'=>'$O+',
            'F9F1'=>'$O`',      'F9F2'=>'$OY',      'F9F3'=>'[カタツムリ]', 'F9F4'=>'$QC',       'F9F5'=>'$Gu',
            'F9F6'=>'$G9',      'F9F7'=>'$Gv',      'F9F8'=>'$P$',        'F9F9'=>'$G:',       'F9FA'=>'$E+',
            'F9FB'=>'$Gd',      'F9FC'=>'$E'."'".'',
        );
        return empty($map[$hex])?'':$map[$hex];
    }
} // emoji_DoCoMo
?>