<?php
/* SVN FILE: $Id: Emoji.php 479 2008-05-23 16:36:27Z bb_yujiro $ */
/**
 * 絵文字
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * ベースディレクトリ設定
 */
define('EMOJI_DIR', dirname(__FILE__).DIRECTORY_SEPARATOR);

/**
 * 絵文字クラス
 *
 * @category        Emoji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 479 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:36:27 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Text_Emoji
{
    /**
     * 変換後エンコード
     * @var string
     */
    private $_to_encoding = '';

    /**
     * 変換前エンコード
     * @var string
     */
    private $_from_encoding = '';

    /**
     * 内部エンコード
     * @var string
     */
    private $_internal_encoding = '';

    /**
     * 出力エンコード
     * @var string
     */
    private $_output_encoding = '';

    /**
     * デフォルト代替文字
     * @var string
     */
    private $_default_substrchar = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct($output='SJIS', $internal='')
    {
        $this->_default_substrchar = mb_substitute_character();

        $this->_internal_encoding = empty($internal)?mb_internal_encoding():$internal;
        $this->_output_encoding   = $output;

        $this->autoFromEncoding();
    }

    /**
     * from_encodingの自動設定
     *
     * @access public
     * @return void
     */
    public function autoFromEncoding()
    {
        $agent = Net_UserAgent_Mobile::singleton();
        $name  = $agent->getCarrierLongName();
        
        $name2method = array(
            'NonMobile'=>'Tag',
            'DoCoMo'=>   'DoCoMo',
            'EZweb'=>    'EZweb',
            'SoftBank'=> 'SoftBank',
            'WILLCOM'=>  'Tag',
        );

        $this->_from_encoding = $name2method[$name];
    }

    /**
     * from_encodingの自動設定
     *
     * @access public
     * @return string
     */
    public function getFromEncoding()
    {
        return $this->_from_encoding;
    }

    /**
     * 絵文字変換
     *
     * @access public
     * @param string $str
     * @param string $to_encoding
     * @param string $from_encoding
     * @access public
     */
    public function convertEncoding($str, $to_encoding, $from_encoding=null)
    {
        $this->_to_encoding   = $to_encoding;
        $this->_from_encoding = empty($from_encoding)?$this->_from_encoding:$from_encoding;
        if (!include_once EMOJI_DIR.'Emoji/'.$this->_from_encoding.'.php') {
            throw new Exception ('Driver not found');
        }

        /* HEX フォーマットを設定 */
        mb_substitute_character('long');

        /* 絵文字はBAD+16進数に変換 */
        $str = mb_convert_encoding($str, $this->_output_encoding, $this->_internal_encoding);
        mb_substitute_character($this->_default_substrchar);

        $path = preg_quote(BASE_URL.'resource/img/emoji/','/');
        $pattern = array(
            'tag'=>      '<img src="'.$path.'(\d+).gif">',
            'docomo'=>   'BAD\+([A-F0-9]{4})',
            'ezweb'=>    'BAD\+([A-F0-9]{4})',
            'softbank'=> '\x1B\$([E-GO-Q][!-z])\x0F',
        );
        $key = strtolower($this->_from_encoding);
        
        $callback = array(&$this, '_callback');
        return preg_replace_callback('/'.$pattern[$key].'/', $callback, $str);
    }

    /**
     * 絵文字変換
     *
     * @access public
     * @param string $str
     * @param string $to_encoding
     * @param string $from_encoding
     * @access public
     */
    public function convert($str, $to_encoding, $from_encoding=null)
    {
        $this->_to_encoding   = $to_encoding;
        $this->_from_encoding = empty($from_encoding)?$this->_from_encoding:$from_encoding;
        if (!include_once EMOJI_DIR.'Emoji/'.$this->_from_encoding.'.php') {
            throw new Exception ('Driver not found');
        }

        $pattern = array(
            'tag'=>      '\[m\:(\d+)\]',
            'docomo'=>   '&#([0-9]{5});',
            'ezweb'=>    '&#([0-9]{5});',
            'softbank'=> '\x1B\$([E-GO-Q][!-z])\x0F',
        );
        $key = strtolower($this->_from_encoding);
        
        $callback = array(&$this, '_callback');
        return preg_replace_callback('/'.$pattern[$key].'/', $callback, $str);
    }

    /**
     * コールバック関数
     *
     * @access private
     * @param array $matches
     * @return string
     */
    private function _callback($matches)
    {
        $class  = 'Text_Emoji_'.$this->_from_encoding;
        $method = $this->_from_encoding.'2'.$this->_to_encoding;
        $method = strtolower($method);

        return call_user_func(array($class,$method), $matches[1]);
    }
} // RKT_Emojiの終了
?>
