<?php
/* SVN FILE: $Id: DOM.php 331 2008-05-11 01:12:41Z bb_yujiro $ */
/**
 * DOMによる属性の除去
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 331 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:12:41 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * DOMによる属性の除去クラス
 *
 * @category        Request
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 331 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:12:41 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Request_StripAttributes_DOM
{
    /**
     * 許可するタグの要素
     * @var array
     */
    private $_allowables = array();

    /**
     * Scriptタグの消去
     * @var array
     */
    private $_stripscript = false;

    /**
     * 解析結果
     * @var string
     */
    private $_parsed = '';

    /**
     * 解析結果
     * @var string
     */
    private $_closed = '';

    /**
     * SimpleXMLElement
     * @var object
     */
    private $_objdom = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $filename テンプレートファイル名
     * @return void
     */
    public function __construct()
    {
        $this->_objdom = new DOMDocument('1.0', 'utf-8');
    }

    /**
     * 許可するタグの要素を設定
     *
     * @access public
     * @param string $allowable
     * @return void
     */
    public function setAllowable ($allowable) 
    {
        $this->_allowables = explode(',', $allowable);
    }

    /**
     * Scriptタグの消去設定
     *
     * @access public
     * @param boolean $stripscript
     * @return void
     */
    public function setStripScript ($stripscript) 
    {
        $this->_stripscript = $stripscript;
    }

    /**
     * 解析結果の取得
     *
     * @access public
     * @return string
     */
    public function getParsed ($source) 
    {
        $pos = strpos($source, '<html><body>');
        if ($pos === false){
            $source = '<html><meta http-equiv="Content-Type" '.
                      'content="text/html; charset=utf-8" /><body>'.
                      $source.'</body></html>';
        }

        try {
            $this->_objdom->loadHTML($source);
            $this->_objdom->formatOutput       = false;
            $this->_objdom->resolveExternals   = true;
            $this->_objdom->substituteEntities = false;
        } catch (DOMException $exception){
            $message = $exception->getMessage();
        } // try

        $this->_stripScript();
        $this->_stripAttributes();

        $string = $this->_objdom->saveHTML();
        if ($pos === false){
            $pos    = strpos($string, '<body>');
            $string = substr($string, $pos + 6);
            $string = str_replace('</body>', '', $string);
            $string = str_replace('</html>', '', $string);
        }

        return $string;
    }

    /**
     * タグ要素の消去
     *
     * @access public
     * @return void
     */
    private function _stripAttributes()
    {
        /* 全タグの要素を取得 */
        $nodes = $this->_objdom->getElementsByTagName('*');
        for ($row=0; $row<$nodes->length; $row++ ) {
            if($nodes->item($row)->hasAttributes()){
                if(!is_null($nodes->item($row)->attributes)){
                    $removes = array();
                    foreach ($nodes->item($row)->attributes as $attr) {
                        if (!in_array($attr->name, $allowables)){
                            $removes[] = $attr->name;
                        }
                    }

                    foreach ($removes as $remove) {
                        $nodes->item($row)->removeAttribute($remove);
                    }
                }
            }
        } // for ($row=0; $row<$nodes->length; $row++ )
    }

    /**
     * Scriptタグの消去
     *
     * @access public
     * @return void
     */
    private function _stripScript()
    {
        if (!$this->_stripscript){
            return ;
        }

        $nodes = $this->_objdom->getElementsByTagName('script');
        for ($row=0; $row<$nodes->length; $row++) {
            $parent = $nodes->item($row)->parentNode;
            $parent->removeChild($nodes->item($row));
        }
    }
} // Request_StripAttributes_DOM
?>
