<?php
/* SVN FILE: $Id: loader.php 453 2008-05-22 09:21:33Z bb_yujiro $ */
/**
 * Pluginの読み込み
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2008 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 453 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:21:33 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * loadPluginクラス
 *
 * @category        Plugin
 * @package         hitSuji
 * @copyright       Copyright (c) 2008 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 453 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:21:33 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class loadPlugin
{
    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * 読み込み済みプラグイン
     * @var array
     */
    private $_loaded = null;

    /**
     * 読み込みプラグイン
     * @var array
     */
    private $_loads = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    private function __construct($loads)
    {
        $this->_loads = $loads;
        foreach ($this->_loads as $class => $plugin){
            if (include PLUGIN_DIR.$plugin){
                $this->_loaded[$class] = new $class();
            } else {
                throw new Exception ('Driver not found');
            }
        }
    }

    /**
     * 実行処理スタテック版
     *
     * @access public
     * @return object
     *
     * Example:
     * <code>
     * loadPlugin::exec()->editorAddButtonJs();
     * </code>
     *
     */
    public static function exec()
    {
        if (!isset(self::$_instance)) {
            $classname = __CLASS__;
            self::$_instance = new $classname($GLOBALS['LOADS_PLUGIN']);
        }
        return self::$_instance;
    }

    /**
     * プラグインの読み込み
     *
     * @access public
     * @param string $name
     * @return void
     *
     * Example:
     * <code>
     * loadPlugin::callFunc('function'[, parameter]);
     * </code>
     *
     */
    public static function callFunc($name)
    {
        $args = func_get_args();
        $pos  = strpos($name, '_');
        $dir  = substr($name, 0, $pos);
        $file = substr($name, $pos + 1);

        include_once PLUGIN_DIR.$dir.DS.$file.'.php';

        $function = array_shift($args);
        call_user_func_array($function, $args);
    }

    /**
     * リッチエディターボタン追加用JavaScript
     *
     * @access public
     * @return string
     */
    public function editorAddButtonJs()
    {
        foreach ($this->_loads as $class => $plugin){
            $this->_loaded[$class]->editorAddButtonJs();
        }
    }

    /**
     * リッチエディター用CSS
     *
     * @access public
     * @return string
     */
    public function editorCss()
    {
        foreach ($this->_loads as $class => $plugin){
            $this->_loaded[$class]->editorCss();
        }
    }

    /**
     * リッチエディター用直JavaScript
     *
     * @access public
     * @return string
     */
    public function editorJavaScript()
    {
        foreach ($this->_loads as $class => $plugin){
            $this->_loaded[$class]->editorJavaScript();
        }
    }

    /**
     * リッチエディター出力用エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function outputEditorBody($string)
    {
        foreach ($this->_loads as $class => $plugin){
            $string = $this->_loaded[$class]->outputEditorBody($string);
        }
        return $string;
    }

    /**
     * リッチエディター出力用エフェクト
     *
     * @access public
     * @return void
     */
    public function outputEditorLoadJs()
    {
        foreach ($this->_loads as $class => $plugin){
            $this->_loaded[$class]->outputEditorLoadJs();
        }
    }

    /**
     * 出力時へのフィルター
     *
     * @access public
     * @parmas string $value
     * @parmas string $mime_type
     * @return string
     */
    public function outputFilter($body, $mime_type)
    {
        foreach ($this->_loads as $class => $plugin){
            $body = $this->_loaded[$class]->outputFilter($body, $mime_type);
        }
        return $body;
    }

    /**
     * HTML BODY出力用エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function outputHtmlBody($string)
    {
        foreach ($this->_loads as $class => $plugin){
            $string = $this->_loaded[$class]->outputHtmlBody($string);
        }
        return $string;
    }

    /**
     * 入力値へのフィルター
     *
     * @access public
     * @parmas mixed $value
     * @parmas string $type
     * @return mixed
     */
    public function requestFilter($value, $type)
    {
        foreach ($this->_loads as $class => $plugin){
            $value = $this->_loaded[$class]->requestFilter($value, $type);
        }
        return $value;
    }

    /**
     * HTML BODY入力用エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function requestHtmlBody($string)
    {
        foreach ($this->_loads as $class => $plugin){
            $string = $this->_loaded[$class]->requestHtmlBody($string);
        }
        return $string;
    }
} // loadPlugin
?>
