<?php
/* SVN FILE: $Id: File.php 401 2008-05-17 03:45:15Z bb_yujiro $ */
/**
 * ファイル形式で保存
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 401 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-17 12:45:15 +0900 (土, 17 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * BLOB_Fileクラス
 *
 * @category        Binary Large OBject
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 401 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-17 12:45:15 +0900 (土, 17 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class BLOB_File extends BLOB_Common
{
    /**
     * 基礎ディレクトリ
     * @var string
     */
    protected $base_dir = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $dir
     * @return void
     */
    public function __construct($dir='')
    {
        $this->base_dir = $dir;
    }

    /**
     * ファイル名の実態を取得
     *
     * @access public
     * @return binary
     */
    public function getOrigin($filename)
    {
        $filename = str_replace('archives.php?', 'archives', $filename);
        $files = explode('/',$filename);

        $second = $this->_getSecond($files[2]);
        
        $origin = $files[0].DS.$files[1].DS.
                    $second.DS.$files[2].DS.
                    $files[3].DS.$files[4];
        return $this->base_dir.$origin;
    }

    /**
     * 取得キーの変更
     *
     * @access public
     * @param string $oldname
     * @param string $newname
     * @return boolean
     */
    public function rename($oldname, $newname)
    {
        $old_origin = $this->getOrigin($oldname);
        if (!file_exists($old_origin)){
            return false;
        }
        $new_origin = $this->getOrigin($newname);
        
        return rename($old_origin,$new_origin);
    }

    /**
     * 対象データのコピー
     *
     * @access public
     * @param string $source
     * @param string $dest
     * @return boolean
     */
    public function copy($source, $dest)
    {
        $source_origin = $this->getOrigin($source);
        if (!file_exists($source_origin)){
            return false;
        }
        $dest_origin = $this->getOrigin($dest);
        
        return copy($source_origin, $dest_origin);
    }

    /**
     * 対象データの保存
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    public function save($filename)
    {
        $this->origin = $this->getOrigin($filename);

        /* ファイルの中身を取得 */
        $handle = fopen($this->origin, 'wb');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $this->buffer);
        fclose($handle);
        
        return $result;
    }

    /**
     * 対象データの読み込み
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    public function load($filename)
    {
        $this->origin = $this->getOrigin($filename);
        $this->readfile($this->origin);
        $this->name = basename($filename);

        return true;
    }

    /**
     * ファイル削除処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    public function unlink($filename)
    {
        $this->origin = $this->getOrigin($filename);
        if (!file_exists($this->origin)){
            return false;
        }
        return unlink($origin);
    }

    /**
     * アーカイブディレクトリ削除処理
     *
     * @access private
     * @param array $params
     * @return boolean
     */
    public function delete($params)
    {
        extract($params);
        $wheres = array();
        if (!empty($uid)){
            $dir = MEMBER_DIR.$this->_getSecond($uid).DS.$uid.DS;
            return $this->_rmOpRF($dir);
        } elseif (!empty($gid)){
            $dir = COMMUNITY_DIR.$this->_getSecond($gid).DS.$gid.DS;
            return $this->_rmOpRF($dir);
        }
        return false;
    }

    /**
     * 所持バッファーの取得
     *
     * @access public
     * @return binary
     */
    private function _getSecond($id)
    {
        $second = intval($id / 1000);
        return $second.'000';
    }

    /**
     * 連続削除処理
     * http://go-pear.org/
     *
     * @access private
     * @param string $path
     * @return boolean
     */
    private function _rmOpRF($path)
    {
        if (!file_exists($path)){
            return false;
        }

        if (@is_dir($path) && is_writable($path)) {
            $dp = opendir($path);
            while ($ent = readdir($dp)) {
                if ($ent == '.' || $ent == '..') {
                    continue;
                }
                $file = $path . DS . $ent;
                if (@is_dir($file)) {
                    $this->_rmOpRF($file);
                } elseif (is_writable($file)) {
                    unlink($file);
                } else {
                    error_log($file . "is not writable and cannot be removed.Please fix the permission or select a new path.\n", 3, ERROR_LOG_FILE);
                }
            }
            closedir($dp);
            return rmdir($path);
        } else {
            return @unlink($path);
        }
    }
} // BLOB_fileの終了
?>
