<?php
/* SVN FILE: $Id: Box.php 244 2008-05-03 20:29:44Z bb_yujiro $ */
/**
 * メールボックスからのインポート
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 244 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-04 05:29:44 +0900 (日, 04 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * BLOB_Attach_Boxクラス
 *
 * @category        Binary Large OBject
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 244 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-04 05:29:44 +0900 (日, 04 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class BLOB_Attach_Box extends BLOB_Attach_Common
{
    /**
     * ディレクトリ
     * @var string
     */
    private $_dir = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $dsn
     * @return void
     */
    public function __construct()
    {
        parent::__construct();

        $this->_dir = MAIL_BOX_DIR;
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        if (!is_dir($this->_dir)){
            return false;
        }
        $handle  = opendir($this->_dir);
        if (!is_resource($handle)) {
            return false;
        }

        while (false !== ($file = readdir($handle))) {
            if ($file != '.' && $file != '..') {
                if (!is_dir($this->_dir.$file)){
                    // メール中身を取得
                    $msg = file_get_contents($this->_dir.$file);
                    if ($msg !== false){
                        // メールソースの解析
                        $this->parse($msg);
                        unlink($this->_dir.$file);
                    }
                } // if (!is_dir($this->_dir.$file))
            } // if ($file != '.' && $file != '..')
        } // while (false !== ($filename = readdir($dh)))
        closedir($handle);
    }

    /**
     * メールボックスパスの指定
     *
     * @access public
     * @param string $dir
     * @return void
     **/
    public function setDir($dir)
    {
        $this->_dir = $dir;
    }
} // BLOB_Attach_Boxの終了
?>