<?php
/* SVN FILE: $Id: Attach.php 304 2008-05-09 22:50:06Z bb_yujiro $ */
/**
 * メール添付インポート
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 304 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:50:06 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktBlob/Attach/Common.php';

/**
 * BLOB_Attachクラス
 *
 * @category        Binary Large OBject
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 304 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:50:06 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class BLOB_Attach
{
    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @return PDO object
     *
     * BLOB_Attach::exec()->execute();
     *
     */
    public static function exec()
    {
        if (isset(self::$_instance)) {
            return self::$_instance;
        }
        return self::getInstance();
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return object __CLASS__
     */
    public static function getInstance($driver=ATTACH_DRIVER)
    {
        if (!isset(self::$_instance)) {
            self::$_instance = self::factory($driver);
        }

        return self::$_instance;
    }

    /**
     * Factory メソッド
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return void
     */
    public static function factory($driver=ATTACH_DRIVER)
    {
        if (include LIB_DIR.'rktBlob/Attach/'.$driver.'.php') {
            $classname = 'BLOB_Attach_'.$driver;
            return new $classname($driver);
        } else {
            throw new Exception ('Driver not found');
        }
    }
} // BLOB_Attachの終了
?>