<?php
/* SVN FILE: $Id: SerialNumber.php 480 2008-05-23 16:37:46Z bb_yujiro $ */
/**
 * SerialNumber認証
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 480 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:37:46 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * SerialNumber認証クラス
 *
 * @category        Authentication
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 480 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:37:46 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Auth_AutoLogin_SerialNumber
{
    /**
     * ログインキー
     * @var string
     */
    private $_loginkey = null;

    /**
     * DBオブジェクト
     * @var object
     */
    private $_objdb = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        $this->_setLoginKey();
        $this->_objdb = RKT_DB::getInstance();
    }

    /**
     * ユーザーエージェントIDによる自動ログイン
     *
     * @access public
     */
    public function autoLogin()
    {
        if (empty($_REQUEST[Auth_AutoLogin::POST_SERIAL])){
            return false;
        }
        if (empty($this->_loginkey)){
            return false;
        }

        $sql = 'SELECT ref_account FROM '.DB_PREFIX.'act_autologin '.
               'WHERE loginkey = :loginkey';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(array(':loginkey'=> $this->_loginkey));
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        
        /* 取得結果の判定 */
        if (empty($result['ref_account'])){
            RKT_account::exec()->accountDestroy();
            return false;
        }

        /* アカウント情報を取得できたか */
        if (!RKT_account::exec()->setAccount($result['ref_account'])){
            RKT_account::exec()->accountDestroy();
            return false;
        }
        /* セッションIDを書き換える*/
        session_regenerate_id(true);

        return true;
    }

    /**
     * 自動ログインの設定
     *
     * @access public
     * @return boolean
     */
    public function setAutoLogin()
    {
        $sql = 'SELECT id FROM '.DB_PREFIX.'act_autologin '.
               'WHERE loginkey = :loginkey';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(array(':loginkey'=> $this->_loginkey));
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();

        if ($this->_manip($result['id'])){
            $_SESSION['autologin'] = true;
        } else {
            $_SESSION['autologin'] = false;
        }
        return $_SESSION['autologin'];
    }

    /**
     * 自動ログインテーブルの書き換え
     *
     * @access private
     * @return array ユーザーリクエスト
     */
    private function _manip($id)
    {
        $modified    = date('Y-m-d H:i:s');
        $ref_account = RKT_account::exec()->getAccountID();
        if (empty($id)){
            $sql = 'INSERT INTO '.DB_PREFIX.'act_autologin('.
                        ' modified, ref_account, loginkey) VALUES ('.
                        ':modified,:ref_account,:loginkey)';
            $stmt = $this->_objdb->prepare($sql); 
            $stmt->bindParam(':modified',    $modified,        PDO::PARAM_STR);
            $stmt->bindParam(':ref_account', $ref_account,     PDO::PARAM_INT);
            $stmt->bindParam(':loginkey',    $this->_loginkey, PDO::PARAM_STR);
        } else {
            $sql = 'UPDATE '.DB_PREFIX.'act_autologin '.
                   'SET modified = :modified,ref_account = :ref_account,'.
                   'loginkey = :loginkey WHERE id = :id';
            $stmt = $this->_objdb->prepare($sql);
            $stmt->bindParam(':modified',    $modified,        PDO::PARAM_STR);
            $stmt->bindParam(':ref_account', $ref_account,     PDO::PARAM_INT);
            $stmt->bindParam(':loginkey',    $this->_loginkey, PDO::PARAM_STR);
            $stmt->bindParam(':id',          $id,              PDO::PARAM_INT);
        }
        return $stmt->execute();
    }    

    /**
     * ログインキー設定
     *
     * @access private
     * @return void
     */
    private function _setLoginKey()
    {
        $agent  = Net_UserAgent_Mobile::singleton();
        $number = $agent->getSerialNumber();
        if (empty($number)){
            $this->_loginkey = '';
            return ;
        }
        $name = $agent->getCarrierLongName();
        $seed = $number.$name;

        $this->_loginkey = RKT_Crypt::getHashed($seed);
    }
} // Auth_AutoLogin_SerialNumber
?>