<?php
/* SVN FILE: $Id: AutoLogin.php 480 2008-05-23 16:37:46Z bb_yujiro $ */
/**
 * 自動ログイン処理
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 480 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:37:46 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 自動ログインクラス
 *
 * @category        Authentication
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 480 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 01:37:46 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Auth_AutoLogin
{
    /**
     * シリアル送信可判定用
     * @const string
     */
    const POST_SERIAL = 'post_serial';

    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @param string $driver
     * @return object __CLASS__
     *
     * Auth_AutoLogin::exec()->getAccount();
     */
    public static function exec()
    {
        if (!isset(self::$_instance)) {
            if (SID === ''){
                $driver = 'Cookie';
            } else {
                $driver = 'SerialNumber';
            }
            self::$_instance = self::factory($driver);
        }

        return self::$_instance;
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @param string $driver
     * @return object __CLASS__
     */
    public static function getInstance($driver)
    {
        if (!isset(self::$_instance)) {
            self::$_instance = self::factory($driver);
        }

        return self::$_instance;
    }

    /**
     * Factory メソッド
     *
     * @access public
     * @param string $driver
     * @return void
     */
    public static function factory($driver)
    {
        if (include LIB_DIR.'rktAuth/AutoLogin/'.$driver.'.php') {
            $classname = 'Auth_AutoLogin_'.$driver;
            return new $classname;
        } else {
            throw new Exception ('Driver not found');
        }
    }
} // Auth_autoLogin
?>
