<?php
/* SVN FILE: $Id: thumbnail.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * バイナリデータの出力
 *
 * PHP versions 5
 *
 *      rktFW : Development Framework <http://rakuto.net/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         rktFW
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/* =-=- モジュール等の読み込み -=-= */
require '../config.php';
require LIB_DIR.'rkt_blob.php';

/**
 * 実行関数
 *
 * @access public
 * @return void
 */
function __main()
{
    $self = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
    $pos = strpos($self, '&');
    if (!empty($pos)){
        $self = substr($self, 0, $pos);
    }
    $filename = ACTION_ARCHIVES.$self;

    /* BLOB管理オブジェクトの生成 */
    $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM); 
    $objblb->load($filename);


    /* 画像サイズ変更 */
    if (isset($_GET['width']) && isset($_GET['height'])){
        $width  = intval($_GET['width']);
        $height = intval($_GET['height']);

        /* ファイルの種類が画像か判定 */
        $mime_type = $objblb->getMimeType();
        if (preg_match('/image/i', $mime_type)){
            include LIB_DIR.'rkt_image.php';

            $objimg = RKT_image::factory(IMAGE_DRIVER);
            $objimg->setBinary($objblb->getBuffer(), $objblb->getExtension());
            $objimg->resize($width, $height);
            $objimg->output();
            exit();
        }
    } // if (isset($_REQUEST['width']) && isset($_REQUEST['height']))

    $objblb->output();
    exit();
}

__main();    // 実行関数
?>