<?php
/* SVN FILE: $Id: review.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * バイナリデータの出力
 *
 * PHP versions 5
 *
 *      rktFW : Development Framework <http://rakuto.net/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         rktFW
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/* =-=- モジュール等の読み込み -=-= */
require '../config.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_image.php';

/**
 * Amazon表示
 *
 * @access public
 * @param array $arg
 * @return void
 */
function _amazon($arg)
{
    if (empty($arg[2])){
        return ;
    }
    if (empty($arg[3])){
        $item_code = substr($arg[2], 0, -4);
        $size      = 'large';
    } else {
        $item_code = substr($arg[3], 0, -4);
        $size      = is_numeric($arg[2])? $arg[2]:160;
        $size      = ($size >= 160)? 'large':'small';
    }

    include LIB_DIR.'PEAR/Services/AmazonECS4.php';
    $amazon = new Services_AmazonECS4(AMAZON_TOKEN, AMAZON_ASSOCIATEID);
    $options = array(
        'ResponseGroup'=> 'Images'
    );
    $result = $amazon->ItemLookup($item_code, $options);
    if (PEAR::isError($result)) {
        return ;
    }
    if (empty($result['Item'][0])){
        return ;
    }
    $item = $result['Item'][0];
    $imgs = array(
        'small'=> empty($item['SmallImage']['URL'])?  BASE_URL.NOPHOTO_SMALL:$item['SmallImage']['URL'],
        'large'=> empty($item['MediumImage']['URL'])? BASE_URL.NOPHOTO_LARGE:$item['MediumImage']['URL']
    );

    $buffer = file_get_contents($imgs[$size]);
    
    header('Content-Type: image/jpeg');
    header('Content-Length: '.strlen($buffer));
    header('Content-disposition: inline; filename='.$item_code.'.jpg');
    print ($buffer);
}

/**
 * ぐるなび表示
 *
 * @access public
 * @param array $arg
 * @return void
 */
function _gnavi($arg)
{
    if (empty($arg[2])){
        return ;
    }
    if (empty($arg[3])){
        $item_code = substr($arg[2], 0, -4);
        $size      = 400;
    } else {
        $item_code = substr($arg[3], 0, -4);
        $size      = is_numeric($arg[2])? $arg[2]:400;
    }
    
    include LIB_DIR.'PEAR/Services/Gnavi.php';
    $gnavi = new Services_Gnavi(GNAVI_ACCESS_KEY);
    $options = array(
        'id'=> $item_code
    );
    $gnavi->searchRestaurant($options);
    $result = $gnavi->getResult();
    if (PEAR::isError($result)) {
        return ;
    }
    if (empty($result['rest']['image_url']['shop_image1'])){
        return ;
    }
    $large_img = empty($result['rest']['image_url']['shop_image1'])? 
                    BASE_URL.NOPHOTO_LARGE : $result['rest']['image_url']['shop_image1'];
    $buffer = file_get_contents($large_img);

    $objimg = RKT_image::factory(IMAGE_DRIVER);
    $objimg->setBinary($buffer, 'jpg');
    $objimg->resize($size, 800);
    $objimg->output();
}

/**
 * 個人星表示
 *
 * @access public
 * @param array $arg
 * @return void
 */
function _rating($arg)
{
    if (empty($arg[2]) && empty($arg[3])){
        return ;
    }
    $item_code = substr($arg[3], 0, -4);
    $condition = array(
        'item_code'=>   $item_code,
        'ref_account'=> $arg[2],
    );
    $rating = RKT_Db::getRow('rev_rating', $condition);
    $point = empty($rating['point'])? 0:$rating['point'];
    $name = sprintf('%02d.gif', $point);
    $filename = RESOURCE_DIR.'img'.DS.'common'.DS.'star'.$name;

    $objimg = RKT_image::factory(IMAGE_DRIVER);
    $objimg->readImage($filename);
    $objimg->output();
}

/**
 * 星表示
 *
 * @access public
 * @param array $arg
 * @return void
 */
function _star($arg)
{
    if (empty($arg[2])){
        return ;
    }
    $item_code = substr($arg[2], 0, -4);
    $condition = array(
        'item_code'=>   $item_code,
    );
    $review = RKT_Db::getRow('rev_review', $condition);
    if (empty($review['total'])){
        $point = 0;
    } else {
        $point = intval($review['total'] / $review['post']);
    }
    $name = sprintf('%02d.gif', $point);
    $filename = RESOURCE_DIR.'img'.DS.'common'.DS.'star'.$name;

    $objimg = RKT_image::factory(IMAGE_DRIVER);
    $objimg->readImage($filename);
    $objimg->output();
}

/**
 * 実行関数
 *
 * @access public
 * @return void
 */
function __main()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
    $path_args = explode('/', $path_info);

    $service = empty($path_args[1])? 'amazon':$path_args[1];
    $names = array(
        'amazon'=> true,
        'gnavi'=>  true,
        'rating'=> true,
        'star'=>   true,
    );
    $service = empty($names[$service])? 'amazon':$service;


    $func = '_'.$service;
    call_user_func($func, $path_args);
}

__main();    // 実行関数
?>