<?php
/* SVN FILE: $Id: frameBg.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * s
 *
 * PHP versions 4 and 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 摜̏o
 *
 * @access public
 * @param string $color
 * @return void
 */
function imagePngFrameBg ($color)
{
    $body = getColors($color);
    $back = colorsMultiply($body, RATE_BACK);

    $image = imageCreateFromPNG(dirname(__FILE__).'/../source/frameBg.png');

    $range = 48;
    $rate = array (
        'r'=> abs(($body['r'] - $back['r']) / $range),
        'g'=> abs(($body['g'] - $back['g']) / $range),
        'b'=> abs(($body['b'] - $back['b']) / $range),
    );

    $row   = 0;
    $red   = colorInt($back['r'] - ($row * $rate['r']));
    $green = colorInt($back['g'] - ($row * $rate['g']));
    $blue  = colorInt($back['b'] - ($row * $rate['b']));
    imageColorSet($image, 0, $red, $green, $blue);

    $row   = 1;
    $red   = colorInt($back['r'] - ($row * $rate['r']));
    $green = colorInt($back['g'] - ($row * $rate['g']));
    $blue  = colorInt($back['b'] - ($row * $rate['b']));
    imageColorSet($image, 1, $red, $green, $blue);

    $row   = 5;
    $red   = colorInt($back['r'] - ($row * $rate['r']));
    $green = colorInt($back['g'] - ($row * $rate['g']));
    $blue  = colorInt($back['b'] - ($row * $rate['b']));
    imageColorSet($image, 2, $red, $green, $blue);

    $row   = 1;
    $red   = colorInt($back['r'] - ($row * $rate['r']));
    $green = colorInt($back['g'] - ($row * $rate['g']));
    $blue  = colorInt($back['b'] - ($row * $rate['b']));
    imageColorSet($image, 3, $red, $green, $blue);


    $row   = 8;
    $red   = colorInt($body['r'] - ($row * RATE_FRAME_VERGE));
    $green = colorInt($body['g'] - ($row * RATE_FRAME_VERGE));
    $blue  = colorInt($body['b'] - ($row * RATE_FRAME_VERGE));
    imageColorSet($image, 4, $red, $green, $blue);

    $row   = 0;
    $red   = colorInt($body['r'] - ($row * RATE_FRAME_VERGE));
    $green = colorInt($body['g'] - ($row * RATE_FRAME_VERGE));
    $blue  = colorInt($body['b'] - ($row * RATE_FRAME_VERGE));
    imageColorSet($image, 5, $red, $green, $blue);

    $row   = 10;
    $red   = colorInt($body['r'] - ($row * RATE_FRAME_VERGE));
    $green = colorInt($body['g'] - ($row * RATE_FRAME_VERGE));
    $blue  = colorInt($body['b'] - ($row * RATE_FRAME_VERGE));
    imageColorSet($image, 6, $red, $green, $blue);

    imagePNG($image);
    imageDestroy($image);
}
?>