<?php
/* SVN FILE: $Id: css.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * 実行処理
 *
 * PHP versions 4 and 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * CSSの出力
 *
 * @access public
 * @param integer $id
 * @param string $text
 * @param string $bold
 * @param string $border
 * @return void
 */
function cssTheme ($id, $text, $bold, $border)
{
?>
@charset "UTF-8";

/**************************/
/* ボディー */
BODY	{
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/bg.png);
}
H2  {
	color: #<?php print($bold); ?>;
}
STRONG  {
	color: #<?php print($bold); ?>;
}
LABEL   {
	color: #<?php print($bold); ?>;
}
.column	{
	color: #<?php print($bold); ?>;
	font-weight: bold;
}
/**************************/
/* ヘッダー */
#frameHeader {
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/headerBg.png);
	background-repeat: repeat-x;
}
#header {
	color: black;
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/headerBg.png);
	background-repeat: repeat-x;
}
#photoHeader {
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/photoBg.png);
	background-repeat: no-repeat;
}
#menuHeader {
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/menubarBg.png);
	background-position: center bottom;
	background-repeat: no-repeat;
}

/**************************/
/* 骨格 */
#frame {
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/frameBg.png);
	background-repeat: repeat-y;
}
#footer {
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/footerBg.png);
	background-repeat: repeat-x;
	background-position: top center;
}
#copyright {
	color: #<?php print($bold); ?>;
}
/**************************/
/* メニューバー */
.btmmenubar {
	background-image: url(<?php print(BASE_URL.ARCHIVES_THEME_PATH. $id); ?>/btmMenuBg.png);    
}

/**************************/
/* _____ テーブル _____ */
TABLE.calendar	{
	width: 100%;
	color: #<?php print($text); ?>;
	border: 1px solid #<?php print($border); ?>;
	border-collapse: collapse;
	margin: 0 auto;
	padding: 0px;
	font-size:0.88em;
}
TABLE.calendar TD.red	{
	width:14%;
	background-color: #FFEEDD;
	border: 1px solid #<?php print($border); ?>;
	text-align:left;
	vertical-align: top;
}
TABLE.calendar TD.white	{
	width:14%;
	background-color: white;
	border: 1px solid #<?php print($border); ?>;
	text-align:left;
	vertical-align: top;
}
TABLE.calendar TD.blue	{
	width:14%;
	background-color: #DDEEFF;
	border: 1px solid #<?php print($border); ?>;
	text-align:left;
	vertical-align: top;
}
/**************************/
<?php
}
?>