<?php
/* SVN FILE: $Id: capt.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * s
 *
 * PHP versions 4 and 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 摜̏o
 *
 * @access public
 * @param string $color
 * @return void
 */
function imagePngCapt ($color)
{
    $body = getColors($color);
    $back = colorsMultiply($body, RATE_BACK);

    $image = imageCreateFromPNG(dirname(__FILE__).'/../source/capt.png');

    $range = 45;
    $rate = array (
        'r'=> abs(($back['r'] - $body['r']) / $range),
        'g'=> abs(($back['g'] - $body['g']) / $range),
        'b'=> abs(($back['b'] - $body['b']) / $range),
    );

    imageColorSet($image,  1, $body['r'], $body['g'], $body['b']);
    imageColorSet($image, 37, $body['r'], $body['g'], $body['b']);

    for ($row=0; $row<46; $row++) {
        $index = $row + 45;
        $red   = colorInt($body['r'] + ($row * $rate['r']));
        $green = colorInt($body['g'] + ($row * $rate['g']));
        $blue  = colorInt($body['b'] + ($row * $rate['b']));

        imageColorSet($image, $index, $red, $green, $blue);
    }

    imagePNG($image);
    imageDestroy($image);
}
?>