/* SVN FILE: $Id: tile.js 451 2008-05-22 09:20:24Z bb_yujiro $ */
/**
 * 近況の表示
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 451 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:20:24 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

var viewTile = function(container, page, size, baseUrl, linkUrl, getUrl){
	var fPage  = YAHOO.util.Dom.get(container);
	var uTile  = document.createElement('ul');
	uTile.setAttribute('class', 'horizontal sideList');
	uTile.setAttribute('className', 'horizontal sideList');

	this.fOffset = 1;
	this.lPage   = document.createElement('li');
	this.createHeader = function (){
		var ul  = document.createElement('ul');
		var li  = document.createElement('li');
		var img = document.createElement('img');

		ul.setAttribute('class', 'horizontal sideList');
		ul.setAttribute('className', 'horizontal sideList');
		li.style.width           = '52px';
		li.style.backgroundColor = 'white';
		li.style.textAlign       = 'center';
		li.style.cursor          = 'pointer';
		YAHOO.util.Event.addListener(li, 'click', this.prevTile, this);
		img.src                  = baseUrl + 'resource/img/icons/resultset_previous.gif';
		li.appendChild(img);
		ul.appendChild(li);

		this.lPage.style.width           = '82px';
		this.lPage.style.backgroundColor = 'white';
		this.lPage.style.textAlign       = 'center';
		this.lPage.appendChild(document.createTextNode('1/' + page));
		ul.appendChild(this.lPage);

		li  = document.createElement('li');
		img = document.createElement('img');
		li.style.width           = '52px';
		li.style.backgroundColor = 'white';
		li.style.textAlign       = 'center';
		li.style.cursor          = 'pointer';
		YAHOO.util.Event.addListener(li, 'click', this.nextTile, this);
		img.src                  = baseUrl + 'resource/img/icons/resultset_next.gif';
		li.appendChild(img);
		ul.appendChild(li);

		fPage.appendChild(ul);
	};
	this.nextTile = function (e, obj){
		obj.fOffset += 1;
		if (obj.fOffset > page){
			obj.fOffset = 1;
		}
		obj.setTile();
		obj.lPage.innerHTML = obj.fOffset + '/' + page;
	};
	this.prevTile = function (e, obj){
		obj.fOffset -= 1;
		if (obj.fOffset <= 0){
			obj.fOffset = page;
		}
		obj.setTile();
		obj.lPage.innerHTML = obj.fOffset + '/' + page;
	};
	this.setTile = function (){
		var callback =
		{
			success: function(o) {
				var list = YAHOO.lang.JSON.parse (o.responseText);

				var li  = null;
				var anc = null;
				var img = null;
				var br  = null;

				while (uTile.lastChild){
					uTile.removeChild(uTile.lastChild); 
				}

				for (row=0; row<list.length; row++){
					li  = document.createElement('li');
					anc = document.createElement('a');
					img = document.createElement('img');

					li.style.width  = '93px';
					li.style.height = '80px';
					li.style.textAlign = 'center';
					li.style.backgroundColor = 'white';
					anc.setAttribute('href', linkUrl + list[row].id + '/');
					anc.setAttribute('title', list[row].name);
					img.src = baseUrl + list[row].src;
					img.style.marginTop = ((size - list[row].height) / 2) + 'px';

					anc.appendChild(img);
					li.appendChild(anc);
					uTile.appendChild(li);
				}

				if (row % 2){
					li  = document.createElement('li');

					li.style.width  = '93px';
					li.style.height = '80px';
					li.style.backgroundColor = 'white';

					uTile.appendChild(li);
				}

				fPage.appendChild(uTile);
			},
			failure: function(o) {
			},
			argument: []
		};
		YAHOO.util.Connect.initHeader('Cookie', document.cookie);
		YAHOO.util.Connect.asyncRequest('GET',  getUrl + 'page=' + this.fOffset, callback);
	};
}
