/* SVN FILE: $Id: summary.js 277 2008-05-07 22:16:49Z bb_yujiro $ */
/**
 * サマリーの表示
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 277 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:16:49 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

function Summary(container, url, icon, key, sid) {
	var callback =
	{
		success: function(o) {
			var summary = YAHOO.lang.JSON.parse (o.responseText);

			var ul  = YAHOO.util.Dom.get(container);
			var li  = null;
			var anc = null;
			var img = null;

			for (row=0; row<summary.length; row++){
				li  = document.createElement('li');
				anc = document.createElement('a');
				img = document.createElement('img');

				anc.setAttribute('href', summary[row].link);
				img.src = icon;

				anc.appendChild(img);
				anc.appendChild(document.createTextNode(summary[row].title));
				li.appendChild(anc);
				if (summary[row].creator){
					li.appendChild(document.createTextNode('(' + summary[row].creator + ')'));
				}
				ul.appendChild(li);
			}
		},
		failure: function(o) {
		},
		argument: []
	}
	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('GET',  url, callback);
}
