/* SVN FILE: $Id: recent.js 362 2008-05-13 04:23:43Z bb_yujiro $ */
/**
 * 近況の表示
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 362 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-13 13:23:43 +0900 (火, 13 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

function setRecent(recentContainer, recentUrl, iconPath){
	var icon = null;
	if (iconPath != null){
		if (recentUrl.indexOf("blog", 0) >= 0){
			icon = iconPath + "book_open.gif";
		} else if (recentUrl.indexOf("comment", 0) >= 0){
			icon = iconPath + "comment.gif";
		} else if (recentUrl.indexOf("event", 0) >= 0){
			icon = iconPath + "event.gif";
		} else {
			icon = iconPath + "bulletin.gif";
		}
	}

	var callback =
	{
		success: function(o) {
			var summary = YAHOO.lang.JSON.parse (o.responseText);

			var vi  = YAHOO.util.Dom.get(recentContainer);
			var ul  = document.createElement('ul');
			var li  = null;
			var anc = null;
			var img = null;

			for (row=0; row<summary.length; row++){
				li  = document.createElement('li');
				anc = document.createElement('a');
				img = document.createElement('img');

				anc.setAttribute('href', summary[row].link);
				img.src = icon;

				anc.appendChild(img);
				anc.appendChild(document.createTextNode(summary[row].title));
				li.appendChild(anc);
				if (summary[row].creator){
					li.appendChild(document.createTextNode('(' + summary[row].creator + ')'));
				}
				ul.appendChild(li);
			}
			vi.appendChild(ul);
			vi.style.textAlign = 'left';
		},
		failure: function(o) {
		},
		argument: []
	}
	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('GET',  recentUrl, callback);
}