<?php
/* SVN FILE: $Id: daily.php 383 2008-05-15 02:40:38Z bb_yujiro $ */
/**
 * 日次処理：デイリー配信
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         hitSuji
 * @version         $Revision: 383 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:40:38 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require dirname(__FILE__).'/../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_exception.php';
require LIB_DIR.'rkt_crypt.php';

require LIB_DIR.'rkt_message.php';

/**
 * 日次処理：デイリー配信クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package SOL_account
 * @access public
 * @version 1.1
 */
class alertDaily
{
    /**
     * 曜日番号
     * @var integer
     */
    private $_day = 0;

    /**
     * 今日の日付
     * @var string
     */
    private $_now = '';

    /**
     * ニュースがあるか
     * @var boolean
     */
    private $_news = false;

    /**
     * 情報取得日数限度格納
     * @var array
     */
    private $_limit = array();

    /**
     * 取得範囲始日
     * @var string
     */
    private $_rangeStart = '';

    /**
     * 取得範囲終日
     * @var string
     */
    private $_rangeEnd = '';

    /**
     * 会員ID
     * @var integer
     */
    private $_ref_account = 0;

    /**
     * DB接続オジェクト
     * @var object
     */
    private $_objdb = null;

    /**
     * メールオブジェクト
     * @var object
     */
    private $_objmail = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    public function __construct()
    {
        $this->_objdb   = RKT_DB::getInstance();
        $this->_objmail = RKT_Message::getInstance('daily');
        
        // 月:1 と 木:4 の情報取得日数
        $weekly = array(1=>345600, 4=>259200); // 4日間と3日間
        $timestamp = time();
        $this->_day = date('w', $timestamp);
        $this->_now = date('Y/m/d', $timestamp);
        
        $this->_rangeEnd = date('Y-m-d 23:59:59');

        $this->_limit = array(
            NEWS_STOP=>   '',
            NEWS_DAILY=>  date('Y-m-d 00:00:00', $timestamp - 86400),
            NEWS_WEEKLY=> date('Y-m-d 00:00:00', $timestamp - $weekly[$this->_day]),
        );
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        // 曜日別実行マップ
        $action = array(
            0=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            1=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>true),
            2=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            3=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            4=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>true),
            5=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            6=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
        );

        $condition = array(
            'avail'=> STATUS_ENABLE,
        );
        $result = RKT_DB::getList('act_account', $condition, 'id,news');

        foreach ($result as $value){
            $this->_news = empty($value['news'])? 0:$value['news'];
            $this->_ref_account = $value['id'];
            $this->_rangeStart = $this->_limit[$this->_news];

            if ($action[$this->_day][$this->_news]){
                $this->_sendMail();
            }
        } // foreach ($result as $value)
    }

    /**
     * ニュースの配信
     *
     * @access private
     * @param integer $ref_account
     * @return void
     **/
    private function _sendMail()
    {
        $condition = array(
            'ref_account'=> $this->_ref_account
        );
        $account = RKT_DB::getRow('act_account', $this->_ref_account);
        $profile = RKT_DB::getRow('act_profile', $condition);

        $this->_objmail->Assign('user_name', $profile['nickname']);
        $this->_objmail->Assign('now', $this->_now);
        $this->_objmail->Assign('http', HTTP_ACTION);
        $this->_objmail->Assign('url', BASE_URL);
        $this->_objmail->Assign('http_action', HTTP_ACTION);
        $this->_objmail->Assign('uri_separator', US);

        $this->_news = false;

        $this->_setMessage();
        $this->_setEvent();
        $this->_setTopic();
        $this->_setFriendBlog();
        $this->_setComment();
        
        $this->_objmail->Assign('news', $this->_news);

        $email = RKT_Crypt::getDecrypted($account['email'])
        $this->_objmail->send($email);
    }

    /**
     * メッセージボックスの設定
     *
     * @access private
     * @return void
     */
    private function _setMessage()
    {
        $condition = array(
            'ref_account'=> $this->account['id'],
            'status'=>      MESSAGE_INBOX,
            'flag'=>        FLAG_UNREAD,
        );
        $result = RKT_DB::getList('fri_message', $condition);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $row){
            $profile = RKT_DB::getRow('act_profile', $row['ref_from']);

            $row['nickname']    = $profile['nickname'];
            $row['modified']    = fDate($_row['modified'], _('Y-m-d'));
            $row['regist_date'] = fDate($_row['regist_date'], _('Y-m-d'));

            $list[] = $row;            
        }
        $this->_news = true;
        $this->_objmail->Assign('messages', $list);
    }

    /**
     * コミュニティイベントの設定
     *
     * @access private
     * @return void
     */
    private function _setEvent()
    {
        $sql =
            'SELECT '.
                'evt.id as id,'.
                'evt.modified as modified,'.
                'evt.regist_date as regist_date,'.
                'evt.start_date as start_date,'.
                'evt.ref_community as ref_community,'.
                'evt.event as event,'.
                'evt.comment as comment,'.
                'evt.posts as posts '.
            'FROM '.
                'sns_com_names nam,'.
                'sns_com_event evt '.
            'WHERE '.
                'nam.ref_community = evt.ref_community AND '.
                'nam.status & '.PERMISSION_MEMBERS.' AND '.
                'nam.bulletin = '.STATUS_ENABLE.' AND '.
                'nam.ref_account = '.$this->_ref_account.' AND '.
                "evt.regist_date >= '".$this->_rangeStart."' AND ".
                "evt.regist_date <= '".$this->_rangeEnd."' ".
            'ORDER BY '.
                'evt.regist_date DESC '.
            'LIMIT 5';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $row){
            $community = RKT_DB::getRow('com_community', $row['ref_community']);

            $row['community']   = $community['community'];
            $row['modified']    = fDate($_row['modified'], _('Y-m-d'));
            $row['regist_date'] = fDate($_row['regist_date'], _('Y-m-d'));
            $row['start_date']  = fDate($_row['start_date'], _('Y-m-d'));

            $list[] = $row;            
        }
        $this->_news = true;
        $this->_objmail->Assign('events', $list);
    }

    /**
     * コミュニティ掲示板の設定
     *
     * @access private
     * @return void
     */
    private function _setTopic()
    {
        $sql =
            'SELECT '.
                'tpc.id as id,'.
                'tpc.modified as modified,'.
                'tpc.regist_date as regist_date,'.
                'tpc.ref_community as ref_community,'.
                'tpc.topic as topic,'.
                'tpc.comment as comment,'.
                'tpc.posts as posts '.
            'FROM '.
                'sns_com_names nam,'.
                'sns_com_topic tpc '.
            'WHERE '.
                'nam.ref_community = tpc.ref_community AND '.
                'nam.status & '.PERMISSION_MEMBERS.' AND '.
                'nam.bulletin = '.STATUS_ENABLE.' AND '.
                'nam.ref_account = '.$this->_ref_account.' AND '.
                "tpc.regist_date >= '".$this->_rangeStart."' AND ".
                "tpc.regist_date <= '".$this->_rangeEnd."' ".
            'ORDER BY '.
                'tpc.regist_date '.
            'DESC LIMIT 5';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $row){
            $community = RKT_DB::getRow('com_community', $row['ref_community']);

            $row['community']   = $community['community'];
            $row['modified']    = fDate($_row['modified'], _('Y-m-d'));
            $row['regist_date'] = fDate($_row['regist_date'], _('Y-m-d'));

            $list[] = $row;            
        }
        $this->_news = true;
        $this->_objmail->Assign('topics', $result);
    }

    /**
     * 友達日記の設定
     *
     * @access private
     * @return void
     */
    private function _setFriendBlog()
    {
        $visible = VISIBILITY_PUBLIC | VISIBILITY_PROTECTED | VISIBILITY_FRIEND;

        $sql =
            'SELECT '.
                'ent.id as id,'.
                'ent.modified as modified,'.
                'ent.regist_date as regist_date,'.
                'ent.ref_account as ref_account,'.
                'ent.subject as subject,'.
                'ent.body as body '.
            'FROM '.
                'sns_fri_friends fri,'.
                'sns_blg_entry ent '.
            'WHERE '.
                'fri.ref_friend = ent.ref_account AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ent.visibility & '.$visible.' AND '.
                "ent.regist_date >= '".$this->_rangeStart."' AND ".
                "ent.regist_date <= '".$this->_rangeEnd."' AND ".
                'fri.ref_account = '.$this->_ref_account.' '.
            'ORDER BY '.
                'ent.regist_date DESC '.
            'LIMIT 5';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $row){
            $profile = RKT_DB::getRow('act_profile', $row['ref_account']);

            $row['nickname']    = $profile['nickname'];
            $row['modified']    = fDate($_row['modified'], _('Y-m-d'));
            $row['regist_date'] = fDate($_row['regist_date'], _('Y-m-d'));

            $list[] = $row;            
        }
        $this->_news = true;
        $this->_objmail->Assign('fblogs', $list);
    }

    /**
     * 日記コメントの設定
     *
     * @access private
     * @return void
     */
    private function _setComment()
    {
        $condition = array(
            'ref_account'=> $this->_ref_account,
            'flag'=>        FLAG_UNREAD,
        );
        $result = RKT_DB::getList('blg_comment', $condition);

        $list = array();
        foreach ($result as $row){
            $profile = RKT_DB::getRow('act_profile', $row['ref_account']);
            $entry   = RKT_DB::getRow('blg_entry',   $row['ref_entry']);

            $row['subject']     = $entry['subject'];
            $row['posts']       = $entry['posts'];
            $row['nickname']    = $profile['nickname'];
            $row['modified']    = fDate($_row['modified'], _('Y-m-d'));
            $row['regist_date'] = fDate($_row['regist_date'], _('Y-m-d'));

            $list[$row['ref_entry']] = $row;            
        }

        $this->_news = true;
        $this->_objmail->Assign('comments', $list);
    }
} // alertDaily

$actday = new alertDaily();
$actday->execute();
?>
