<?php
/* SVN FILE: $Id: tiles.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * 写真のタイル表示
 *
 * PHP versions 5
 *
 *  Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *  Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 写真のタイル表示
 *
 * @access public
 * @param integer   $id
 * @return void
 **/
function hitsuji_tiles($id, $type, $visible=VISIBILITY_PUBLIC)
{
    static $loaded;

    $list = array(
        'community'=> HTTP_ACTION.'member/personal/community/'.$id.'/',
        'friends'=>   HTTP_ACTION.'member/personal/friends/'.$id.'/',
        'names'=>     HTTP_ACTION.'community/view/member/'.$id.'/',
    );

    $links = array(
        'community'=> HTTP_ACTION.'community/view/community/',
        'friends'=>   HTTP_ACTION.'member/personal/profile/',
        'names'=>     HTTP_ACTION.'member/personal/profile/',
    );

    $funcs = array(
        'community'=> 'hitsuji_countCommunities',
        'friends'=>   'hitsuji_countFriends',
        'names'=>     'hitsuji_countNames',
    );

    $label = array(
        'community'=> _('View all Communities'),
        'friends'=>   _('View all Friends'),
        'names'=>     _('View all Members'),
    );
    
    $count = call_user_func($funcs[$type], $id, $visible);
    if (empty($count)){
        return ;
    }
    $page = ceil($count / LIMIT_JSON_FRIENDS);
?>
					<img src="<?php Theme::Path(); ?>menuTop.png" width="188" height="10" alt="__" align="absbottom" />
					<div id="<?php e($type); ?>Tile" class="sideList"></div>
					<div class="sideList"><a href="<?php e($list[$type]); ?>"><?php e($label[$type]); ?></a>
					</div><img src="<?php Theme::Path(); ?>menuBottom.png" width="188" height="10" alt="__" align="top" />
<?php if (!$loaded): ?>
					<script type="text/javascript" src="<?php e(BASE_URL); ?>resource/js/tile.js"></script>
<?php endif; ?>
<script type="text/javascript">
YAHOO.util.Event.onContentReady("<?php e($type); ?>Tile", function () {
	var <?php e($type); ?>Tile = new viewTile('<?php e($type); ?>Tile', <?php e($page); ?>, <?php e(PHOTO_SMALL_SIZE); ?>, '<?php e(BASE_URL); ?>', '<?php e($links[$type]); ?>', '<?php e($list[$type].'json/'.US); ?>');
	<?php e($type); ?>Tile.createHeader();
	<?php e($type); ?>Tile.setTile();
});</script>
<?php
    /* スクリプトの読み込みフラグ */
    $loaded = true;
} // hitsuji_friends


/**
 * 参加コミュニティ
 *
 * @access public
 * @param integer   $id
 * @param integer   $visible
 * @return integer
 **/
function hitsuji_countCommunities($id, $visible)
{
    /* 参加コミュニティ */
    $condition = array(
        'ref_account'=> $id,
        'status'=>      array('&', PERMISSION_MEMBERS),
        'visibility'=>  array('&', $visible),
    );
    $result = RKT_DB::getRow('com_names', $condition, 'count(*) as ct');

    return $result['ct'];
}

/**
 * 友達リスト
 *
 * @access public
 * @param integer   $id
 * @param integer   $visible
 * @return integer
 **/
function hitsuji_countFriends($id, $visible)
{
    /* 友達リスト */
    $condition = array(
        'ref_account'=> $id,
        'status'=>      STATUS_FRIEND_CONNECT
    );
    $result = RKT_DB::getRow('fri_friends', $condition, 'count(*) as ct');

    return $result['ct'];
}

/**
 * コミュニティ参加名簿
 *
 * @access public
 * @param integer   $id
 * @param integer   $visible
 * @return integer
 **/
function hitsuji_countNames($id, $visible)
{
    /* コミュニティ参加名簿 */
    $condition = array(
        'ref_community'=> $id
    );
    $result = RKT_DB::getRow('com_names', $condition, 'count(*) as ct');

    return $result['ct'];
}
?>
