<?php
/* SVN FILE: $Id: summary.php 445 2008-05-20 08:54:14Z bb_yujiro $ */
/**
 * サマリーの表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 445 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:54:14 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * サマリーの表示
 *
 * @access public
 * @param integer   $ref_account
 * @return void
 **/
function hitsuji_summary($id, $key)
{
    $titles = array(
        'blg_entry'=>   _('Blog List'),
        'com_forum'=>   _('Forum List'),
        'com_event'=>   _('Event List'),
        'com_article'=> _('Article List'),
    );

    $link = array(
        'blg_entry'=>   'member/blog/list/'.$id.'/',
        'com_forum'=>   'community/forum/list/'.$id.'/',
        'com_event'=>   'community/event/calendar/'.$id.'/',
        'com_article'=> 'community/article/list/'.$id.'/',
    );

    $jsons = array(
        'blg_entry'=>   'member/blog/list/'.$id.'/json/',
        'com_forum'=>   'community/forum/list/'.$id.'/json/',
        'com_event'=>   'community/event/list/'.$id.'/json/',
        'com_article'=> 'community/article/list/'.$id.'/json/',
    );

    $icons = array(
        'blg_entry'=>   'book_open.gif',
        'com_forum'=>   'bulletin.gif',
        'com_event'=>   'event.gif',
        'com_article'=> 'page.gif',
    );
?>
					<div id="frm_<?php e($key); ?>" style="display:none;"><img src="<?php Theme::Path(); ?>itemTop.png" width="530" height="10" alt="__" align="absbottom" />
						<div class="listing"><ul>
							<li><a href="<?php e(HTTP_ACTION . $link[$key]); ?>"><img src="<?php e(BASE_URL); ?>resource/img/icons/<?php e($icons[$key]); ?>" width="16" height="16" align="absmiddle" alt="&gt;" />&nbsp;<strong><?php e($titles[$key]); ?></strong></a></li>
							<li><ul id="<?php e($key); ?>" class="summary" style="width:530px;"></ul>
<script type="text/javascript">
YAHOO.util.Event.onDOMReady(function() {
	var callback =
	{
		success: function(o) {
			var summary = YAHOO.lang.JSON.parse (o.responseText);

			var div = YAHOO.util.Dom.get('frm_<?php e($key); ?>');
			var ul  = YAHOO.util.Dom.get('<?php e($key); ?>');
			var li  = null;
			var anc = null;
			var img = null;
			
			if (summary.length != 0){
				div.style.display = 'inline';
			}
			for (row=0; row<summary.length; row++){
				li  = document.createElement('li');
				anc = document.createElement('a');

				anc.setAttribute('href', summary[row].link);

				li.appendChild(document.createTextNode(summary[row].date + '   '));
				anc.appendChild(document.createTextNode(summary[row].title));
				li.appendChild(anc);
				if (summary[row].creator){
					li.appendChild(document.createTextNode('  (' + summary[row].creator + ')'));
				}

				ul.style.listStyleType = 'circle';
				ul.style.paddingLeft = '16px';
				ul.appendChild(li);
			}
		},
		failure: function(o) {
			YAHOO.util.Dom.setStyle('frm_<?php e($key); ?>', "display", "none");
		},
		argument: []
	}
	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('GET',  '<?php e(HTTP_ACTION . $jsons[$key]); ?>', callback);
});
</script>
						</li></ul></div>
					<img src="<?php Theme::Path(); ?>itemBottom.png" width="530" height="10" alt="__" align="top" /></div>
<?php
} // hitsuji_summary
?>
