<?php
/* SVN FILE: $Id: mobileTiles.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * 写真のタイル表示
 *
 * PHP versions 5
 *
 *  Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *  Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 写真のタイル表示
 *
 * @access public
 * @param integer   $id
 * @return void
 **/
function hitsuji_mobileTiles($id, $type, $visible=VISIBILITY_PUBLIC)
{
    $funcs = array(
        'community'=> 'hitsuji_mobileTilesCommunities',
        'friends'=>   'hitsuji_mobileTilesFriends',
        'names'=>     'hitsuji_mobileTilesNames',
    );
    
    $count = call_user_func($funcs[$type], $id, $visible);
} // hitsuji_mobileTiles


/**
 * 参加コミュニティ
 *
 * @access public
 * @param integer   $id
 * @param integer   $visible
 * @return integer
 **/
function hitsuji_mobileTilesCommunities($id, $visible)
{
    /* 参加コミュニティ */
    $condition = array(
        'ref_account'=> $id,
        'status'=>      array('&', PERMISSION_MEMBERS),
        'visibility'=>  array('&', $visible),
    );
    $result = RKT_DB::getList('com_names', $condition, '*', null, LIMIT_JSON_COMMUNITYS);
    if (empty($result)){
        return ;
    }
?>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>">
<tr><td bgcolor="<?php Theme::exec()->bgColumnColor(); ?>" align="center"><font color="<?php Theme::exec()->columnColor(); ?>"><?php _e('Communities'); ?></font><br></td></tr>
</table>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>"><tr>
<?php foreach ($result as $key=> $_row): ?>
<td><?php loadPlugin::callFunc('hitsuji_community', $_row['ref_community'], 'vSmall'); ?></td>
<?php if ($key == 3): ?></tr></tr><?php endif; ?>
<?php endforeach; ?>
</tr></table>
<div align="right"><font size="<?php Theme::exec()->fontSize(); ?>">&lt;<a href="<?php e(HTTP_ACTION); ?>member/personal/community/<?php e($id); ?>/"><?php _e('View all Communities'); ?></a>&gt;</font></div>
<?php
}

/**
 * 友達リスト
 *
 * @access public
 * @param integer   $id
 * @param integer   $visible
 * @return integer
 **/
function hitsuji_mobileTilesFriends($id, $visible)
{
    /* 友達リスト */
    $condition = array(
        'ref_account'=> $id,
        'status'=>      STATUS_FRIEND_CONNECT
    );
    $result = RKT_DB::getList('fri_friends', $condition, '*', null, LIMIT_JSON_COMMUNITYS);

?>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>">
<tr><td bgcolor="<?php Theme::exec()->bgColumnColor(); ?>" align="center"><font color="<?php Theme::exec()->columnColor(); ?>"><?php _e('Friends'); ?></font><br></td></tr>
</table>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>"><tr>
<?php foreach ($result as $key=> $_row): ?>
<td><?php loadPlugin::callFunc('hitsuji_profile', $_row['ref_friend'], 'vSmall'); ?></td>
<?php if ($key == 3): ?></tr><tr><?php endif; ?>
<?php endforeach; ?>
</tr></table>
<div align="right"><font size="<?php Theme::exec()->fontSize(); ?>">&lt;<a href="<?php e(HTTP_ACTION); ?>member/personal/friends/<?php e($id); ?>/"><?php _e('View all Friends'); ?></a>&gt;</font></div>
<?php
}

/**
 * コミュニティ参加名簿
 *
 * @access public
 * @param integer   $id
 * @param integer   $visible
 * @return integer
 **/
function hitsuji_mobileTilesNames($id, $visible)
{
    /* コミュニティ参加名簿 */
    $condition = array(
        'ref_community'=> $id
    );
    $result = RKT_DB::getList('com_names', $condition, '*', null, LIMIT_JSON_COMMUNITYS);

?>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>">
<tr><td bgcolor="<?php Theme::exec()->bgColumnColor(); ?>" align="center"><font color="<?php Theme::exec()->columnColor(); ?>"><?php _e('Members'); ?></font><br></td></tr>
</table>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>"><tr>
<?php foreach ($result as $key=> $_row): ?>
<td><?php loadPlugin::callFunc('hitsuji_profile', $_row['ref_account'], 'vSmall'); ?></td>
<?php if ($key == 3): ?></tr><tr><?php endif; ?>
<?php endforeach; ?>
</tr></table>
<div align="right"><font size="<?php Theme::exec()->fontSize(); ?>">&lt;<a href="<?php e(HTTP_ACTION); ?>community/view/member/<?php e($id); ?>/"><?php _e('View all Members'); ?></a>&gt;</font></div>
<?php
}
?>
