<?php
/* SVN FILE: $Id: mobileSummary.php 342 2008-05-11 02:27:14Z bb_yujiro $ */
/**
 * 携帯用サマリーの表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 342 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 11:27:14 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

include_once LIB_DIR.'PEAR/HTTP/Request.php';

/**
 * 携帯用サマリーの表示
 *
 * @access public
 * @param integer   $ref_account
 * @return void
 **/
function hitsuji_mobileSummary($id, $key)
{
    $titles = array(
        'blg_entry'=>   _('Blog List'),
        'com_forum'=>   _('Forum List'),
        'com_event'=>   _('Event List'),
        'com_article'=> _('Article List'),
    );
    $link = array(
        'blg_entry'=>   'member/blog/list/'.$id.'/',
        'com_forum'=>   'community/forum/list/'.$id.'/',
        'com_event'=>   'community/event/list/'.$id.'/',
        'com_article'=> 'community/article/list/'.$id.'/',
    );
    $cookie = array(
        'name'=>  session_name(),
        'value'=> session_id(),
    );

    $objreq = new HTTP_Request();
    $objreq->setMethod(HTTP_REQUEST_METHOD_GET);
    $objreq->addCookie($cookie['name'], $cookie['value']);
    $objreq->setURL(HTTP_ACTION.$link[$key].'php/');

    if (PEAR::isError($objreq->sendRequest())) {
        return ;
    }

    $response = $objreq->getResponseBody();
    $result   = unserialize ($response);

    if (empty($result)){
        return ;
    }
?>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>">
<tr><td bgcolor="<?php Theme::exec()->bgColumnColor(); ?>" align="center"><font color="<?php Theme::exec()->columnColor(); ?>"><?php e($titles[$key]); ?></font><br></td></tr>
<?php foreach ($result as $_row): ?>
<tr><td bgcolor="<?php Theme::exec()->bgColor(); ?>"><font size="<?php Theme::exec()->fontSize(); ?>">
<?php eDate($_row['modified'], _('m-d')); ?>--<a href="<?php e($_row['link']); ?>"><?php e($_row['title']); ?></a><?php if (!empty($_row['creator'])): ?>&nbsp;(<?php e($_row['creator']); ?>)<?php endif; ?><br></font>
</td></tr>
<?php endforeach; ?>
</table>
<?php
} // hitsuji_summary
?>
