<?php
/* SVN FILE: $Id: middleGadget.php 467 2008-05-22 09:33:44Z bb_yujiro $ */
/**
 * Side Gadget
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 467 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:33:44 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Side Gadget
 *
 * @access public
 * @param integer   $ref_account
 * @return void
 **/
function hitsuji_middleGadget($ref_account)
{
    $function = array(
        GADGET_INSIDE=>  'hitsuji_middleGadget_Inside',
        GADGET_OUTSIDE=> 'hitsuji_middleGadget_Outside',
        GADGET_OBJECT=>  'hitsuji_middleGadget_Object',
    );
    $condition = array(
        'ref_account'=> $ref_account,
        'position'=>    POSITION_MIDDLE,
    );
    $gadgets = RKT_DB::getList('act_gadget', $condition, '*', 'sort');
    if (empty($gadgets)){
        return ;
    }    
?>
					<form name="sidegadget">
						<input id="_mpnnc" type="hidden" value="<?php e(RKT_Crypt::getNonce('manipNonce')); ?>" />
						<input id="url" type="hidden" value="<?php e(HTTP_ACTION); ?>private/post/gadget/" />
					</form>
					<ul id="sidegadgetlist"><?php 
    foreach ($gadgets as $gadget){
        /* 表示設定 */
        if (empty($gadget['display'])){
            $gadget['display'] = 'none';
            $gadget['icon']    = 'display_plus';
        } else {
            $gadget['display'] = 'block';
            $gadget['icon']    = 'hidden_minus';
        }
        call_user_func($function[$gadget['type']], $gadget);
    }
                ?></ul>
<?php
} // hitsuji_middleGadget

/**
 * 内部RSS処理
 *
 * @access public
 * @param array   $gadget
 * @return void
 **/
function hitsuji_middleGadget_Inside($gadget)
{
    $link = str_replace('/json/', '/', $gadget['source']);

    $icon = 'bulletin';
    if ($pos = strpos($link, 'blog')){
        $icon = 'book_open';
    } elseif ($pos = strpos($link, 'comment')){
        $icon = 'comment';
    } elseif ($pos = strpos($link, 'event')){
        $icon = 'event';
    }
                    ?><li id="gadget_<?php e($gadget['id']); ?>"><img src="<?php Theme::Path(); ?>itemTop.png" width="530" height="10" alt="+--+" align="absbottom" />
						<div class="listing"><ul class="horizontal"><li style="width:410px;"><img src="<?php e(BASE_URL); ?>resource/img/icons/<?php e($icon); ?>.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>&nbsp;<strong><?php e($gadget['title']); ?></strong></li>
						<li style="width:100px; text-align:right;">
							<a href="<?php e(HTTP_ACTION); ?>private/post/gadget/<?php e($gadget['id']); ?>/"><img src="<?php e(BASE_URL); ?>resource/img/icons/edit.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="upFeed('gadget_<?php e($gadget['id']); ?>');"><img src="<?php e(BASE_URL); ?>resource/img/icons/bullet_arrow_up.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="downFeed('gadget_<?php e($gadget['id']); ?>');"><img src="<?php e(BASE_URL); ?>resource/img/icons/bullet_arrow_down.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="displayFeed(this, <?php e($gadget['id']); ?>);"><img src="<?php e(BASE_URL); ?>resource/img/icons/<?php e($gadget['icon']); ?>.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
						</li></ul></div>
						<div id="display_<?php e($gadget['id']); ?>" style="display:none;">
							<div class="listing"><div id="feed_<?php e($gadget['id']); ?>" class="center"></div></div>
							<div class="listing" style="text-align:right;">&lt;<a href="<?php e($link); ?>"><?php _e('View More'); ?></a>&gt;&nbsp;&nbsp;&nbsp;</div>
						</div><script type="text/javascript"><!--
YAHOO.util.Event.onContentReady("feed_<?php e($gadget['id']); ?>", function () {
	setRecent("feed_<?php e($gadget['id']); ?>", "<?php e($gadget['source']); ?>");
	YAHOO.util.Dom.setStyle('display_<?php e($gadget['id']); ?>', 'display', '<?php e($gadget['display']); ?>');
});
//--></script>
					<img src="<?php Theme::Path(); ?>itemBottom.png" width="530" height="10" alt="+__+" align="top" /></li><?php
} // hitsuji_middleGadget_Inside

/**
 * 外部RSS処理
 *
 * @access public
 * @param array   $gadget
 * @return void
 **/
function hitsuji_middleGadget_Outside($gadget)
{
    $feed = RKT_DB::getRow('rss_feed', $gadget['ref_feed']);
    if (empty($feed)){
        return ;
    }
    $result = unserialize($feed['articles']);
    
    if (empty($result)){
        return ;
    }
    $max = intval($gadget['list_number']);
    $num = count($result);
    $max = ($max < $num)? $max:$num;
                    ?><li id="gadget_<?php e($gadget['id']); ?>"><img src="<?php Theme::Path(); ?>itemTop.png" width="530" height="10" alt="+--+" align="absbottom" />
						<div class="listing"><ul class="horizontal"><li style="width:410px;"><img src="<?php e(BASE_URL); ?>resource/img/icons/cog.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>&nbsp;<strong><?php e($gadget['title']); ?></strong></li>
						<li style="width:100px; text-align:right;">
							<a href="javascript:refreshFeed('feed_<?php e($gadget['id']); ?>', '<?php e(HTTP_ACTION); ?>public/json/feed/<?php e($gadget['ref_feed']); ?>/1/<?php e(US); ?>_mpnnc=<?php e(RKT_Crypt::getNonce('manipNonce')); ?>', 5);"><img src="<?php e(BASE_URL); ?>resource/img/icons/arrow_refresh.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="<?php e(HTTP_ACTION); ?>private/post/gadget/<?php e($gadget['id']); ?>/"><img src="<?php e(BASE_URL); ?>resource/img/icons/edit.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="upFeed('gadget_<?php e($gadget['id']); ?>');"><img src="<?php e(BASE_URL); ?>resource/img/icons/bullet_arrow_up.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="downFeed('gadget_<?php e($gadget['id']); ?>');"><img src="<?php e(BASE_URL); ?>resource/img/icons/bullet_arrow_down.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="displayFeed(this, <?php e($gadget['id']); ?>);"><img src="<?php e(BASE_URL); ?>resource/img/icons/<?php e($gadget['icon']); ?>.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
						</li></ul></div>
						<div id="display_<?php e($gadget['id']); ?>" style="display:none;">
							<div class="listing"><ul id="feed_<?php e($gadget['id']); ?>" style="list-style:circle; padding-left:18px;"><?php for ($row=0; $row<$max; $row++): ?><li><a href="<?php e(trim($result[$row]['link'])); ?>"><?php e($result[$row]['title']); ?></a></li><?php endfor; ?></ul></div>
							<div class="listing" style="text-align:right;">&lt;<a href="<?php e($feed['link']); ?>"><?php _e('View More'); ?></a>&gt;&nbsp;&nbsp;</div>
						</div><script type="text/javascript"><!--
YAHOO.util.Event.onContentReady("feed_<?php e($gadget['id']); ?>", function () {
	YAHOO.util.Dom.setStyle('display_<?php e($gadget['id']); ?>', 'display', '<?php e($gadget['display']); ?>');
});//--></script>
					<img src="<?php Theme::Path(); ?>itemBottom.png" width="530" height="10" alt="+__+" align="top" /></li><?php
} // hitsuji_middleGadget_Outside

/**
 * ソース処理
 *
 * @access public
 * @param array   $gadget
 * @return void
 **/
function hitsuji_middleGadget_Object($gadget)
{
                    ?><li id="gadget_<?php e($gadget['id']); ?>"><img src="<?php Theme::Path(); ?>itemTop.png" width="530" height="10" alt="+--+" align="absbottom" />
						<div class="listing"><ul class="horizontal"><li style="width:410px;"><img src="<?php e(BASE_URL); ?>resource/img/icons/cog.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>&nbsp;<strong><?php e($gadget['title']); ?></strong></li>
						<li style="width:100px; text-align:right;">
							<a href="<?php e(HTTP_ACTION); ?>private/post/gadget/<?php e($gadget['id']); ?>/"><img src="<?php e(BASE_URL); ?>resource/img/icons/edit.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="upFeed('gadget_<?php e($gadget['id']); ?>');"><img src="<?php e(BASE_URL); ?>resource/img/icons/bullet_arrow_up.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="downFeed('gadget_<?php e($gadget['id']); ?>');"><img src="<?php e(BASE_URL); ?>resource/img/icons/bullet_arrow_down.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
							<a href="javascript:void(0);" onclick="displayFeed(this, <?php e($gadget['id']); ?>);"><img src="<?php e(BASE_URL); ?>resource/img/icons/<?php e($gadget['icon']); ?>.gif" width="16" height="16" align="absmiddle" alt=">>" /></a>
						</li></ul></div>
						<div id="display_<?php e($gadget['id']); ?>" class="listing" style="display:none;"><div id="feed_<?php e($gadget['id']); ?>" class="center"><?php e($gadget['source']); ?></div></div><script type="text/javascript"><!--
YAHOO.util.Event.onContentReady("feed_<?php e($gadget['id']); ?>", function () {
	YAHOO.util.Dom.setStyle('display_<?php e($gadget['id']); ?>', 'display', '<?php e($gadget['display']); ?>');
});//--></script>
					<img src="<?php Theme::Path(); ?>itemBottom.png" width="530" height="10" alt="+__+" align="top" /></li><?php
} // hitsuji_middleGadget_Object
?>
