<?php
/* SVN FILE: $Id: lastLogin.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * 最終ログイン日時の表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 最終ログイン日時の表示
 *
 * @access public
 * @param integer   $ref_account
 * @return void
 **/
function hitsuji_lastLogin($id)
{
    $account = RKT_DB::getRow('act_account', $id, 'last_login');
    $date    = empty($account['last_login'])? 'now':$account['last_login'];

    $elapsed = time() - strtotime($date);

    $minute = ceil($elapsed / 60);      // 経過 分
    $hour   = ceil($elapsed / 3600);    // 経過 時
    $day    = ceil($elapsed / 86400);   // 経過 日

    if ($minute <= 60) {
        if ($minute <= 3) {
            $string = _('3 minutes');
        } elseif ($minute <= 5){
            $string = _('5 minutes');
        } elseif ($minute <= 10){
            $string = _('10 minutes');
        } elseif ($minute <= 15){
            $string = _('15 minutes');
        } elseif ($minute <= 30){
            $string = _('30 minutes');
        } elseif ($minute <= 45){
            $string = _('45 minutes');
        } else {
            $string = _('60 minutes');
        }
    } elseif ($hour <= 24){
        $string = sprintf(_('%s hours'), $hour);
    } elseif ($day <= 3){
        $string = sprintf(_('%s days'), $day);
    } else {
        $string = _('3 days over');
    }

    print ($string);
} // hitsuji_lastLogin
?>
