<?php
/* SVN FILE: $Id: blogKeyword.php 346 2008-05-11 03:22:38Z bb_yujiro $ */
/**
 * ブログタグのタグクラウド表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 346 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 12:22:38 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require_once LIB_DIR.'PEAR/HTML/TagCloud.php';

/**
 * ブログキーワードのタグクラウド表示
 *
 * @access public
 * @param string   $id_name
 * @return void
 **/
function hitsuji_blogKeyword($id_name='frm_blog_tag')
{
    $rangeStart = date('Y-m-d 00:00:00', strtotime('-7 days'));
    $rangeEnd   = date('Y-m-d 23:59:59');

    $objdb = RKT_DB::getInstance();
    $sql = 'SELECT tag,sum(posts) as num FROM '.DB_PREFIX.'blg_keyword '.
           'WHERE  modified >= :rangeStart AND modified <= :rangeEnd '.
           'GROUP BY tag ORDER BY num DESC LIMIT 30';
    $stmt = $objdb->prepare($sql);
    $stmt->execute(array(':rangeStart'=> $rangeStart, ':rangeEnd'=> $rangeEnd));
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (empty($result)){
        return ;
    }
    
    $list_url = HTTP_ACTION.'member/blog/search/'.US.'keyword=';
    $baseFontSize  = 36;
    $fontSizeRange = 24;
    // Tag size range in ($baseFontSize - $fontSizeRange) to
    // ($baseFontSize + $fontSizeRange).
    $tags = new HTML_TagCloud($baseFontSize, $fontSizeRange);
    foreach ($result as $row){
        $tags->addElement($row['tag'], $list_url.urlencode($row['tag']), $row['num']);
    }
    // html part only
    $taghtml = $tags->buildHTML();
?>
<?php e($taghtml); ?>
<script type="text/javascript">
YAHOO.util.Dom.setStyle("<?php e($id_name); ?>", "display", "block");
</script>
<?php
} // hitsuji_blogKeyword
?>
