<?php
/* SVN FILE: $Id: blogArchives.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * ブログアーカイブを表示
 *
 * PHP versions 5
 *
 *  Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *  Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * ブログアーカイブを表示
 *
 * @access public
 * @param integer $ref_account
 * @param string $id_name
 * @return void
 **/
function hitsuji_blogArchives($ref_account, $id_name='frm_blog_archives')
{
    $objdb  = RKT_DB::getInstance();
    $format = RKT_DB::dateFormat('regist_date', '%Y-%m-01');
    $sql = 'SELECT '.$format.' as regist_date FROM '.DB_PREFIX.'blg_entry '.
           'WHERE ref_account = :ref_account GROUP BY '.$format;
    $stmt = $objdb->prepare($sql);
    $stmt->execute(array(':ref_account'=> $ref_account));
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($result)){
        return ;
    }

    $years = array();
    $list  = array();
    foreach ($result as $row){
        $year = substr($row['regist_date'], 0, 4);
        $years[$year] = $year;
        $list[$year][$row['regist_date']] = true;
        
    }

    rsort ($years);
    foreach ($years as $year):        
?>
					 <?php e($year); ?>
						<ul class= "horizontal" style="width:170px;">
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-01-01'])): _e('Jan'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-01-01'); ?>/"><?php _e('Jan');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-02-01'])): _e('Feb'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-02-01'); ?>/"><?php _e('Feb');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-03-01'])): _e('Mar'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-03-01'); ?>/"><?php _e('Mar');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-04-01'])): _e('Apr'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-04-01'); ?>/"><?php _e('Apr');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-05-01'])): _e('May'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-05-01'); ?>/"><?php _e('May');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-06-01'])): _e('Jun'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-06-01'); ?>/"><?php _e('Jun');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-07-01'])): _e('Jul'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-07-01'); ?>/"><?php _e('Jul');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-08-01'])): _e('Aug'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-08-01'); ?>/"><?php _e('Aug');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-09-01'])): _e('Sep'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-09-01'); ?>/"><?php _e('Sep');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-10-01'])): _e('Oct'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-10-01'); ?>/"><?php _e('Oct');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-11-01'])): _e('Nov'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-11-01'); ?>/"><?php _e('Nov');?></a><?php endif; ?></li>
							<li style="width:42px; text-align:center;"><?php if (empty($list[$year][$year.'-12-01'])): _e('Dec'); else : ?><a href="<?php e(HTTP_ACTION); ?>member/blog/list/<?php e($ref_account); ?>/<?php hitsuji_eLastTiemStamp($year.'-12-01'); ?>/"><?php _e('Dec');?></a><?php endif; ?></li>
						</ul><img class="blank" src="<?php e(BASE_URL); ?>resource/img/common/blank.gif" width="1" height="1" alt="blank" /><br />
<?php
    endforeach;
?>
<script type="text/javascript">
YAHOO.util.Dom.setStyle("<?php e($id_name); ?>", "display", "block");
</script>
<?php
} // hitsuji_calendar

/**
 * タイムスタンプの出力
 *
 * @access public
 * @param string $date
 * @return integer
 **/
function hitsuji_eLastTiemStamp($date)
{
    print (strtotime('+1 months -1 day', strtotime($date)));
}
?>
