<?php
/* SVN FILE: $Id: entrance.php 621 2008-07-20 03:49:24Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 621 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-20 12:49:24 +0900 (日, 20 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktAuth/OpenIDInterface.php';

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 621 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-20 12:49:24 +0900 (日, 20 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Plugin_Controller 
{
    /**
     * URIアクション
     * @var string 
     */
    protected $action = null;

    /**
     * Auth_OpenIDInterface オブジェクト
     * @var object 
     */
    private $_openid = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    function initValue()
    {
        $this->_openid = new Auth_OpenIDInterface(
                                BASE_URL, 
                                HTTP_ACTION.'plugin/hitsuji/OpenID/entrance/finish/');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function action()
    {
        if ($this->action == 'request'){
            $required = array(      // 必須項目
                'email',
                'nickname',
            );
            $optional = array(      // オプション
                'fullname',
                'gender',
                'dob',
            );
            $this->_openid->setAuthRequest($required, $optional, $this->identifier);
            $this->_openid->authAction();
        } elseif ($this->action == 'finish'){
            $this->_openid->setResponse();
            $msg = $this->_openid->getResponseMessage();

            $openid = $this->_openid->getOpenID();
            $status = $this->_openid->getResponseStatus();

            $this->objvew->assign('openid', htmlentities($openid));
            $this->objvew->assign('status', $status);
            
            $this->_authOpenID();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'identifier'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * OpenIDの登録
     *
     * @access private
     * @return void
     **/
    private function _authOpenID()
    {
        if ($this->_openid->getResponseStatus() != Auth_OpenID_SUCCESS){
            return ;
        }

        $openid = $this->_openid->getOpenID();
        $hashed = RKT_Crypt::getHashed($openid);

        /* アカウントIDの取得 */
        $condition = array(
            'hashed_openid'=> $hashed
        );
        $openid  = RKT_DB::getRow('oid_openid', $condition, 'ref_account');
        
        if (empty($openid['ref_account'])){
            return ;
        }

        /* ログイン状態に */
        RKT_account::exec()->setAccount($openid['ref_account']);
        
        header('Location: '. HTTP_ACTION.'private/');
        exit();        
    }
} // class Controller
?>
