<?php
/* SVN FILE: $Id: viw_blog.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * sys_sponsorテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * viw_blogテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_viw_blog extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'blg_entry';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'ent.id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_account'=> array(
            'column'=>     'fri.ref_account',
            'key'=>        'ref_account',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_DIRECT,
            'operator'=>  '=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );
    /* <<<<<end */

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->field = 'ent.id as id,'.
                       'ent.modified as modified,'.
                       'ent.regist_date as regist_date,'.
                       'ent.ref_account as ref_account,'.
                       'ent.subject as subject,'.
                       'ent.body as body';
        $this->from  = 'FROM '.
                        DB_PREFIX.'fri_friends fri,'.
                        DB_PREFIX.'blg_entry ent ';
        $this->where[] = 'fri.ref_friend = ent.ref_account';
        $this->where[] = 'fri.status = '.STATUS_FRIEND_CONNECT;
        $this->where[] = 'ent.visibility & '.VISIBILITY_CLOSE;
    }
} // class viw_blog
?>
