<?php
/* SVN FILE: $Id: viw_account.php 273 2008-05-06 23:20:44Z bb_yujiro $ */
/**
 * act_profileテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 273 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-07 08:20:44 +0900 (水, 07 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_profileテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 273 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-07 08:20:44 +0900 (水, 07 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_viw_account extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_account';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'act.id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'id'=> array(
            'column'=>     'act.id',
            'key'=>        'id',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'avail'=> array(
            'column'=>     'act.avail',
            'key'=>        'avail',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'email'=> array(
            'column'=>     'act.email',
            'key'=>        'email',
            'type'=>       'string',
            'pdo_type'=>   'PDO::PARAM_LOB',
            'option'=>     CRYPT_OUTPUT_FUNC,
            'required'=>   FALSE,
            'effect'=>     array('RKT_Crypt', 'getEncrypted'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'mailing'=> array(
            'column'=>     'act.mailing',
            'key'=>        'mailing',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'first_name'=> array(
            'column'=>     'pro.first_name',
            'key'=>        'first_name',
            'type'=>       'string',
            'pdo_type'=>   'PDO::PARAM_LOB',
            'option'=>     CRYPT_OUTPUT_FUNC,
            'required'=>   FALSE,
            'effect'=>     array('RKT_Crypt', 'getEncrypted'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'last_name'=> array(
            'column'=>     'pro.last_name',
            'key'=>        'last_name',
            'type'=>       'string',
            'pdo_type'=>   'PDO::PARAM_LOB',
            'option'=>     CRYPT_OUTPUT_FUNC,
            'required'=>   FALSE,
            'effect'=>     array('RKT_Crypt', 'getEncrypted'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'nickname'=> array(
            'column'=>     'pro.nickname',
            'key'=>        'nickname',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'128'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_region'=> 'ara_region',
        'ref_gender'=> 'act_gender',
        'ref_blood'=> 'act_blood',
        'ref_married'=> 'act_married',
        'taste'=> 'act_taste',
    );
    /* <<<<<end */

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->field = 'act.id as id,'.
                       'act.avail as avail,'.
                       'act.last_login as last_login,'.
                       'act.regist_date as regist_date,'.
                       'act.email as email,'.
                       'act.mailing as mailing,'. 
                       'pro.first_name as first_name,'.
                       'pro.last_name as last_name,'.
                       'pro.nickname as nickname,'.
                       'pro.comment  as comment ';
        $this->from  = 'FROM '.
                        DB_PREFIX.'act_account act,'.
                        DB_PREFIX.'act_profile pro ';
        $this->where[] = 'act.id = pro.ref_account';
    }
} // class act_profile
?>
