<?php
/* SVN FILE: $Id: com_topic.php 414 2008-05-18 07:49:47Z bb_yujiro $ */
/**
 * com_topicテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 414 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:49:47 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * com_topicテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 414 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:49:47 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_com_topic extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'com_topic';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'topic'=> array(
            'column'=>     'topic',
            'key'=>        'topic',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'255'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'keyword'=> array(
            'column'=>     'comment',
            'key'=>        'keyword',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('right'=>true),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  'LIKE',
        ),
        'publish'=> array(
            'column'=>     'regist_date',
            'key'=>        'publish',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('format'=> 'Y-m-d H:i:s'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'strToDate'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '>=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );
    /* <<<<<end */
} // class com_topic
?>
