<?php
/* SVN FILE: $Id: com_community.php 390 2008-05-16 08:19:59Z bb_yujiro $ */
/**
 * com_communityテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 390 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-16 17:19:59 +0900 (金, 16 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * com_communityテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 390 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-16 17:19:59 +0900 (金, 16 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_com_community extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'com_community';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'community'=> array(
            'column'=>     'community',
            'key'=>        'community',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'128'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  'LIKE',
        ),
        'ref_category'=> array(
            'column'=>     'ref_category',
            'key'=>        'ref_category',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'com_category',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_region'=> array(
            'column'=>     'ref_region',
            'key'=>        'ref_region',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'ara_region',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'keyword'=> array(
            'column'=>     'comment',
            'key'=>        'keyword',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'8000'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  'LIKE',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_category'=> 'com_category',
        'ref_region'=> 'ara_region',
    );
    /* <<<<<end */

    /**
     * オーダーリスト
     * @var array
     */
    public $order_list = array(
        1=> 'member_num DESC',
        2=> 'regist_date DESC',
        3=> 'community',
    );

    /**
     * オーダーラベルの取得
     *
     * @abstract
     * @access public
     * @return array
     */
    public function getOrderLabel()
    {
        return array(
            1=> _('most popular'),
            2=> _('newest'),
            3=> _('Community Name'),
        );
    }

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->from    = 'FROM '.DB_PREFIX.$this->tbl_name.' ';
        $this->where[] = 'avail = '.STATUS_ENABLE;
        $this->order   = 'regist_date DESC';
    }
} // class com_community
?>
