<?php
/* SVN FILE: $Id: cnt_contact.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * cnt_contactテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * cnt_contactテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_cnt_contact extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'cnt_contact';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'regist_date'=> array(
            'column'=>     'regist_date',
            'key'=>        'regist_date',
            'type'=>       'date',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_category'=> array(
            'column'=>     'ref_category',
            'key'=>        'ref_category',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'account',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'status'=> array(
            'column'=>     'status',
            'key'=>        'status',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'flag'=> array(
            'column'=>     'flag',
            'key'=>        'flag',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'name'=> array(
            'column'=>     'name',
            'key'=>        'name',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'128'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'comment'=> array(
            'column'=>     'comment',
            'key'=>        'comment',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'8000'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripJavaScript'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_category'=> 'cnt_category',
    );
    /* <<<<<end */
} // class cnt_contact
?>
