<?php
/* SVN FILE: $Id: blg_entry.php 237 2008-05-03 13:26:49Z bb_yujiro $ */
/**
 * blg_entryテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 237 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 22:26:49 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * blg_entryテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 237 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 22:26:49 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_blg_entry extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'blg_entry';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'tag'=> array(
            'column'=>     'tag',
            'key'=>        'tag',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'8000'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripJavaScript'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'keyword'=> array(
            'column'=>     'body',
            'key'=>        'keyword',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('right'=>true),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  'LIKE',
        ),
        'publish'=> array(
            'column'=>     'regist_date',
            'key'=>        'publish',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('format'=> 'Y-m-d H:i:s'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'strToDate'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '>=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );
    /* <<<<<end */
} // class blg_entry
?>
