<?php
/* SVN FILE: $Id: act_cancel.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * act_cancelテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_cancelテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_act_cancel extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_cancel';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'start_month'=> array(
            'column'=>     'modified',
            'key'=>        'month',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('start'=> true),
            'required'=>   FALSE,
            'effect'=>     array('View_act_cancel', 'modify'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '>=',
        ),
        'end_month'=> array(
            'column'=>     'modified',
            'key'=>        'month',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('end'=> true),
            'required'=>   FALSE,
            'effect'=>     array('View_act_cancel', 'modify'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '<=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );
    /* <<<<<end */

    /**
     * 活動分野の設定
     *
     * @access public
     * @return void
     */
    public function getModify()
    {
        $date_format  = RKT_DB::dateFormat('modified','%Y-%m');
        $label_format = RKT_DB::dateFormat('modified','%Y/%m');
        $sql=
            'SELECT '.
                $date_format.' value,'.
                $label_format.' label '.
            'FROM '.
                DB_PREFIX.$this->tbl_name.' '.
            'GROUP BY '.
                'value '.
            'ORDER BY '.
                'value DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            $timestamp = strtotime($value['value'].'-01 00:00:00');
            $list[$timestamp] = $value['label'];
        }
        
        return $list;
    }

    /**
     * 活動分野の設定
     *
     * @access public
     * @param string    $string
     * @param array     $options
     * @return void
     */
    public static function modify($string, $options)
    {
        if (is_array($options)) {
            extract($options);
        }
        
        if (empty($string)){
            return $string;
        }
        
        if (!empty($start)){
            return date('Y-m-01 00:00:00', $string);
        }

        if (!empty($end)){
            return date('Y-m-t 23:59:59', $string);
        }
    }
} // class act_cancel
?>
