<?php
/* SVN FILE: $Id: sys_sponsor.php 160 2008-04-23 00:33:17Z bb_yujiro $ */
/**
 * sys_sponsorテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 160 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:33:17 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * sys_sponsorテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 160 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:33:17 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class sys_sponsor extends Model_Manip 
{
    /* start>>>>> */
    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * position 
     * @var number 
     */
    public $position = null;

    /**
     * sponsor 
     * @var string 
     */
    public $sponsor = null;

    /**
     * html 
     * @var string 
     */
    public $html = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'sys_sponsor';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'position'=> array(
            'column'=>    'position',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'sponsor'=> array(
            'column'=>    'sponsor',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'html'=> array(
            'column'=>    'html',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripSlashes'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'status,position,sponsor,html';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':status,:position,:sponsor,:html';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'status=:status, position=:position, sponsor=:sponsor, html=:html';
    /* <<<<<end */
} // class sys_sponsor
?>
