<?php
/* SVN FILE: $Id: rss_feed.php 342 2008-05-11 02:27:14Z bb_yujiro $ */
/**
 * rss_feedテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 342 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 11:27:14 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'PEAR/XML/RSS.php';

/**
 * rss_feedテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 342 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 11:27:14 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class rss_feed extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * title 
     * @var string 
     */
    public $title = null;

    /**
     * link 
     * @var string 
     */
    public $link = null;

    /**
     * hashed_url 
     * @var uri 
     */
    public $hashed_url = null;

    /**
     * url 
     * @var uri 
     */
    public $url = null;

    /**
     * articles 
     * @var string 
     */
    public $articles = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'rss_feed';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'title'=> array(
            'column'=>    'title',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'link'=> array(
            'column'=>    'link',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'hashed_url'=> array(
            'column'=>    'hashed_url',
            'type'=>      'uri',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'40'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'url'=> array(
            'column'=>    'url',
            'type'=>      'uri',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'articles'=> array(
            'column'=>    'articles',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,title,link,hashed_url,url,articles';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:title,:link,:hashed_url,:url,:articles';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, title=:title, link=:link, hashed_url=:hashed_url, url=:url, articles=:articles';
    /* <<<<<end */

    /**
     * Feedの設定
     *
     * @access public
     */
    public function setFeed()
    {
        $objrss = new XML_RSS($this->url);
        $objrss->parse();      // ファイルのパース処理

        /* サイト情報設定 */        
        $info = $objrss->getChannelInfo();
        $this->title = mb_convert_encoding($info['title'], ENCODE_TYPE, 'auto');
        $this->link  = $info['link'];

        /* 記事情報設定 */        
        $this->articles = array();
        foreach ($objrss->getItems() as $item){
            $title = mb_convert_encoding($item['title'], ENCODE_TYPE, 'auto');
            if (empty($item['description'])){
                $desc  = '';
            } else {
                $desc  = strip_tags($item['description']);
                $desc  = mb_convert_encoding($desc, ENCODE_TYPE, 'auto');
            }
            
            $this->articles[] = array(
                'link'=>        $item['link'],
                'title'=>       $title,
                'description'=> mb_strimwidth($desc, 0, 200, '...'),
            );
        } // foreach ($objrss->getItems() as $item)
    }

    /**
     * 初期値データへの加工処理
     *
     * @access protected
     * @retrun void
     */
    protected function initEffect()
    {
        $this->articles = unserialize($this->articles);
    }

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        $this->hashed_url = RKT_Crypt::getHashed($this->url);
        $this->articles   = serialize($this->articles);
    }
} // class rss_feed
?>
