<?php
/* SVN FILE: $Id: fri_message.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * fri_messageテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * fri_messageテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class fri_message extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * ref_origin 
     * @var number 
     */
    public $ref_origin = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * ref_to 
     * @var number 
     */
    public $ref_to = null;

    /**
     * ref_from 
     * @var number 
     */
    public $ref_from = null;

    /**
     * ref_message 
     * @var number 
     */
    public $ref_message = null;

    /**
     * flag 
     * @var number 
     */
    public $flag = null;

    /**
     * subject 
     * @var string 
     */
    public $subject = null;

    /**
     * body 
     * @var string 
     */
    public $body = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'fri_message';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '0000-00-00 00:00:00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_origin'=> array(
            'column'=>    'ref_origin',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_to'=> array(
            'column'=>    'ref_to',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_from'=> array(
            'column'=>    'ref_from',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_message'=> array(
            'column'=>    'ref_message',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'fri_message',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'flag'=> array(
            'column'=>    'flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'subject'=> array(
            'column'=>    'subject',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'body'=> array(
            'column'=>    'body',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,status,ref_origin,ref_account,ref_to,ref_from,ref_message,flag,subject,body';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:status,:ref_origin,:ref_account,:ref_to,:ref_from,:ref_message,:flag,:subject,:body';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, status=:status, ref_origin=:ref_origin, ref_account=:ref_account, ref_to=:ref_to, ref_from=:ref_from, ref_message=:ref_message, flag=:flag, subject=:subject, body=:body';
    /* <<<<<end */

    /**
     * Send Massage 
     * @var number 
     */
    public $send_massage = false;

    /**
     * 送信リスト
     * @var array 
     */
    public $to_list = null;

    /**
     * 送信リストの設定
     *
     * @access public
     * @param array $list
     */
    public function setToList($list)
    {
        $this->to_list = $list;
    }

    /**
     * 連続送信
     *
     * @access public
     */
    public function sendMultiple()
    {
        if (!is_array($this->to_list)){
            return ;
        }
        $list = $this->to_list;
        $this->to_list = null;

        $this->flag   = FLAG_UNREAD;
        $this->status = MESSAGE_INBOX;

        $this->setInsert();

        foreach ($list as $to){
            $this->to          = $to;
            $this->ref_account = $to;

            $this->manip();
        }
    }

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->status == MESSAGE_SEND){
            $this->status       = MESSAGE_SENT;
            $this->send_massage = true;
        }
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        /* 送信相手用にインサート */
        if ($this->send_massage){
            $this->send_massage = false;

            $this->regist_date = $this->modified;
            $this->ref_origin  = $this->cur_id;
            $this->ref_account = $this->ref_to;
            $this->status      = MESSAGE_INBOX;
            $this->flag        = FLAG_UNREAD;

            $this->setInsert();
            $this->manip();
            
            /* 返信メッセージの更新 */
            if (!empty($this->ref_message)){
                $this->cur_id = $this->ref_message;
                $this->setInitValue();
                $this->setUpdate();
                
                $this->flag = FLAG_RETURN;
                $this->manip();
            }
        } // if ($this->send_massage)
        
        $this->sendMultiple();
    }

    /**
     * メッセージフラグの処理
     *
     * @access public
     */
    public function messageFlag()
    {
        if ($this->status != MESSAGE_INBOX 
         && $this->status != MESSAGE_TRASH){
            return ;
        }
        if ($this->flag != FLAG_UNREAD){
            return ;
        }
        $this->flag = FLAG_READ;
        $this->setUpdate();
        $this->manip();

        /* 送り主のメッセージフラグを更新 */
        if (!empty($this->ref_origin)){
            $sql = 'UPDATE '.DB_PREFIX.$this->tbl_name.
                   ' SET flag = '.$this->objdb->quote(FLAG_READ).
                   ' WHERE id = '.$this->objdb->quote($this->ref_origin);
            $this->objdb->exec($sql);
        }
    }
} // class fri_message
?>
