<?php
/* SVN FILE: $Id: fri_invite.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * fri_inviteテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * fri_inviteテーブルクラス
 *
 * @category        Hitsuji : model
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class fri_invite extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * ref_friend 
     * @var number 
     */
    public $ref_friend = null;

    /**
     * email 
     * @var email 
     */
    public $email = null;

    /**
     * hashed_email 
     * @var email 
     */
    public $hashed_email = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * display 
     * @var number 
     */
    public $display = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'fri_invite';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_friend'=> array(
            'column'=>    'ref_friend',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'email'=> array(
            'column'=>    'email',
            'type'=>      'email',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_LOB,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'hashed_email'=> array(
            'column'=>    'hashed_email',
            'type'=>      'email',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'40'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'display'=> array(
            'column'=>    'display',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_account,ref_friend,email,hashed_email,comment,display';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_account,:ref_friend,:email,:hashed_email,:comment,:display';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_account=:ref_account, ref_friend=:ref_friend, email=:email, hashed_email=:hashed_email, comment=:comment, display=:display';
    /* <<<<<end */

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            return ;
        }

        $crypted_email = RKT_Crypt::getEncrypted($this->email);
        $hashed_email  = RKT_Crypt::getHashed($this->email);

        $this->setValue('email', $crypted_email);
        $this->setValue('hashed_email', $hashed_email);
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            return ;
        }
        if (!empty($this->ref_friend)){
            return ;
        }

        $account = RKT_DB::getRow('act_account', $this->ref_account);
        if ($account['status'] == STATUS_ADMIN){
            $code = 'registry';
        } else {
            $code = 'invitation';
        }

        include_once LIB_DIR.'rkt_message.php';
        $objsnd = RKT_Message::getInstance($code);
        $email  = RKT_Crypt::getDecrypted($this->email);
        $seed   = RKT_Crypt::getSeed($this->ref_account);
        $key    = RKT_Crypt::getKey($this->email, $seed);
        $url    = SSL_ACTION.'public/join/account/'.
                        $this->cur_id.'/'.$key.'/';

        $condition = array(
            'ref_account'=> $this->ref_account
        );
        $profile = RKT_DB::getRow('act_profile', $condition);

        $objsnd->Assign('user_name', $profile['nickname']);
        $objsnd->Assign('url',       $url);
        $objsnd->Assign('comment',   $this->comment."\r\n");
        $objsnd->send($email);
    }
} // class fri_invite
?>
