<?php
/* SVN FILE: $Id: fri_friends.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * fri_friendsテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * fri_friendsテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class fri_friends extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * ref_friend 
     * @var number 
     */
    public $ref_friend = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'fri_friends';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_friend'=> array(
            'column'=>    'ref_friend',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'htmlBody'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,status,ref_account,ref_friend,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:status,:ref_account,:ref_friend,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, status=:status, ref_account=:ref_account, ref_friend=:ref_friend, comment=:comment';
    /* <<<<<end */

    /**
     * 友達申請
     * @var number 
     */
    public $friend_throw = false;

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->status == STATUS_FRIEND_THROW){
            $this->friend_throw = true;
        }
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        /* 送信相手用にインサート */
        if ($this->friend_throw){
            $this->friend_throw = false;
            $this->_sendMessage();

            $ref_friend        = $this->ref_account;

            $this->ref_account = $this->ref_friend;
            $this->ref_friend  = $ref_friend;
            $this->status      = STATUS_FRIEND_CHATCH;

            $this->setInsert();
            $this->manip();
        } // if ($this->friend_throw)

        $this->_synchronize();
        $this->_updateFriendNumber();
    }

    /**
     * 相手との同期
     *
     * @access public
     */
    private function _synchronize()
    {
        /* 友達リストに追加 */
        if ($this->action_flag == RKT_Model::QUERY_UPDATE
        && $this->old_values['status'] == STATUS_FRIEND_CHATCH){
            $sql =
                'UPDATE '.DB_PREFIX.$this->tbl_name.' '.
                'SET status = '.STATUS_FRIEND_CONNECT.' '.
                'WHERE ref_account = '.$this->ref_friend.
                ' AND ref_friend = '.$this->ref_account;
            $this->objdb->exec($sql);
        }

        /* 相手のリストも削除 */
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            $sql =
                'DELETE FROM '.DB_PREFIX.$this->tbl_name.' '.
                'WHERE ref_account = '.$this->ref_friend.
                ' AND ref_friend = '.$this->ref_account;
            $this->objdb->exec($sql);
        }
    }

    /**
     * メッセージ送信
     *
     * @access public
     */
    private function _sendMessage()
    {
        include MODEL_DIR.'manips'.DS.'fri_message.php';
        $objmsg = new fri_message();

        $profile = RKT_DB::getRow('act_profile', $this->ref_account);
        $body  = '<a href="'.HTTP_ACTION.'member/personal/friends/';
        $body .= $this->ref_friend.'/'.US.'status='.STATUS_FRIEND_CHATCH.'" />';
        $body .= '<img src="'.BASE_URL.'resource/img/icons/user_add.gif"';
        $body .= ' width="16" height="16" align="absmiddle" />';
        $body .= _('Want to be a Friends').'</a><br /><br />';
        $body .= '<img src="'.BASE_URL.'resource/img/icons/comment.gif"';
        $body .= ' width="16" height="16" align="absmiddle" />';
        $body .= sprintf(_("%s's Comment :"), $profile['nickname']).'<br />';
        $body .= $this->comment;

        $objmsg->setValue('status',      MESSAGE_INBOX);
        $objmsg->setValue('ref_account', $this->ref_friend);
        $objmsg->setValue('ref_to',      $this->ref_friend);
        $objmsg->setValue('ref_from',    $this->ref_account);
        $objmsg->setValue('ref_message', 0);
        $objmsg->setValue('flag',        FLAG_UNREAD);
        $objmsg->setValue('subject',     _('You have a new friend request!').'('.$profile['nickname'].')');
        $objmsg->setValue('body',        $body);
        
        $objmsg->setInsert();
        $objmsg->manip();
    }

    /**
     * 友達数計測
     *
     * @access public
     */
    private function _updateFriendNumber()
    {
        /* アクンションを行ったユーザー */
        $condition = array(
            'ref_account'=> $this->ref_account,
            'status'=>      RKT_Model::CONDITION,
        );
        $row = RKT_DB::getRow('fri_friends', $condition, 'count(*) as ct');
        $sql =
            'UPDATE '.DB_PREFIX.'act_account '.
            'SET friend_number = '.$row['ct'].' '.
            'WHERE id = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 影響を受けたユーザー */
        $condition = array(
            'ref_account'=> $this->ref_friend,
            'status'=>      RKT_Model::CONDITION,
        );
        $row = RKT_DB::getRow('fri_friends', $condition, 'count(*) as ct');
        $sql =
            'UPDATE '.DB_PREFIX.'act_account '.
            'SET friend_number = '.$row['ct'].' '.
            'WHERE id = '.$this->ref_friend;
        $this->objdb->exec($sql);
    }
} // class fri_friends
?>
