<?php
/* SVN FILE: $Id: des_theme.php 352 2008-05-11 22:56:27Z bb_yujiro $ */
/**
 * des_themeテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 352 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:56:27 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * des_themeテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 352 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:56:27 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class des_theme extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * ref_author 
     * @var number 
     */
    public $ref_author = null;

    /**
     * theme 
     * @var string 
     */
    public $theme = null;

    /**
     * body 
     * @var string 
     */
    public $body = null;

    /**
     * text 
     * @var string 
     */
    public $text = null;

    /**
     * bold 
     * @var string 
     */
    public $bold = null;

    /**
     * border 
     * @var string 
     */
    public $border = null;

    /**
     * header 
     * @var string 
     */
    public $header = null;

    /**
     * bg_column 
     * @var string 
     */
    public $bg_column = null;

    /**
     * bg_header 
     * @var string 
     */
    public $bg_header = null;

    /**
     * bg_data 
     * @var string 
     */
    public $bg_data = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'des_theme';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '0000-00-00 00:00:00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_author'=> array(
            'column'=>    'ref_author',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'theme'=> array(
            'column'=>    'theme',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'body'=> array(
            'column'=>    'body',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'text'=> array(
            'column'=>    'text',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'bold'=> array(
            'column'=>    'bold',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'border'=> array(
            'column'=>    'border',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'header'=> array(
            'column'=>    'header',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'bg_column'=> array(
            'column'=>    'bg_column',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'bg_header'=> array(
            'column'=>    'bg_header',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'bg_data'=> array(
            'column'=>    'bg_data',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'6'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,ref_author,theme,body,text,bold,border,header,bg_column,bg_header,bg_data,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:ref_author,:theme,:body,:text,:bold,:border,:header,:bg_column,:bg_header,:bg_data,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, ref_author=:ref_author, theme=:theme, body=:body, text=:text, bold=:bold, border=:border, header=:header, bg_column=:bg_column, bg_header=:bg_header, bg_data=:bg_data, comment=:comment';
    /* <<<<<end */

    /**
     * functions 
     * @var array 
     */
    public $functions = array(
            'bg'=>         'imagePngBg',
            'btmMenuBg'=>  'imagePngBtmMenuBg',
            'capt'=>       'imagePngCapt',
            'footerBg'=>   'imagePngFooterBg',
            'frameBg'=>    'imagePngFrameBg',
            'headerBg'=>   'imagePngHeaderBg',
            'itemBottom'=> 'imagePngItemBottom',
            'itemTop'=>    'imagePngItemTop',
            'menubarBg'=>  'imagePngMenubarBg',
            'menuBottom'=> 'imagePngMenuBottom',
            'menuTop'=>    'imagePngMenuTop',
            'photoBg'=>    'imagePngPhotoBg',
        );

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            return ;
        }

        $this->header    = $this->_addColor($this->bold, 25);
        $this->bg_column = $this->_addColor($this->body, 50);
        $this->bg_header = $this->_addColor($this->body, 40);
        $this->bg_data   = $this->_addColor($this->body, 60);
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        include_once LIB_DIR.'rkt_blob.php';
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            $this->_deleteResource();
        } else {
            $this->_saveResource();
        }
    }

    /**
     * 画像ファイルを保存する
     *
     * @access public
     * @return void
     */
    private function _saveResource()
    {
        include_once THEME_DIR.'libs/color_functions.php';

        $objblb = RKT_Blob::getInstance();
        $objblb->setUID($this->ref_author);
        
        /* 画像の保存 */
        $objblb->setMimeType('image/png');
        foreach ($this->functions as $file=> $func){
            include_once THEME_DIR.'libs/'.$file.'.php';

            ob_start();
            call_user_func($func, $this->body);
            $buffer = ob_get_contents();
            ob_end_clean();

            $filename  = ARCHIVES_THEME_PATH.$this->cur_id.'/'.$file.'.png';

            $objblb->setBuffer($buffer);
            $objblb->save($filename);
        }

        /* CSSの保存 */
        $objblb->setMimeType('text/css');
        include_once THEME_DIR.'libs/css.php';

        ob_start();
        cssTheme ($this->cur_id, $this->text, $this->bold, $this->border);
        $buffer = ob_get_contents();
        ob_end_clean();

        $filename  = ARCHIVES_THEME_PATH.$this->cur_id.'/design.css';

        $objblb->setBuffer($buffer);
        $objblb->save($filename);
    }

    /**
     * 画像ファイルを保存する
     *
     * @access public
     * @return void
     */
    private function _deleteResource()
    {
        $objblb = RKT_Blob::getInstance();
        
        foreach ($this->functions as $file=> $func){
            $filename = ARCHIVES_THEME_PATH.$this->cur_id.'/'.$file.'.png';
            $objblb->unlink($filename);
        }
        $filename = ARCHIVES_THEME_PATH.$this->cur_id.'/design.css';
        $objblb->unlink($filename);
    }

    /**
     * アップロードされた情報をメンバ変数へセットする
     *
     * @access public
     * @param string $key
     * @return boolean 成功時真
     */
    public function uploadFile($key)
    {
        if (!isSet($_FILES[$key])) {
            return false;
        }
        if ($_FILES[$key]['error'] != UPLOAD_ERR_OK) {
            return false;
        }
        /* ファイルの種類が画像か判定 */
        if (!preg_match('/image/i', $_FILES[$key]['type'])){
            return false;
        }

        include_once LIB_DIR.'rkt_blob.php';

        $objblb = RKT_Blob::getInstance();
        $objblb->setUID($this->ref_author);
        
        $objblb->readfile($_FILES[$key]['tmp_name']);

        $filename = ARCHIVES_THEME_PATH.$this->cur_id.'/'.$key.'.png';
        $objblb->save($filename);

        return true;
    }

    /**
     * 色の計算
     *
     * @access private
     * @param string $color
     * @param integer $number
     * @return $color
     */
    private function _addColor($color, $number)
    {
        $red   = hexdec(substr($color, 0, 2));
        $green = hexdec(substr($color, 2, 2));
        $blue  = hexdec(substr($color, 4, 2));

        $red   += $number;
        $green += $number;
        $blue  += $number;

        $red   = ($red   > 255)? 255:$red;
        $green = ($green > 255)? 255:$green;
        $blue  = ($blue  > 255)? 255:$blue;

        $red   = ($red   < 0)? 0:$red;
        $green = ($green < 0)? 0:$green;
        $blue  = ($blue  < 0)? 0:$blue;

        return strtoupper(dechex($red).dechex($green).dechex($blue));
    }

} // class des_theme
?>
