<?php
/* SVN FILE: $Id: com_names.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * com_namesテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * com_namesテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class com_names extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_community 
     * @var number 
     */
    public $ref_community = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * visibility 
     * @var number 
     */
    public $visibility = null;

    /**
     * bulletin 
     * @var number 
     */
    public $bulletin = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'com_names';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_community'=> array(
            'column'=>    'ref_community',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'com_community',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'visibility'=> array(
            'column'=>    'visibility',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'bulletin'=> array(
            'column'=>    'bulletin',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'htmlBody'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_community,ref_account,status,visibility,bulletin,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_community,:ref_account,:status,:visibility,:bulletin,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_community=:ref_community, ref_account=:ref_account, status=:status, visibility=:visibility, bulletin=:bulletin, comment=:comment';
    /* <<<<<end */

    /**
     * message 
     * @var string 
     */
    public $message = null;

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->status == PERMISSION_REQUEST){
            $this->message = $this->comment;
            $this->comment = '';
        }
        if ($this->status == PERMISSION_INVITE){
            $this->setValue('status', PERMISSION_MEMBER);
        }
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        if ($this->action_flag == RKT_Model::QUERY_INSERT){
            if ($this->status == PERMISSION_REQUEST){           // 参加申請
                $this->_resquestJoin();
            }
        } elseif ($this->action_flag == RKT_Model::QUERY_UPDATE) {
            if ($this->status == PERMISSION_CHANGE){            // リーダー交代要請
                $this->_resquestChangeLeader();
            } elseif ($this->status == PERMISSION_LEADER){      // リーダーの交代
                $this->_updateLeader();
            } elseif ($this->status == PERMISSION_MEMBER &&     // リーダー交代拒否
                      $this->old_values['status'] == PERMISSION_CHANGE){
                $this->_denyLeader();
            }
        }

        $this->_updateMemberNumber();
    }

    /**
     * メッセージ送信
     *
     * @access public
     */
    private function _resquestJoin()
    {
        include_once MODEL_DIR.'manips'.DS.'fri_message.php';
        $objmsg = new fri_message();

        $profile   = RKT_DB::getRow('act_profile', $this->ref_account);
        $community = RKT_DB::getRow('com_community', $this->ref_community);

        $subject = sprintf(_('%s has requested to join %s'), $profile['nickname'], $community['community']);
        $body  = _("Please click the 'Approve or Deny' and choose Approve or Deny now.");
        $body .= '<br />';
        $body .= '<a href="'.HTTP_ACTION.'community/view/member/';
        $body .= $community['id'].'/'.US.'status='.PERMISSION_REQUEST.'" />';
        $body .= '<img src="'.BASE_URL.'resource/img/icons/group.gif"';
        $body .= ' width="16" height="16" align="absmiddle"';
        $body .= ' title="'.$community['community'].'" />';
        $body .= '['._('Approve or Deny').']('.$community['community'].')</a><br /><br />';
        $body .= _('Message').':<br />';
        $body .= $this->message;

        $objmsg->setValue('status',      MESSAGE_INBOX);
        $objmsg->setValue('ref_account', $community['ref_account']);
        $objmsg->setValue('ref_to',      $community['ref_account']);
        $objmsg->setValue('ref_from',    $this->ref_account);
        $objmsg->setValue('ref_message', 0);
        $objmsg->setValue('flag',        FLAG_UNREAD);
        $objmsg->setValue('subject',     $subject);
        $objmsg->setValue('body',        $body);
        
        $objmsg->setInsert();
        $objmsg->manip();
    }

    /**
     * メッセージ送信
     *
     * @access public
     */
    private function _resquestChangeLeader()
    {
        include_once MODEL_DIR.'manips'.DS.'fri_message.php';
        $objmsg = new fri_message();

        $community = RKT_DB::getRow('com_community', $this->ref_community);
        $profile   = RKT_DB::getRow('act_profile', $community['ref_account']);

        $subject = sprintf(_('%s has requested to the leader alternation.'), $profile['nickname'], $community['community']);
        $body  = _("Please click the 'Accept or Deny' and choose Accept or Deny now.");
        $body .= '<br />';
        $body .= '<a href="'.HTTP_ACTION.'member/personal/community/';
        $body .= $this->ref_account.'/'.US.'status='.PERMISSION_CHANGE.'" />';
        $body .= '<img src="'.BASE_URL.'resource/img/icons/leader_change.gif"';
        $body .= ' width="16" height="16" align="absmiddle"';
        $body .= ' title="'.$community['community'].'" />';
        $body .= '['._('Accept or Deny').']('.$community['community'].')</a><br /><br />';
        $body .= _('Message').':<br />';
        $body .= $this->message;

        $objmsg->setValue('status',      MESSAGE_INBOX);
        $objmsg->setValue('ref_account', $this->ref_account);
        $objmsg->setValue('ref_to',      $this->ref_account);
        $objmsg->setValue('ref_from',    $community['ref_account']);
        $objmsg->setValue('ref_message', 0);
        $objmsg->setValue('flag',        FLAG_UNREAD);
        $objmsg->setValue('subject',     $subject);
        $objmsg->setValue('body',        $body);
        
        $objmsg->setInsert();
        $objmsg->manip();
    }

    /**
     * リーダーの変更
     *
     * @access public
     */
    private function _updateLeader()
    {
        $community = RKT_DB::getRow('com_community', $this->ref_community);
        $profile   = RKT_DB::getRow('act_profile', $this->ref_account);

        /* 元リーダーの権限変更 */
        $sql =
            'UPDATE '.DB_PREFIX.'com_names '.
            'SET status = '.PERMISSION_MEMBER.' '.
            'WHERE ref_community = '.$this->ref_community.
            ' AND ref_account = '.$community['ref_account'];
        $this->objdb->exec($sql);

        /* コミュニティリーダー変更 */
        $sql =
            'UPDATE '.DB_PREFIX.'com_community '.
            'SET ref_account = '.$this->ref_account.' '.
            'WHERE id = '.$this->ref_community;
        $this->objdb->exec($sql);


        include_once MODEL_DIR.'manips'.DS.'fri_message.php';
        $objmsg = new fri_message();

        $subject = sprintf(_('Leader has been replaced by %s'), $profile['nickname']);
        $body  = sprintf(_("The leader of the '%s' was changed."), $community['community']);
        $body .= '<br />';
        $body .= '<a href="'.HTTP_ACTION.'community/view/community/';
        $body .= $community['id'].'/" />';
        $body .= '<img src="'.BASE_URL.'resource/img/icons/group.gif"';
        $body .= ' width="16" height="16" align="absmiddle"';
        $body .= ' title="'.$community['community'].'" />';
        $body .= $community['community'].'</a><br /><br />';

        $objmsg->setValue('status',      MESSAGE_INBOX);
        $objmsg->setValue('ref_account', $community['ref_account']);
        $objmsg->setValue('ref_to',      $community['ref_account']);
        $objmsg->setValue('ref_from',    $this->ref_account);
        $objmsg->setValue('ref_message', 0);
        $objmsg->setValue('flag',        FLAG_UNREAD);
        $objmsg->setValue('subject',     $subject);
        $objmsg->setValue('body',        $body);
        
        $objmsg->setInsert();
        $objmsg->manip();
    }

    /**
     * リーダーの変更
     *
     * @access public
     */
    private function _denyLeader()
    {
        $community = RKT_DB::getRow('com_community', $this->ref_community);
        $profile   = RKT_DB::getRow('act_profile', $this->ref_account);

        include_once MODEL_DIR.'manips'.DS.'fri_message.php';
        $objmsg = new fri_message();

        $subject = sprintf(_("%s refused leader's successor"), $profile['nickname']);
        $body  = sprintf(_("%s refused leader's successor."), $profile['nickname']);
        $body .= '<br />';
        $body .= sprintf(_("Please elect the leader of the %s again."), $community['community']);
        $body .= '<a href="'.HTTP_ACTION.'community/view/community/';
        $body .= $community['id'].'/" />';
        $body .= '<img src="'.BASE_URL.'resource/img/icons/group.gif"';
        $body .= ' width="16" height="16" align="absmiddle"';
        $body .= ' title="'.$community['community'].'" />';
        $body .= $community['community'].'</a><br /><br />';

        $objmsg->setValue('status',      MESSAGE_INBOX);
        $objmsg->setValue('ref_account', $community['ref_account']);
        $objmsg->setValue('ref_to',      $community['ref_account']);
        $objmsg->setValue('ref_from',    $this->ref_account);
        $objmsg->setValue('ref_message', 0);
        $objmsg->setValue('flag',        FLAG_UNREAD);
        $objmsg->setValue('subject',     $subject);
        $objmsg->setValue('body',        $body);
        
        $objmsg->setInsert();
        $objmsg->manip();
    }

    /**
     * メンバー数計測
     *
     * @access public
     */
    private function _updateMemberNumber()
    {
        $condition = array(
            'ref_community'=> $this->ref_community,
            'status'=>        array('&', PERMISSION_MEMBERS),
        );
        $row = RKT_DB::getRow('com_names', $condition, 'count(*) as ct');
        $sql =
            'UPDATE '.DB_PREFIX.'com_community '.
            'SET  member_num = '.$row['ct'].' '.
            'WHERE id = '.$this->ref_community;
        $this->objdb->exec($sql);
    }
} // class com_names
?>
