<?php
/* SVN FILE: $Id: blg_entry.php 377 2008-05-15 02:35:21Z bb_yujiro $ */
/**
 * blg_entryテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * blg_entryテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class blg_entry extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * visibility 
     * @var number 
     */
    public $visibility = null;

    /**
     * format 
     * @var number 
     */
    public $format = null;

    /**
     * posts 
     * @var number 
     */
    public $posts = null;

    /**
     * link 
     * @var string 
     */
    public $link = null;

    /**
     * tb_url 
     * @var string 
     */
    public $tb_url = null;

    /**
     * subject 
     * @var string 
     */
    public $subject = null;

    /**
     * body 
     * @var string 
     */
    public $body = null;

    /**
     * tag 
     * @var string 
     */
    public $tag = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'blg_entry';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '0000-00-00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'visibility'=> array(
            'column'=>    'visibility',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'format'=> array(
            'column'=>    'format',
            'type'=>      'number',
            'default'=>   FORMAT_HTML,
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'posts'=> array(
            'column'=>    'posts',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'link'=> array(
            'column'=>    'link',
            'type'=>      'string',
            'default'=>   NULL,
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'tb_url'=> array(
            'column'=>    'tb_url',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'subject'=> array(
            'column'=>    'subject',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'body'=> array(
            'column'=>    'body',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'htmlBody'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'tag'=> array(
            'column'=>    'tag',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,ref_account,visibility,format,posts,link,tb_url,subject,body,tag';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:ref_account,:visibility,:format,:posts,:link,:tb_url,:subject,:body,:tag';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, ref_account=:ref_account, visibility=:visibility, format=:format, posts=:posts, link=:link, tb_url=:tb_url, subject=:subject, body=:body, tag=:tag';
    /* <<<<<end */

    /**
     * RSSから記事をインポートする
     *
     * @access public
     * @param string $url
     * @param integer $ref_account
     */
    public function importRss($url)
    {
        $objrss = new XML_RSS($url);
        $objrss->parse();      // ファイルのパース処理
        
        $modified = date('Y-m-d H:i:s');

        /* 記事情報設定 */        
        foreach ($objrss->getItems() as $item){
            $title = mb_convert_encoding($item['title'], ENCODE_TYPE, 'auto');
            if (empty($item['description'])){
                $desc  = '';
            } else {
                $desc  = strip_tags($item['description']);
                $desc  = mb_convert_encoding($desc, ENCODE_TYPE, 'auto');
            }

            $this->modified    = $modified;
            $this->regist_date = $modified;
            $this->visibility  = VISIBILITY_PUBLIC;
            $this->format      = FORMAT_HTML;
            $this->posts        = 0;
            $this->link        = $item['link'];
            $this->tb_url      = '';
            $this->subject     = $title;
            $this->body        = $desc;
            $this->tag         = '';

            $this->manip();
        } // foreach ($objrss->getItems() as $item)
    }

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->column['regist_date']['option'] = array(
            'format'=> '%Y-%n-%d %H:%i:%s',
            'max'=>    array(
                date('d'),
                date('n'),
                date('Y')
            )
        );
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        $this->_manipTag();
        $this->_manipSendTB();
        $this->_manipKeyword();

        $this->_deleteEntry();
    }

    /**
     * タグの登録
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _manipTag()
    {
        if (empty($this->tag)){
            return ;
        }
        include MODEL_DIR.'manips'.DS.'blg_tag.php';
        
        $objtag = new blg_tag();

        $objtag->setValue('ref_account', $this->ref_account);
        $objtag->setValue('ref_entry',   $this->cur_id);

        $objtag->manipTags($this->tag);
    }

    /**
     * トラックバック送信
     *
     * @access public
     */
    protected function _manipSendTB()
    {
        if (empty($this->tb_url)){
            return ;
        }

        include MODEL_DIR.'manips'.DS.'blg_sendtb.php';
        $objstb = new blg_sendtb();

        $hashed_url = RKT_Crypt::getHashed($this->tb_url);

        $objstb->setValue('ref_account',  $this->ref_account);
        $objstb->setValue('ref_entry',    $this->cur_id, RKT_Model::CONDITION);
        $objstb->setValue('url',          $this->tb_url);
        $objstb->setValue('hashed_url',   $hashed_url, RKT_Model::CONDITION);

        $objstb->manip();
    }

    /**
     * キーワードの登録
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _manipKeyword()
    {
        if ($this->visibility != VISIBILITY_PUBLIC){
            return ;
        }
        /* 回数を減らすためインサート時だけ */
        if ($this->action_flag !== RKT_Model::QUERY_INSERT){
            return ;
        }

        include MODEL_DIR.'manips'.DS.'blg_keyword.php';
        
        $objwrd = new blg_keyword();

        $objwrd->setValue('ref_account', $this->ref_account);
        $objwrd->setValue('ref_entry',   $this->cur_id);

        $objwrd->parseSentence($this->body);
    }

    /**
     * 記事の削除
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _deleteEntry()
    {
        if ($this->action_flag != RKT_Model::QUERY_DELETE){
            return ;
        }
        /* コメント削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'blg_comment '.
               'WHERE ref_entry = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* トラックバック削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'blg_trackback '.
               'WHERE ref_entry = '.$this->cur_id;
        $this->objdb->exec($sql);
    }
} // class blg_entry
?>
