<?php
/* SVN FILE: $Id: act_photo.php 308 2008-05-09 22:54:23Z bb_yujiro $ */
/**
 * act_photoテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 308 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:54:23 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_photoテーブルクラス
 *
 * @category        Hitsuji : model
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 308 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:54:23 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_photo extends Model_Manip 
{
    /* start>>>>> */
    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * filename 
     * @var string 
     */
    public $filename = null;

    /**
     * width 
     * @var number 
     */
    public $width = null;

    /**
     * height 
     * @var number 
     */
    public $height = null;

    /**
     * thumbnail 
     * @var string 
     */
    public $thumbnail = null;

    /**
     * t_width 
     * @var number 
     */
    public $t_width = null;

    /**
     * t_height 
     * @var number 
     */
    public $t_height = null;

    /**
     * v_small 
     * @var string 
     */
    public $v_small = null;

    /**
     * v_width 
     * @var number 
     */
    public $v_width = null;

    /**
     * v_height 
     * @var number 
     */
    public $v_height = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_photo';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'sns_act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'filename'=> array(
            'column'=>    'filename',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'width'=> array(
            'column'=>    'width',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'height'=> array(
            'column'=>    'height',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'thumbnail'=> array(
            'column'=>    'thumbnail',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        't_width'=> array(
            'column'=>    't_width',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        't_height'=> array(
            'column'=>    't_height',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_small'=> array(
            'column'=>    'v_small',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_width'=> array(
            'column'=>    'v_width',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_height'=> array(
            'column'=>    'v_height',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'ref_account,modified,status,filename,width,height,thumbnail,t_width,t_height,v_small,v_width,v_height';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':ref_account,:modified,:status,:filename,:width,:height,:thumbnail,:t_width,:t_height,:v_small,:v_width,:v_height';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'ref_account=:ref_account, modified=:modified, status=:status, filename=:filename, width=:width, height=:height, thumbnail=:thumbnail, t_width=:t_width, t_height=:t_height, v_small=:v_small, v_width=:v_width, v_height=:v_height';
    /* <<<<<end */

    /**
     * ファイル名 
     * @var string 
     */
    public $name = null;

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        /* メイン画像か？ */
        if ($this->new_values['status'] != STATUS_PHOTO_MAIN){
            return ;
        }

        /* 全てをサブ画像に変更 */
        $sql =
            'UPDATE '.
                DB_PREFIX.$this->tbl_name.' '.
            'SET '.
                'status = '.STATUS_PHOTO_SUB.' '.
            'WHERE '.
                'ref_account = '.$this->objdb->quote($this->ref_account);
        $this->objdb->exec($sql);
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            include_once LIB_DIR.'rkt_blob.php';
            $objblb = RKT_Blob::getInstance();

            $objblb->unlink($this->old_values['filename']);
            $objblb->unlink($this->old_values['thumbnail']);
            $objblb->unlink($this->old_values['v_small']);
        } // if ($this->action_flag == RKT_Model::QUERY_DELETE)

        /* メイン画像設定の取得 */
        $condition = array(
            'status'=>      STATUS_PHOTO_MAIN,
            'ref_account'=> $this->ref_account,
        );
        $result = RKT_DB::getRow($this->tbl_name, $condition);
        if (!empty($result)){
            return ;
        }

        /* メイン以外の画像を取得 */
        $condition = array(
            'ref_account'=> $this->ref_account,
        );
        $result = RKT_DB::getRow($this->tbl_name, $condition);
        if (empty($result)){
            $sql =
                'UPDATE '.DB_PREFIX.'act_profile '.
                'SET photo = '.STATUS_DISABLE.' '.
                'WHERE ref_account = '.$this->ref_account;
            $this->objdb->exec($sql);
            return ;
        }
        
        $sql =
            'UPDATE '.DB_PREFIX.$this->tbl_name.' '.
            'SET status = '.STATUS_PHOTO_MAIN.' '.
            'WHERE id = '.$result['id'];
        $this->objdb->exec($sql);

        $sql =
            'UPDATE '.DB_PREFIX.'act_profile '.
            'SET photo = '.STATUS_ENABLE.' '.
            'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * 選択された画像ファイルをリサイズする
     *
     * @access public
     * @return boolean
     */
    public function selectedPhoto($filename)
    {
        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_Blob::getInstance();

        if (!$objblb->load($filename)){
            return false;
        }
        $mime_type = $objblb->getMimeType();
        if (!preg_match('/image/i', $mime_type)){
            return false;
        }
        
        include_once LIB_DIR.'rkt_image.php';
        $objimg = RKT_Image::getInstance();

        $binary = $objblb->getBuffer();
        $format = $objblb->getExtension();
        $objimg->setBinary($binary, $format);

        /* 大きいサイズの画像 */
        $objimg->resize(PHOTO_LARGE_SIZE, PHOTO_LARGE_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->ref_account.'/large/'.$name.'.'.$format;
        $objblb->save($filename);
        $this->filename = $filename;
        $this->width    = $infos['width'];
        $this->height   = $infos['height'];

        /* 小さいサイズの画像 */
        $objimg->resize(PHOTO_SMALL_SIZE, PHOTO_SMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->ref_account.'/small/'.$name.'.'.$format;
        $objblb->save($filename);
        $this->thumbnail = $filename;
        $this->t_width   = $infos['width'];
        $this->t_height  = $infos['height'];

        /* さらに小さいサイズの画像 */
        $objimg->resize(PHOTO_VSMALL_SIZE, PHOTO_VSMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->ref_account.'/vsmall/'.$name.'.'.$format;
        $objblb->save($filename);
        $this->v_small  = $filename;
        $this->v_width  = $infos['width'];
        $this->v_height = $infos['height'];

        return true;
    }

    /**
     * アップロードされた情報をメンバ変数へセットする
     *
     * @access public
     * @param string $key
     * @return boolean 成功時真
     */
    public function catchFile($key)
    {
        if (!isSet($_FILES[$key])) {
            return false;
        }
        if ($_FILES[$key]['error'] != UPLOAD_ERR_OK) {
            return false;
        }
        /* ファイルの種類が画像か判定 */
        if (!preg_match('/image/i', $_FILES[$key]['type'])){
            return false;
        }

        $this->filename  = $_FILES[$key]['tmp_name'];
        $this->name      = $_FILES[$key]['name'];

        $this->_saveResize();

        return true;
    }

    /**
     * アップされた画像ファイルをリサイズする
     *
     * @access public
     * @return void
     */
    private function _saveResize()
    {
        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        include_once LIB_DIR.'rkt_blob.php';
        include_once LIB_DIR.'rkt_image.php';
        $objblb = RKT_Blob::getInstance();
        $objimg = RKT_Image::getInstance();
        
        $objimg->readImage($this->filename);
        $objblb->setUID($this->ref_account);
        $extension = $objblb->getExtension($this->name);

        /* 大きいサイズの画像 */
        $objimg->resize(PHOTO_LARGE_SIZE, PHOTO_LARGE_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/large/'.$name.'.'.$extension;
        $objblb->save($filename);
        $this->filename = $filename;
        $this->width    = $infos['width'];
        $this->height   = $infos['height'];


        /* 小さいサイズの画像 */
        $objimg->resize(PHOTO_SMALL_SIZE, PHOTO_SMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/small/'.$name.'.'.$extension;
        $objblb->save($filename);
        $this->thumbnail = $filename;
        $this->t_width   = $infos['width'];
        $this->t_height  = $infos['height'];

        /* さらに小さいサイズの画像 */
        $objimg->resize(PHOTO_VSMALL_SIZE, PHOTO_VSMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/vsmall/'.$name.'.'.$extension;
        $objblb->save($filename);
        $this->v_small  = $filename;
        $this->v_width  = $infos['width'];
        $this->v_height = $infos['height'];
    }
} // class act_photo
?>
