<?php
/* SVN FILE: $Id: act_married.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * act_marriedテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_marriedテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_married extends Model_Manip 
{
    /* start>>>>> */
    /**
     * sort 
     * @var number 
     */
    public $sort = null;

    /**
     * married 
     * @var string 
     */
    public $married = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_married';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'sort'=> array(
            'column'=>    'sort',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'married'=> array(
            'column'=>    'married',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'64'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'sort,married';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':sort,:married';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'sort=:sort, married=:married';
    /* <<<<<end */
} // class act_married
?>
