<?php
/* SVN FILE: $Id: act_account.php 498 2008-05-24 11:49:37Z bb_yujiro $ */
/**
 * act_accountテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 498 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:49:37 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_accountテーブルクラス
 *
 * @category        Hitsuji : model
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 498 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:49:37 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_account extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * last_login 
     * @var date 
     */
    public $last_login = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * avail 
     * @var number 
     */
    public $avail = null;

    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * hashed_password 
     * @var string 
     */
    public $hashed_password = null;

    /**
     * email 
     * @var email 
     */
    public $email = null;

    /**
     * hashed_email 
     * @var email 
     */
    public $hashed_email = null;

    /**
     * news 
     * @var number 
     */
    public $news = null;

    /**
     * mailing 
     * @var number 
     */
    public $mailing = null;

    /**
     * footprint 
     * @var number 
     */
    public $footprint = null;

    /**
     * access_number 
     * @var number 
     */
    public $access_number = null;

    /**
     * friend_number 
     * @var number 
     */
    public $friend_number = null;

    /**
     * block 
     * @var string 
     */
    public $block = null;

    /**
     * ref_theme 
     * @var number 
     */
    public $ref_theme = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_account';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'last_login'=> array(
            'column'=>    'last_login',
            'type'=>      'date',
            'default'=>   '0000-00-00 00:00:00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '0000-00-00 00:00:00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'avail'=> array(
            'column'=>    'avail',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'hashed_password'=> array(
            'column'=>    'hashed_password',
            'type'=>      'string',
            'default'=>   NULL,
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'\w+','min_length'=>'4','max_length'=>'40'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'email'=> array(
            'column'=>    'email',
            'type'=>      'email',
            'default'=>   NULL,
            'pdo_type'=>  PDO::PARAM_LOB,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'hashed_email'=> array(
            'column'=>    'hashed_email',
            'type'=>      'email',
            'default'=>   NULL,
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'40'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'news'=> array(
            'column'=>    'news',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'mailing'=> array(
            'column'=>    'mailing',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'footprint'=> array(
            'column'=>    'footprint',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'access_number'=> array(
            'column'=>    'access_number',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'friend_number'=> array(
            'column'=>    'friend_number',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'block'=> array(
            'column'=>    'block',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_theme'=> array(
            'column'=>    'ref_theme',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'des_theme',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,last_login,regist_date,avail,status,hashed_password,email,hashed_email,news,mailing,footprint,access_number,friend_number,block,ref_theme';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:last_login,:regist_date,:avail,:status,:hashed_password,:email,:hashed_email,:news,:mailing,:footprint,:access_number,:friend_number,:block,:ref_theme';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, last_login=:last_login, regist_date=:regist_date, avail=:avail, status=:status, hashed_password=:hashed_password, email=:email, hashed_email=:hashed_email, news=:news, mailing=:mailing, footprint=:footprint, access_number=:access_number, friend_number=:friend_number, block=:block, ref_theme=:ref_theme';
    /* <<<<<end */

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            return ;
        }

        if (empty($this->email)){
            $this->hashed_email = $this->old_values['hashed_email'];
            $this->email        = $this->old_values['email'];
        } else {
            if (!empty($this->email)){
                if (empty($this->old_values['email'])){
                    $this->hashed_email = RKT_Crypt::getHashed($this->email);
                    $this->email        = RKT_Crypt::getEncrypted($this->email);
                } elseif ($this->email != $this->old_values['email']){
                    $this->hashed_email = RKT_Crypt::getHashed($this->email);
                    $this->email        = RKT_Crypt::getEncrypted($this->email);
                }
            }
        } // if (empty($this->email))

        if (empty($this->hashed_password)){
            $this->hashed_password = $this->old_values['hashed_password'];
        } else {
            if (!empty($this->hashed_password)){
                if (empty($this->old_values['hashed_password'])){
                    $this->hashed_password = RKT_Auth::getHashed($this->hashed_password);
                } elseif ($this->hashed_password != $this->old_values['hashed_password']){
                    $this->hashed_password = RKT_Auth::getHashed($this->hashed_password);
                }
            }
        } // if (empty($this->hashed_password))
    }
} // class act_account
?>
